/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class StringSubstitutionReader
extends FilterReader {
    private String search;
    private String replace;
    private int searchOffSet = -1;
    private int replaceOffset = -1;
    private int[] prefixFunction;
    private boolean useCurrentChar = false;
    private int currentChar;
    private int prevCharsMatched;
    private int charsMatched;
    private boolean endOfStream = false;

    public StringSubstitutionReader(Reader rdr, String search, String replace) {
        super(rdr);
        this.search = search;
        this.replace = replace;
        this.computeKMPPrefixFunction();
    }

    private void computeKMPPrefixFunction() {
        this.prefixFunction = new int[this.search.length()];
        this.prefixFunction[0] = 0;
        int matched = 0;
        for (int i = 1; i < this.prefixFunction.length; ++i) {
            while (matched > 0 && this.search.charAt(matched) != this.search.charAt(i)) {
                matched = this.prefixFunction[matched - 1];
            }
            if (this.search.charAt(matched) == this.search.charAt(i)) {
                // empty if block
            }
            this.prefixFunction[i] = ++matched;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.replaceOffset != -1) {
            char c = this.replace.charAt(this.replaceOffset);
            if (++this.replaceOffset == this.replace.length()) {
                this.replaceOffset = -1;
            }
            return c;
        }
        if (this.searchOffSet != -1) {
            char c = this.search.charAt(this.searchOffSet);
            if (++this.searchOffSet == this.prevCharsMatched - this.charsMatched) {
                this.searchOffSet = -1;
            }
            return c;
        }
        while (this.charsMatched < this.search.length()) {
            if (this.useCurrentChar) {
                this.useCurrentChar = false;
            } else {
                this.currentChar = this.in.read();
            }
            if (this.currentChar == this.search.charAt(this.charsMatched)) {
                ++this.charsMatched;
                continue;
            }
            if (this.charsMatched == 0) {
                return this.currentChar;
            }
            this.prevCharsMatched = this.charsMatched;
            while (this.charsMatched > 0 && this.currentChar != this.search.charAt(this.charsMatched)) {
                this.charsMatched = this.prefixFunction[this.charsMatched - 1];
            }
            this.searchOffSet = 0;
            this.useCurrentChar = true;
            return this.read();
        }
        if (this.replace.length() > 0) {
            this.replaceOffset = 0;
        }
        this.charsMatched = 0;
        return this.read();
    }

    @Override
    public int read(char[] text, int offset, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int numRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            int temp = this.read();
            if (temp == -1) {
                this.endOfStream = true;
                break;
            }
            text[i] = (char)temp;
            ++numRead;
        }
        return numRead;
    }

    @Override
    public long skip(long n) throws IOException {
        char[] c = new char[(int)n];
        int numSkipped = this.read(c);
        return numSkipped;
    }
}

