/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.XTSFilterTransformResult;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import com.cognos.xts.validation.IXTSCacheValidator;
import com.cognos.xts.validation.XTSValidatorFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class ValidatorTransform
extends AXTSInstruction
implements IXTSTransformInstruction {
    private static final String ATT_NM_VALIDATOR_LOCATION = "validatorLocation";
    private static final String ATT_NM_ENABLED = "enabled";
    private static final String ATT_NM_ACTION = "action";
    private static final String ATT_NM_ACTION_PREPARE = "prepare";
    private static final String ATT_NM_NAMESPACE = "namespace";
    private static final String ATT_VL_FALSE = "false";
    private static String validatorComponentKey = "cognos.validator";
    private static String VALIDATE_PASSED = "<status>Passed</status>";
    private static String VALIDATE_FAILED = "<status>Failed</status>";
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() {
        this.m_sIdentifier = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String namespace;
        String paramValue = UXTSInstructionUtils.getParameter(ATT_NM_ENABLED, instParams);
        if (paramValue != null && paramValue.trim().equals(ATT_VL_FALSE)) {
            return new XTSFilterTransformResult(this, body);
        }
        String result = VALIDATE_FAILED;
        Element root = null;
        boolean doPrepare = false;
        String action = UXTSInstructionUtils.getParameter(ATT_NM_ACTION, instParams);
        if (action != null && action.trim().equals(ATT_NM_ACTION_PREPARE)) {
            doPrepare = true;
        }
        if ((namespace = UXTSInstructionUtils.getParameter(ATT_NM_NAMESPACE, instParams)) != null) {
            IXTSCacheValidator validator = null;
            try {
                if (body != null) {
                    HashMap<String, String> attr = new HashMap<String, String>();
                    attr.put("name", validatorComponentKey);
                    validator = (IXTSCacheValidator)((Object)XTSValidatorFactory.getInstance().getObject(env, attr));
                    if (validator != null) {
                        String[] paramValues = (String[])instParams.get(ATT_NM_VALIDATOR_LOCATION);
                        if (paramValues != null && paramValues.length > 0) {
                            for (int i = 0; i < paramValues.length; ++i) {
                                String[] entries = paramValues[i].split("\\s+");
                                validator.addLocation(entries[0], entries[1]);
                            }
                        }
                        root = this.getRootParameter(body);
                        if (doPrepare) {
                            validator.prepare(namespace, root.elements());
                        } else {
                            validator.verify(namespace, root.elements());
                        }
                        result = VALIDATE_PASSED;
                    }
                }
            }
            catch (XTSCacheException e) {
                throw new XTSInstructionException("instruction.executefailed", e);
            }
            catch (Exception e) {
                throw new XTSInstructionException("instruction.executefailed", e);
            }
        }
        if (VALIDATE_PASSED.equals(result)) {
            return new XTSTransformResult(this, new StringReader(root.asXML()));
        }
        return new XTSTransformResult(this, new StringReader(result));
    }

    private Element getRootParameter(Reader body) throws XTSInstructionException {
        Element rootElem = null;
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        try {
            rootElem = ((SAXReader)reader.get()).read(new InputSource(body)).getRootElement();
            rootElem.detach();
        }
        catch (DocumentException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        return rootElem;
    }
}

