/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class XMLDecodeReader
extends FilterReader {
    private static final String[] KEY = new String[]{"&amp;", "&gt;", "&lt;", "&apos;", "&quot;"};
    private static final int[] VALUE = new int[]{38, 62, 60, 39, 34};
    private static final int LONGEST_KEY = 6;
    private StringBuffer buffer = new StringBuffer();
    private int bufferOffset = -1;
    private boolean endOfStream = false;

    public XMLDecodeReader(Reader rdr) {
        super(rdr);
    }

    @Override
    public int read() throws IOException {
        if (this.bufferOffset != -1) {
            char c = this.buffer.charAt(this.bufferOffset);
            if (++this.bufferOffset == this.buffer.length()) {
                this.buffer.setLength(0);
                this.bufferOffset = -1;
            }
            return c;
        }
        int c = this.in.read();
        if (c == 38) {
            do {
                this.buffer.append((char)c);
                ++this.bufferOffset;
                if (c != 59) continue;
                String match = this.buffer.toString();
                for (int i = 0; i < KEY.length; ++i) {
                    if (!match.equals(KEY[i])) continue;
                    this.buffer.setLength(0);
                    this.bufferOffset = -1;
                    return VALUE[i];
                }
            } while ((c = this.in.read()) != -1 && this.buffer.length() < 6);
            return this.read();
        }
        return c;
    }

    @Override
    public int read(char[] text, int offset, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int numRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            int temp = this.read();
            if (temp == -1) {
                this.endOfStream = true;
                break;
            }
            text[i] = (char)temp;
            ++numRead;
        }
        return numRead;
    }

    @Override
    public long skip(long n) throws IOException {
        char[] c = new char[(int)n];
        int numSkipped = this.read(c);
        return numSkipped;
    }
}

