/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class XMLEncodeReader
extends FilterReader {
    private static final char[] LESSTHAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final int MIN_BUFFER_SIZE = 32;
    private char[] buffer = null;
    private int bufferOffset = -1;
    private boolean endOfStream = false;

    public XMLEncodeReader(Reader rdr) {
        super(rdr);
    }

    @Override
    public int read() throws IOException {
        if (this.bufferOffset != -1) {
            char c = this.buffer[this.bufferOffset++];
            if (this.bufferOffset == this.buffer.length) {
                this.bufferOffset = -1;
            }
            return c;
        }
        int c = this.in.read();
        switch (c) {
            case 60: {
                this.buffer = LESSTHAN;
                this.bufferOffset = 1;
                return this.buffer[0];
            }
            case 38: {
                this.buffer = AMPERSAND;
                this.bufferOffset = 1;
                return this.buffer[0];
            }
        }
        return c;
    }

    @Override
    public int read(char[] text, int offset, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int endpos = offset + length;
        int currpos = offset;
        if (endpos - currpos > 32) {
            if (this.bufferOffset != -1) {
                int charsToWrite = this.buffer.length - this.bufferOffset;
                System.arraycopy(this.buffer, this.bufferOffset, text, currpos, charsToWrite);
                this.bufferOffset = -1;
                currpos += charsToWrite;
            }
            while (endpos - currpos > 32) {
                int writeBufSize = endpos - currpos >> 3;
                int writepos = endpos - writeBufSize;
                int totalRead = this.in.read(text, writepos, writeBufSize);
                if (totalRead == -1) {
                    this.endOfStream = true;
                    return currpos - offset;
                }
                int endwritepos = writepos + totalRead;
                while (writepos < endwritepos) {
                    char c = text[writepos];
                    switch (c) {
                        case '<': {
                            System.arraycopy(LESSTHAN, 0, text, currpos, LESSTHAN.length);
                            currpos += LESSTHAN.length;
                            break;
                        }
                        case '&': {
                            System.arraycopy(AMPERSAND, 0, text, currpos, AMPERSAND.length);
                            currpos += AMPERSAND.length;
                            break;
                        }
                        default: {
                            text[currpos++] = c;
                        }
                    }
                    ++writepos;
                }
            }
        }
        while (currpos < endpos) {
            int temp = this.read();
            if (temp == -1) {
                this.endOfStream = true;
                return currpos - offset;
            }
            text[currpos++] = (char)temp;
        }
        return currpos - offset;
    }

    @Override
    public long skip(long n) throws IOException {
        char[] c = new char[(int)n];
        int numSkipped = this.read(c);
        return numSkipped;
    }
}

