/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheetTransfomer;
import com.cognos.xts.compiler.message.XTSMessageTransformer;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.LocaleUtils;
import com.cognos.xts.util.XMLInputStreamToReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public final class XMLTransform
extends AXTSInstruction
implements IXTSTransformInstruction {
    private static final int STRING_BUFFER_SIZE = 1024;
    private static final int CHAR_BUFFER_SIZE = 4096;
    private String m_sIdentifier = null;
    private StringBuffer m_sSourceBuffer = null;
    private URIResolver m_uriResolver = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        String systemId = UXTSInstructionUtils.getParameter("systemId", instParams);
        if (systemId == null) {
            Object[] args = new String[]{this.m_sIdentifier, "systemId"};
            throw new XTSInstructionException("transformer.missingparam", args);
        }
        this.m_uriResolver = (URIResolver)instParams.get("uriResolver");
        Source source = null;
        String src = UXTSInstructionUtils.getParameter("src", instParams);
        if (src != null) {
            source = new StreamSource(new StringReader(src), systemId);
        }
        try {
            String[] logicSheets;
            String[] messageBases;
            if (source == null) {
                if (systemId.indexOf(58) == -1) {
                    String sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
                    try {
                        String name = PathUtils.buildPath(systemId);
                        InputStream is = null;
                        try {
                            is = XTSResourceManager.getInstance().getResource(name);
                        }
                        catch (XTSException e) {
                            Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, systemId};
                            throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
                        }
                        if (is == null) {
                            Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, systemId};
                            throw new XTSInstructionException("instruction.buildfullpathfailed", args);
                        }
                        source = new StreamSource(is);
                        ((StreamSource)source).setSystemId(name);
                    }
                    catch (IOException e) {
                        Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, systemId};
                        throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
                    }
                }
                source = new StreamSource(systemId);
            }
            String[] messageBaseLocalesStr = (String[])instParams.get("messageBaseLocale");
            ArrayList<Locale> messageBaseLocales = null;
            if (messageBaseLocalesStr != null) {
                messageBaseLocales = new ArrayList<Locale>();
                Locale messageBaseLocale = null;
                for (int i = 0; i < messageBaseLocalesStr.length; ++i) {
                    messageBaseLocale = LocaleUtils.toLocale(LocaleUtils.toNormalizedString(messageBaseLocalesStr[i]));
                    if (messageBaseLocale == null) continue;
                    messageBaseLocales.add(messageBaseLocale);
                }
            }
            if ((messageBases = (String[])instParams.get("messageBase")) != null) {
                ArrayList<String> msgFiles = new ArrayList<String>();
                for (int i = 0; i < messageBases.length; ++i) {
                    msgFiles.add(messageBases[i].trim());
                }
                source = XTSMessageTransformer.applyMessage(env, source, msgFiles, messageBaseLocales);
            }
            if ((logicSheets = (String[])instParams.get("logicsheet")) != null) {
                ArrayList<String> lsList = new ArrayList<String>();
                for (int i = 0; i < logicSheets.length; ++i) {
                    lsList.add(logicSheets[i]);
                }
                source = XTSLogicsheetTransfomer.applyLogicsheets(env, source, lsList, this.m_uriResolver);
            }
            if (!(source instanceof StreamSource)) {
                Object[] args = new String[]{this.m_sIdentifier, source.getClass().getName()};
                throw new XTSException("instruction.transform.xml.unsupportedobjecttype", args);
            }
            Reader reader = ((StreamSource)source).getReader();
            if (reader == null) {
                try {
                    InputStream in = ((StreamSource)source).getInputStream();
                    if (in != null) {
                        reader = XMLInputStreamToReader.convert(in);
                    } else {
                        URL url = new URL(((StreamSource)source).getSystemId());
                        reader = XMLInputStreamToReader.convert(url.openStream());
                    }
                }
                catch (Exception e) {
                    Object[] args = new String[]{this.m_sIdentifier};
                    throw new XTSInstructionException("instruction.convertxmlinputstreamtoreaderfailed", args, e);
                }
            }
            this.m_sSourceBuffer = new StringBuffer(1024);
            char[] buf = new char[4096];
            int bytesRead = reader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                this.m_sSourceBuffer.append(buf, 0, bytesRead);
                bytesRead = reader.read(buf, 0, 4096);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sIdentifier, systemId};
            throw new XTSInstructionException("transformer.compileerror", args, e);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sIdentifier, systemId};
            throw new XTSInstructionException("transformer.compileerror", args, e);
        }
    }

    @Override
    public void terminate() {
        this.m_sIdentifier = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String option;
        XTSTransformResult result = null;
        String string = option = instAtts == null ? null : (String)instAtts.get("option");
        if (option != null && (option.equals("part") || option.equals("content"))) {
            String mediaType;
            String encoding = UXTSInstructionUtils.getParameter("encoding", instParams);
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if ((mediaType = UXTSInstructionUtils.getParameter("mediaType", instParams)) == null) {
                mediaType = "text/xml";
            }
            StringBuffer defaultContentType = new StringBuffer(mediaType);
            defaultContentType.append("; ");
            defaultContentType.append("charset");
            defaultContentType.append("=");
            defaultContentType.append(encoding);
            try {
                result = new XTSTransformResult(this, new ByteArrayInputStream(this.m_sSourceBuffer.toString().getBytes(encoding)), defaultContentType.toString());
            }
            catch (UnsupportedEncodingException e) {
                Object[] args = new String[]{this.m_sIdentifier, encoding};
                throw new XTSInstructionException("instruction.transform.unsupportedencoding", args, e);
            }
        } else {
            result = new XTSTransformResult(this, new StringReader(this.m_sSourceBuffer.toString()));
        }
        return result;
    }
}

