/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstructionFactory;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import java.util.Map;

public final class XTSTransformFactory
extends AXTSInstructionFactory {
    private static final String PROPERTY_PREFIX = "transform.class.";
    private static final String CACHE_SIZE_PROPERTY_NAME = "transform.cache.size";
    private static XTSTransformFactory m_factory = new XTSTransformFactory();

    @Override
    protected String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        String[] logicSheets;
        String[] messageBases;
        StringBuilder hashKey = new StringBuilder();
        String nameParam = (String)instAtts.get("name");
        String systemIdParam = UXTSInstructionUtils.getParameter("systemId", instParams);
        if (nameParam == null) {
            Object[] args = new String[]{"name"};
            throw new XTSInstructionException("instruction.transform.missingattribute", args);
        }
        hashKey.append(LocaleUtils.toJavaString(env.getLocale())).append(nameParam).append(systemIdParam);
        String[] messageBaseLocales = (String[])instParams.get("messageBaseLocale");
        if (messageBaseLocales != null) {
            for (int i = 0; i < messageBaseLocales.length; ++i) {
                hashKey.append(messageBaseLocales[i]);
            }
        }
        if ((messageBases = (String[])instParams.get("messageBase")) != null) {
            for (int i = 0; i < messageBases.length; ++i) {
                hashKey.append(messageBases[i]);
            }
        }
        if ((logicSheets = (String[])instParams.get("logicsheet")) != null) {
            for (int i = 0; i < logicSheets.length; ++i) {
                hashKey.append(logicSheets[i]);
            }
        }
        return hashKey.toString();
    }

    public static XTSTransformFactory getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() {
        int cacheSize;
        block3: {
            cacheSize = 0;
            String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE_PROPERTY_NAME);
            if (sCacheSize != null) {
                try {
                    cacheSize = Integer.parseInt(sCacheSize);
                }
                catch (NumberFormatException e) {
                    cacheSize = super.getCacheSize();
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block3;
                    StringBuffer msg = new StringBuffer();
                    msg.append("Default cache size used for node operation factory...\n");
                    msg.append("  Reason: ").append(e.getMessage()).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                    if (logger == null) break block3;
                    logger.log(null, 8, msg.toString(), null, null);
                }
            }
        }
        return cacheSize;
    }
}

