/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;

public class XTSTransformResult
implements IXTSOutputableInstructionResult {
    private static final String DEFAULT_CONTENT_TYPE = "text/xml; charset=utf-8";
    private Object m_result = null;
    private StringBuffer m_strBuf = null;
    private String m_defaultContentType = null;
    private IXTSTransformInstruction m_parent = null;

    public XTSTransformResult(IXTSTransformInstruction parent, InputStream stream, String defaultContentType) {
        this.m_parent = parent;
        this.m_result = stream;
        this.m_defaultContentType = defaultContentType;
    }

    public XTSTransformResult(IXTSTransformInstruction parent, Reader reader) {
        this.m_parent = parent;
        this.m_result = reader;
        this.m_defaultContentType = DEFAULT_CONTENT_TYPE;
    }

    @Override
    public XTSSource getResult() {
        if (this.m_result instanceof Reader) {
            return new XTSSource((Reader)this.m_result);
        }
        return new XTSSource((InputStream)this.m_result);
    }

    @Override
    public void release() throws XTSInstructionException {
        try {
            if (this.m_result != null) {
                if (this.m_result instanceof Reader) {
                    ((Reader)this.m_result).close();
                } else {
                    ((InputStream)this.m_result).close();
                }
                this.m_result = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            if (this.m_result instanceof Reader) {
                Reader reader = (Reader)this.m_result;
                BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
                CharArrayReaderWriter copyOfWriter = new CharArrayReaderWriter();
                char[] buf = new char[4096];
                int bytesRead = reader.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    ((Writer)outputStreamWriter).write(buf, 0, bytesRead);
                    copyOfWriter.write(buf, 0, bytesRead);
                    bytesRead = reader.read(buf, 0, 4096);
                }
                ((Writer)outputStreamWriter).flush();
                copyOfWriter.flush();
                bio.writeTo(out);
                this.m_result = copyOfWriter.convert();
            } else {
                InputStream stream = (InputStream)this.m_result;
                byte[] buf = new byte[4096];
                int bytesRead = stream.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    bio.write(buf, 0, bytesRead);
                    bytesRead = stream.read(buf, 0, 4096);
                }
                bio.writeTo(out);
                this.m_result = bio.convert();
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return false;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 7;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return false;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        try {
            return new ContentType(this.m_defaultContentType);
        }
        catch (ParseException e) {
            Object[] args = new Object[]{((AXTSInstruction)((Object)this.m_parent)).getIdentifier(), this.m_defaultContentType};
            throw new XTSInstructionException("instruction.transform.invalidcontenttype", args, e);
        }
    }
}

