/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.logging;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.IXTSLoggerManager;
import com.cognos.xts.logging.XTSLoggingException;
import com.cognos.xts.properties.PropertiesManager;

public class XTSAuditLoggerManager
extends AXTSManager {
    private static final String m_identifier = "XTSAuditLoggerManager";
    public static final int NUMBER_OF_LEVELS = 5;
    public static final int LEVEL1 = 0;
    public static final int LEVEL2 = 1;
    public static final int LEVEL3 = 2;
    public static final int LEVEL4 = 3;
    public static final int LEVEL5 = 4;
    public static final int NUMBER_OF_OPERATIONS = 6;
    public static final int OPERATION_STARTSERVICE = 0;
    public static final int OPERATION_STOPSERVICE = 1;
    public static final int OPERATION_REQUEST = 2;
    public static final int OPERATION_RESPONSE = 3;
    public static final int OPERATION_UPGRADE = 4;
    public static final int OPERATION_INFO = 5;
    public static final int NUMBER_OF_FUNCTIONAL_AREAS = 2;
    public static final int AREA_SERVICE = 0;
    public static final int AREA_REQUEST = 1;
    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_ERR = "failure";
    private static final String PROPERTY = "logging.class.audit";
    private static final XTSAuditLoggerManager m_instance = new XTSAuditLoggerManager();
    public boolean[][] isEnabled = new boolean[5][2];
    private IXTSLoggerManager m_AuditLoggerManager = null;

    public static XTSAuditLoggerManager getInstance() {
        return m_instance;
    }

    private XTSAuditLoggerManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return PropertiesManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        this.m_AuditLoggerManager = null;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.isEnabled[i][j] = false;
            }
        }
        String auditClassName = PropertiesManager.getInstance().getProperty(PROPERTY);
        if (auditClassName != null && auditClassName.length() > 0) {
            try {
                this.m_AuditLoggerManager = (IXTSLoggerManager)Class.forName(auditClassName).newInstance();
                if (this.m_AuditLoggerManager != null) {
                    for (int i = 0; i < 5; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            try {
                                this.isEnabled[i][j] = this.m_AuditLoggerManager.isEnabled(i, j);
                                continue;
                            }
                            catch (XTSLoggingException e) {
                                this.isEnabled[i][j] = false;
                                System.err.println("loggerManager.initfailed: " + e.getMessage());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("loggerManager.initfailed: " + e.getMessage());
            }
        }
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_AuditLoggerManager = null;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.isEnabled[i][j] = false;
            }
        }
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public boolean isEnabled(int level, int area) {
        return this.isEnabled[level][area];
    }

    public IXTSLogger getLogger(int level, int area) {
        if (this.m_AuditLoggerManager == null) {
            return null;
        }
        try {
            return this.m_AuditLoggerManager.getLogger(level, area);
        }
        catch (XTSLoggingException e) {
            System.err.println("loggerManager.getloggerfailed: " + e.getMessage());
            return null;
        }
    }
}

