/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.logging;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.DirectoryManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class XTSDebugLog
implements IXTSDebugLog {
    private static final String OPTION_DEBUGDIR_PROPERTY_NAME = "option.debugdir";
    private static final String OPTION_DEBUGDIRSIZE_PROPERTY_NAME = "option.debugdirsize";
    private static final String OPTION_DEBUGFILELIST_PROPERTY_NAME = "option.debugfilelist";
    private static final String OPTION_DEBUGLIGHTWEIGHT_PROPERTY_NAME = "option.debugLightweight";
    private static final String OPTION_DEBUGENABLE_PROPERTY_NAME = "option.debugenable";
    private static final String DEBUG_DEBUGDIR = "./xtsdbg";
    private static final long DEBUG_DEBUGDIRSIZE = 0x6400000L;
    private static final int FILE_READ_RETRY_COUNT = 5;
    private static final int FILE_READ_RETRY_WAIT_TIME = 100;
    private static final String MANIFEST_FILENAME = "manifest.xml";
    private static final String m_component = "xts";
    private String m_baseDir = PropertiesManager.getInstance().getProperty("option.debugdir");
    private DirectoryManager m_dirManager = null;
    private boolean m_bGloballyEnabled = false;
    private boolean m_debugAll = false;
    private boolean m_lightweight = false;
    private String[] m_debug_file_names;

    public XTSDebugLog() {
        String sDebugEnable;
        String slightWeight;
        String sDebugAll;
        if (this.m_baseDir == null || this.m_baseDir.length() == 0) {
            this.m_baseDir = DEBUG_DEBUGDIR;
        }
        long maxSize = 0x6400000L;
        String sDebugDirMax = PropertiesManager.getInstance().getProperty(OPTION_DEBUGDIRSIZE_PROPERTY_NAME);
        if (sDebugDirMax != null && sDebugDirMax.length() > 0) {
            try {
                maxSize = Long.parseLong(sDebugDirMax) * 0x100000L;
            }
            catch (Exception e) {
                maxSize = 0x6400000L;
            }
        }
        if ((sDebugAll = PropertiesManager.getInstance().getProperty("option.debugallrequest")) != null && sDebugAll.equals("true")) {
            this.m_debugAll = true;
        }
        if ((slightWeight = PropertiesManager.getInstance().getProperty(OPTION_DEBUGLIGHTWEIGHT_PROPERTY_NAME)) != null && slightWeight.equals("true")) {
            this.m_lightweight = true;
        }
        if ((sDebugEnable = PropertiesManager.getInstance().getProperty(OPTION_DEBUGENABLE_PROPERTY_NAME)) != null && sDebugEnable.equals("true")) {
            this.m_bGloballyEnabled = true;
        }
        this.m_dirManager = new DirectoryManager(maxSize, MANIFEST_FILENAME);
        this.m_dirManager.scan(new File(this.m_baseDir));
        if (this.m_bGloballyEnabled) {
            this.getDebugFileNames();
        }
    }

    private String[] getDebugFileNames() {
        if (this.m_debug_file_names == null) {
            HashSet<String> dfn = new HashSet<String>();
            try {
                String file_names = PropertiesManager.getInstance().getProperty(OPTION_DEBUGFILELIST_PROPERTY_NAME);
                if (file_names != null) {
                    StringTokenizer files = new StringTokenizer(file_names, ",");
                    while (files.hasMoreTokens()) {
                        String file_name = files.nextToken();
                        dfn.add(file_name);
                    }
                } else {
                    dfn = null;
                }
            }
            catch (Exception e) {
                System.err.println("debug log warning: " + e.getMessage());
            }
            this.m_debug_file_names = dfn == null ? null : dfn.toArray(new String[dfn.size()]);
        }
        return this.m_debug_file_names;
    }

    @Override
    public boolean logForMorphlet(String path) {
        boolean write_file = false;
        String[] files = this.getDebugFileNames();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length && !write_file; ++i) {
                if (path.indexOf(files[i]) == -1) continue;
                write_file = true;
            }
        } else {
            write_file = true;
        }
        return write_file;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.m_bGloballyEnabled;
    }

    @Override
    public synchronized String getBaseDirPath() {
        return this.m_baseDir;
    }

    @Override
    public synchronized void log(XTSEnvironment env, String target, String name, Document data) {
        this.log(env, target, name, data.asXML());
    }

    @Override
    public synchronized void log(XTSEnvironment env, String target, String name, Element data) {
        this.log(env, target, name, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + data.asXML());
    }

    @Override
    public synchronized void log(XTSEnvironment env, String target, String name, String content) {
        this.write(target, name, content);
    }

    @Override
    public synchronized void log(XTSEnvironment env, String target, String name, byte[] content) {
        this.write(target, name, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void generateManifest(String target) {
        File dirpathFile = new File(target);
        if (!dirpathFile.exists()) {
            return;
        }
        File[] filelist = dirpathFile.listFiles();
        if (filelist == null || filelist.length == 0) {
            dirpathFile.delete();
            return;
        }
        this.write(target, MANIFEST_FILENAME, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        String folderlist = target.substring(this.m_baseDir.length());
        StringTokenizer st = new StringTokenizer(folderlist, File.separator);
        StringBuffer currentPath = new StringBuffer();
        currentPath.append(this.m_baseDir);
        currentPath.append(File.separator);
        int count = st.countTokens();
        while (st.hasMoreTokens()) {
            Document timingDoc;
            String token;
            block14: {
                token = st.nextToken();
                currentPath.append(token);
                currentPath.append(File.separator);
                timingDoc = null;
                try {
                    File timingFile = new File(currentPath + File.separator + "timing.xml");
                    if (!timingFile.exists()) break block14;
                    FileInputStream fin = new FileInputStream(timingFile);
                    if (fin.available() <= 0) {
                        int readcount = 0;
                        while (fin.available() <= 0 && readcount < 5) {
                            ++readcount;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                System.err.println("debug log warning: " + e.getMessage());
                            }
                        }
                    }
                    AXTSPoolObject reader = XTSSAXReaderPool.getInstance().acquire();
                    try {
                        timingDoc = ((SAXReader)reader.get()).read((Reader)new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8")));
                    }
                    finally {
                        XTSSAXReaderPool.getInstance().put(reader);
                    }
                }
                catch (Exception e) {
                    System.err.println("debug log warning: " + e.getMessage());
                }
            }
            StringBuffer output = new StringBuffer().append("<folder name=\"").append(token).append("\"");
            if (timingDoc != null) {
                output.append(" timing-duration=\"");
                output.append(timingDoc.getRootElement().element("elapse").getText());
                output.append("\"");
            }
            output.append(">").toString();
            this.write(target, MANIFEST_FILENAME, output.toString());
        }
        this.dump(target, dirpathFile);
        for (int i = 0; i < count; ++i) {
            this.write(target, MANIFEST_FILENAME, "</folder>");
        }
        this.m_dirManager.add(dirpathFile);
    }

    private synchronized void write(String strFullPath, String fileName, String content) {
        try {
            this.write(strFullPath, fileName, content.getBytes("UTF-8"));
        }
        catch (IOException e) {
            System.err.println("debug log error: " + e.getMessage());
        }
    }

    private synchronized void write(String strFullPath, String fileName, byte[] content) {
        File path = new File(strFullPath);
        path.mkdirs();
        File logFile = new File(strFullPath, fileName);
        try {
            logFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println("debug log warning: " + e.getMessage());
        }
        String filePath = new StringBuffer().append(strFullPath).append(File.separator).append(fileName).toString();
        try {
            FileOutputStream fos = new FileOutputStream(filePath, true);
            fos.write(content);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            System.err.println("debug log warning: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dump(String baseDir, File path) {
        File[] files = path.listFiles();
        int numFiles = files.length;
        for (int i = 0; i < numFiles; ++i) {
            if (files[i].isDirectory()) {
                Document timingDoc;
                block12: {
                    timingDoc = null;
                    try {
                        File timingFile = new File(files[i].getCanonicalPath() + File.separator + "timing.xml");
                        if (!timingFile.exists()) break block12;
                        FileInputStream fin = new FileInputStream(timingFile);
                        if (fin.available() <= 0) {
                            int readcount = 0;
                            while (fin.available() <= 0 && readcount < 5) {
                                ++readcount;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception e) {
                                    System.err.println("debug log warning: " + e.getMessage());
                                }
                            }
                        }
                        AXTSPoolObject reader = XTSSAXReaderPool.getInstance().acquire();
                        try {
                            timingDoc = ((SAXReader)reader.get()).read((Reader)new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8")));
                        }
                        finally {
                            XTSSAXReaderPool.getInstance().put(reader);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("debug log warning: " + e.getMessage());
                    }
                }
                StringBuffer output = new StringBuffer().append("<folder name=\"").append(files[i].getName()).append("\"");
                if (timingDoc != null) {
                    output.append(" timing-duration=\"");
                    output.append(timingDoc.getRootElement().element("elapse").getText());
                    output.append("\"");
                }
                output.append(">").toString();
                this.write(baseDir, MANIFEST_FILENAME, output.toString());
                this.dump(baseDir, files[i]);
                this.write(baseDir, MANIFEST_FILENAME, "</folder>");
                continue;
            }
            String output = new StringBuffer().append("<item name=\"").append(files[i].getName()).append("\"/>").toString();
            this.write(baseDir, MANIFEST_FILENAME, output);
        }
    }

    @Override
    public boolean isDebugAll() {
        return this.m_debugAll;
    }

    @Override
    public boolean isLightweight() {
        return this.m_lightweight;
    }
}

