/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.logging;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.properties.PropertiesManager;
import java.util.Locale;

public final class XTSDebugManager
extends AXTSManager {
    private static final String m_identifier = "XTSDebugManager";
    private static final String PROPERTY = "logging.class.debug";
    private static final XTSDebugManager m_instance = new XTSDebugManager();
    private IXTSDebugLog m_debug = null;
    public boolean isEnabledDebug = false;

    public static XTSDebugManager getInstance() {
        return m_instance;
    }

    private XTSDebugManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        if (!PropertiesManager.getInstance().isInitialized()) {
            return false;
        }
        return MessagesManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        this.m_debug = null;
        this.isEnabledDebug = false;
        String debugClassName = PropertiesManager.getInstance().getProperty(PROPERTY);
        if (debugClassName != null && debugClassName.length() > 0) {
            try {
                this.m_debug = (IXTSDebugLog)Class.forName(debugClassName).newInstance();
                if (this.m_debug != null) {
                    this.isEnabledDebug = this.m_debug.isEnabled();
                }
            }
            catch (Exception e) {
                Object[] args = new String[]{debugClassName, e.getMessage()};
                System.err.println(MessagesManager.getInstance().getMessage(Locale.getDefault(), "loggerManager.initfailed", args));
            }
        }
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_debug = null;
        this.isEnabledDebug = false;
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public IXTSDebugLog getLogger() {
        return this.m_debug;
    }

    public String generateDirName(int instrOrder, String instrName, String instrId) {
        StringBuffer nameBuf = new StringBuffer();
        if (instrOrder >= 0) {
            if (instrOrder <= 9) {
                nameBuf.append("0");
                nameBuf.append(instrOrder);
            } else {
                nameBuf.append(instrOrder);
            }
        }
        if (instrName != null) {
            if (nameBuf.length() > 0) {
                nameBuf.append("-");
            }
            nameBuf.append(instrName);
        }
        if (instrId != null) {
            if (nameBuf.length() > 0) {
                nameBuf.append("-");
            }
            nameBuf.append(instrId);
        }
        return nameBuf.toString();
    }
}

