/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.logging;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.IXTSLoggerManager;
import com.cognos.xts.logging.XTSLoggingException;
import com.cognos.xts.properties.PropertiesManager;

public class XTSPerfLoggerManager
extends AXTSManager {
    private static final String m_identifier = "XTSPerfLoggerManager";
    public static final int NUMBER_OF_LEVELS = 5;
    public static final int LEVEL1 = 0;
    public static final int LEVEL2 = 1;
    public static final int LEVEL3 = 2;
    public static final int LEVEL4 = 3;
    public static final int LEVEL5 = 4;
    public static final int NUMBER_OF_OPERATIONS = 8;
    public static final int OPERATION_START = 0;
    public static final int OPERATION_FINISH = 1;
    public static final int OPERATION_ENTER = 2;
    public static final int OPERATION_EXIT = 3;
    public static final int OPERATION_CALL = 4;
    public static final int OPERATION_RETURN = 5;
    public static final int OPERATION_BEGIN = 6;
    public static final int OPERATION_LOG = 7;
    public static final int NUMBER_OF_FUNCTIONAL_AREAS = 1;
    public static final int AREA_PERF = 0;
    private static final String PROPERTY = "logging.class.performance";
    private static final XTSPerfLoggerManager m_instance = new XTSPerfLoggerManager();
    public boolean[][] isEnabled = new boolean[5][1];
    private IXTSLoggerManager m_PerfLoggerManager = null;

    public static XTSPerfLoggerManager getInstance() {
        return m_instance;
    }

    private XTSPerfLoggerManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return PropertiesManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        this.m_PerfLoggerManager = null;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 1; ++j) {
                this.isEnabled[i][j] = false;
            }
        }
        String perfClassName = PropertiesManager.getInstance().getProperty(PROPERTY);
        if (perfClassName != null && perfClassName.length() > 0) {
            try {
                this.m_PerfLoggerManager = (IXTSLoggerManager)Class.forName(perfClassName).newInstance();
                if (this.m_PerfLoggerManager != null) {
                    for (int i = 0; i < 5; ++i) {
                        for (int j = 0; j < 1; ++j) {
                            try {
                                this.isEnabled[i][j] = this.m_PerfLoggerManager.isEnabled(i, j);
                                continue;
                            }
                            catch (XTSLoggingException e) {
                                this.isEnabled[i][j] = false;
                                System.err.println("loggerManager.initfailed: " + e.getMessage());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("loggerManager.initfailed: " + e.getMessage());
            }
        }
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_PerfLoggerManager = null;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 1; ++j) {
                this.isEnabled[i][j] = false;
            }
        }
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public boolean isEnabled(int level, int area) {
        return this.isEnabled[level][area];
    }

    public IXTSLogger getLogger(int level, int area) {
        if (this.m_PerfLoggerManager == null) {
            return null;
        }
        try {
            return this.m_PerfLoggerManager.getLogger(level, area);
        }
        catch (XTSLoggingException e) {
            System.err.println("loggerManager.getloggerfailed: " + e.getMessage());
            return null;
        }
    }
}

