/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.messages;

import com.cognos.i18n.MessageFormat;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class MessagesManager
extends AXTSManager {
    private static final String m_identifier = "MessagesManager";
    private static final String PROPERTY_MSGFILES = "resource.msgfiles";
    private static String m_bootstrapMsgFile = "xtsmsgs";
    private static final MessagesManager m_instance = new MessagesManager();
    private HashMap m_oMsgResourceMap = new HashMap();
    private HashMap m_oMsgFormatterMap = new HashMap();
    private String m_msgFileList = null;

    public static MessagesManager getInstance() {
        return m_instance;
    }

    private MessagesManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return PropertiesManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        this.m_msgFileList = PropertiesManager.getInstance().getProperty(PROPERTY_MSGFILES);
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_oMsgResourceMap.clear();
        this.m_oMsgFormatterMap.clear();
        this.m_msgFileList = null;
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public String getMessage(Locale locale, String key) {
        if (!this.m_bInitialized) {
            return new String(key);
        }
        ArrayList msgFilesList = this.getMsgFiles(locale);
        if (msgFilesList == null) {
            return new String(key);
        }
        String msg = null;
        for (int i = 0; i < msgFilesList.size(); ++i) {
            ResourceBundle bundle = (ResourceBundle)msgFilesList.get(i);
            try {
                msg = bundle.getString(key);
                if (msg == null) continue;
                return msg;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[2][0]) {
            StringBuffer logmsg = new StringBuffer();
            logmsg.append("No message found...\n");
            logmsg.append("  key: ").append(key).append("\n");
            IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
            if (logger != null) {
                logger.log(null, 8, logmsg.toString(), null, null);
            }
        }
        return new String(key);
    }

    public String getMessage(String lang, String key) {
        return this.getMessage(new Locale(lang, ""), key);
    }

    public String getMessage(Locale locale, String key, Object[] args) {
        if (!this.m_bInitialized) {
            return new String(key);
        }
        String sMsgFormat = this.getMessage(locale, key);
        if (sMsgFormat == null) {
            return new String(key);
        }
        MessageFormat formatter = this.getMsgFormatter(locale);
        if (formatter == null) {
            return new String(key);
        }
        StringBuffer newMsgFormat = new StringBuffer(sMsgFormat.length());
        int idx = 0;
        while ((idx = sMsgFormat.indexOf(39)) != -1) {
            newMsgFormat.append(sMsgFormat.substring(0, idx));
            newMsgFormat.append("''");
            sMsgFormat = sMsgFormat.substring(idx + 1);
        }
        newMsgFormat.append(sMsgFormat);
        formatter.applyPattern(newMsgFormat.toString());
        return formatter.format(args).toString();
    }

    public String getMessage(String lang, String key, Object[] args) {
        return this.getMessage(new Locale(lang, ""), key, args);
    }

    public String getBootStrapMessage(Locale locale, String key) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(m_bootstrapMsgFile, locale);
            String msg = bundle.getString(key);
            if (msg == null) {
                if (XTSTraceLoggerManager.getInstance().isEnabled[2][0]) {
                    StringBuffer logmsg = new StringBuffer();
                    logmsg.append("No message found...\n");
                    logmsg.append("  key: ").append(key).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
                    if (logger != null) {
                        logger.log(null, 8, logmsg.toString(), null, null);
                    }
                }
                return new String(key);
            }
            return msg;
        }
        catch (MissingResourceException e) {
            if (XTSTraceLoggerManager.getInstance().isEnabled[2][0]) {
                StringBuffer logmsg = new StringBuffer();
                logmsg.append("No resource found...\n");
                logmsg.append("  resource: ").append(m_bootstrapMsgFile).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
                if (logger != null) {
                    logger.log(null, 8, logmsg.toString(), null, null);
                }
            }
            return new String(key);
        }
    }

    private synchronized MessageFormat getMsgFormatter(Locale locale) {
        String mapkey = LocaleUtils.toJavaString(locale);
        if (!this.m_oMsgFormatterMap.containsKey(mapkey)) {
            MessageFormat oMsgFormatter = new MessageFormat("");
            oMsgFormatter.setLocale(locale);
            this.m_oMsgFormatterMap.put(LocaleUtils.toJavaString(locale), oMsgFormatter);
            return oMsgFormatter;
        }
        return (MessageFormat)this.m_oMsgFormatterMap.get(mapkey);
    }

    private synchronized ArrayList getMsgFiles(Locale locale) {
        String mapkey = LocaleUtils.toJavaString(locale);
        if (!this.m_oMsgResourceMap.containsKey(mapkey)) {
            ArrayList<ResourceBundle> list = new ArrayList<ResourceBundle>();
            StringTokenizer msgtkn = new StringTokenizer(this.m_msgFileList, ",");
            while (msgtkn.hasMoreTokens()) {
                String msgfile = msgtkn.nextToken().trim();
                try {
                    list.add(ResourceBundle.getBundle(msgfile, locale));
                }
                catch (MissingResourceException e) {
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[2][0]) continue;
                    StringBuffer msg = new StringBuffer();
                    msg.append("No resource found...\n");
                    msg.append("  resource: ").append(msgfile).append("\n");
                    msg.append("  locale: ").append(locale.toString()).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
                    if (logger == null) continue;
                    logger.log(null, 8, msg.toString(), null, null);
                }
            }
            this.m_oMsgResourceMap.put(mapkey, list);
            return list;
        }
        return (ArrayList)this.m_oMsgResourceMap.get(mapkey);
    }
}

