/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.output;

import com.cognos.xts.XTSProcessor;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class XTSConstants {
    public static final String XTS_OUTPUT_SPEC_NAMESPACE_URI = "http://developer.cognos.com/schemas/xts/output/";
    public static final String XTS_OUTPUT_SPEC_NAMESPACE_PREFIX = "xos";
    public static final Namespace XTS_OUTPUT_SPEC_NAMESPACE = new Namespace("xos", "http://developer.cognos.com/schemas/xts/output/");
    public static final String ELEM_NM_OUTPUT = "output";
    public static final QName ELEM_NM_PART = new QName("part", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_ENTITYHEADER = new QName("entityHeader", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_ENTITYBODY = new QName("entityBody", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_PARAM = new QName("param", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_CONTENT = new QName("content", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_PROTOCOLHEADER = new QName("protocolHeader", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_OUTPUTHEADER = new QName("outputHeader", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_SETUSERSESSION = new QName("setUserSession", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_STATUSCODE = new QName("statusCode", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final QName ELEM_NM_STATUS = new QName("status", XTS_OUTPUT_SPEC_NAMESPACE);
    public static final String ELEM_VL_PARAM_OPTION_PART = "part";
    public static final String ELEM_VL_PARAM_OPTION_XML = "xml";
    public static final String ELEM_VL_PARAM_OPTION_CONTENT = "content";
    public static final String ELEM_VL_PARAM_OPTION_XML_PART = "xml-part";
    public static final String ELEM_VL_PARAM_OPTION_XML_MULTIPART = "xml-multipart";
    public static final String ELEM_VL_PARAM_OPTION_MULTIPART = "multipart";
    public static final String ATT_NM_NAME = "name";
    public static final String ATT_NM_MIMETYPE = "mimeType";
    public static final String ATT_NM_ID = "id";
    public static final String ATT_NM_REFID = "refId";
    public static final String ATT_NM_INVALIDATE = "invalidate";
    public static final String ATT_VL_CONTENT_TYPE = "Content-Type";
    public static final String ATT_VL_CONTENT_ID = "Content-ID";
    public static final String ATT_VL_CONTENT_LENGTH = "Content-Length";
    public static final String ATT_VL_CONTENT_ENCODING = "Content-Encoding";
    public static final String ATT_VL_CONTENT_CACHECONTROL = "Cache-Control";
    public static final String ATT_VL_SET_COOKIE = "Set-Cookie";
    public static final String ATT_VL_LOCATION = "Location";
    public static final String ATT_VL_PARAM_OPTION = "option";
    public static final String ATT_VL_PARAM_CONTENTID = "contentId";
    public static final String ATT_VL_PARAM_PARTID = "partId";
    public static final String ATT_VL_PARAM_MIMETYPE = "mimeType";
    public static final String ATT_VL_PARAM_OUTPUTHEADER = "outputHeader";
    public static final String ATT_VL_PARAM_PROTOCOLHEADER = "protocolHeader";
    public static final String ATT_VL_SETSOAPHEADER = "setSoapHeader";
    public static final String ATT_VL_INVALIDATE_TRUE = "true";
    public static final String ATT_VL_PARAM_STATUSCODE = "statusCode";
    public static final String ATT_VL_PARAM_STATUSTEXT = "statusText";
    public static final QName QNAME_XTS_OUTPUT_PARAM = new QName("output-param", XTSProcessor.XTS_NAMESPACE);
    public static final String MIME_HEADER_FIELD_PREFIX = "Content-";

    public static Element getParamContentTypeElement(Element header) {
        if (header == null) {
            return null;
        }
        List paramList = header.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_CONTENT_TYPE)) continue;
            return paramEle;
        }
        return null;
    }

    public static Element getParamCacheControlElement(Element header) {
        if (header == null) {
            return null;
        }
        List paramList = header.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_CONTENT_CACHECONTROL)) continue;
            return paramEle;
        }
        return null;
    }

    public static Element getEntityHeaderParamContentTypeElement(Element part) {
        if (part == null) {
            return null;
        }
        return XTSConstants.getParamContentTypeElement(part.element(ELEM_NM_ENTITYHEADER));
    }

    public static Element getPartLast(Element output) {
        if (output == null) {
            return null;
        }
        List partList = output.elements(ELEM_NM_PART);
        if (partList.size() > 0) {
            return (Element)partList.get(partList.size() - 1);
        }
        return null;
    }

    public static Element getPartEntityHeaderParamContentIDElement(Element output) {
        if (output == null) {
            return null;
        }
        return XTSConstants.getEntityHeaderParamContentIDElement(output.element(ELEM_NM_PART));
    }

    public static Element getParamContentIDElement(Element header) {
        if (header == null) {
            return null;
        }
        List paramList = header.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_CONTENT_ID)) continue;
            return paramEle;
        }
        return null;
    }

    public static Element getEntityHeaderParamContentIDElement(Element part) {
        if (part == null) {
            return null;
        }
        return XTSConstants.getParamContentIDElement(part.element(ELEM_NM_ENTITYHEADER));
    }

    public static List getParamSetSoapHeaderList(Element protocolHdr) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (protocolHdr == null) {
            return ret;
        }
        List paramList = protocolHdr.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_SETSOAPHEADER)) continue;
            ret.add(paramEle);
        }
        return ret;
    }

    public static List getProtocolHeaderParamSetSoapHeaderList(Element output) {
        if (output == null) {
            return new ArrayList();
        }
        return XTSConstants.getParamSetSoapHeaderList(output.element(ELEM_NM_PROTOCOLHEADER));
    }

    public static Element getStatusCodeElement(Element output) {
        if (output == null) {
            return null;
        }
        return output.element(ELEM_NM_STATUSCODE);
    }

    public static Element getStatusElement(Element output) {
        if (output == null) {
            return null;
        }
        return output.element(ELEM_NM_STATUS);
    }

    public static Element getParamStatusCodeHeaderElement(Element header) {
        if (header == null) {
            return null;
        }
        List paramList = header.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_PARAM_STATUSCODE)) continue;
            return paramEle;
        }
        return null;
    }

    public static Element getParamStatusTextHeaderElement(Element header) {
        if (header == null) {
            return null;
        }
        List paramList = header.elements(ELEM_NM_PARAM);
        for (int i = 0; i < paramList.size(); ++i) {
            Element paramEle = (Element)paramList.get(i);
            String att = paramEle.attributeValue(ATT_NM_NAME);
            if (att == null || !att.equals(ATT_VL_PARAM_STATUSTEXT)) continue;
            return paramEle;
        }
        return null;
    }
}

