/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.output;

import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.xml.sax.Attributes;

public final class XTSOutputContext {
    public static final int OPTION_NONE = 0;
    public static final int OPTION_XML = 1;
    public static final int OPTION_CONTENT = 2;
    public static final int OPTION_PART = 4;
    public static final int OPTION_XML_MULTIPART = 8;
    public static final int OPTION_MULTIPART = 16;
    public static final String PROPERTY_OPTION = "option";
    public static final String PROPERTY_PROTOCOLHEADER = "protocolHeader";
    public static final String PROPERTY_PROTOCOLHEADERSELECT = "protocolHeaderSelect";
    public static final String PROPERTY_PARTID = "partId";
    public static final String PROPERTY_CONTENTID = "contentId";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_MIMETYPE = "mimeType";
    public static final String PROPERTY_CACHECONTROL = "cacheControl";
    private static final String MIMETYPE_DEFAULT = "text/xml; charset=utf-8";
    private int m_iOptionMode = 1;
    private String m_sMimeType = null;
    private String m_sContentId = null;
    private String m_sPartId = null;
    private boolean m_bProtocolHeader = false;
    private String m_sProtocolHeaderSelect = null;
    private String m_sOptionString = null;
    private String m_sCacheControl = null;

    public XTSOutputContext() {
    }

    public XTSOutputContext(Attributes atts) throws XTSException {
        int attlen = atts.getLength();
        for (int i = 0; i < attlen; ++i) {
            this.setProperty(atts.getLocalName(i), atts.getValue(i));
        }
    }

    public XTSOutputContext(Element instrElem, int defaultOption) throws XTSException {
        this.m_iOptionMode = defaultOption;
        this.m_sOptionString = XTSOutputContext.getOptionString(defaultOption);
        Attribute att = null;
        List attsList = instrElem.attributes();
        int attlen = attsList.size();
        for (int i = 0; i < attlen; ++i) {
            att = (Attribute)attsList.get(i);
            this.setProperty(att.getName(), att.getValue());
        }
        if (this.m_sMimeType == null) {
            this.m_sMimeType = MIMETYPE_DEFAULT;
        }
    }

    public void setProperty(String property, String value) throws XTSException {
        if (property.equals(PROPERTY_OPTION)) {
            if (value.equals("xml")) {
                this.m_iOptionMode = 1;
            } else if (value.equals("content")) {
                this.m_iOptionMode = 2;
            } else if (value.equals("part")) {
                this.m_iOptionMode = 4;
            } else if (value.equals("xml-part") || value.equals("xml-multipart")) {
                this.m_iOptionMode = 8;
            } else if (value.equals("multipart")) {
                this.m_iOptionMode = 16;
            } else {
                Object[] args = new String[]{value};
                throw new XTSException("output.invalidoptionvalue", args);
            }
            this.m_sOptionString = value;
        } else if (property.equals(PROPERTY_PROTOCOLHEADER)) {
            if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                this.m_bProtocolHeader = true;
            }
        } else if (property.equals(PROPERTY_PROTOCOLHEADERSELECT)) {
            this.m_sProtocolHeaderSelect = value.trim().length() == 0 ? null : value.trim();
        } else if (property.equals(PROPERTY_PARTID)) {
            this.m_sPartId = value;
        } else if (property.equals(PROPERTY_CONTENTID)) {
            this.m_sContentId = value;
        } else if (property.equals(PROPERTY_MIMETYPE)) {
            this.setMimeType(value);
        } else if (property.equals(PROPERTY_ID)) {
            if (this.m_sPartId == null) {
                this.m_sPartId = value;
            }
            if (this.m_sContentId == null) {
                this.m_sContentId = value;
            }
        } else if (property.equals(PROPERTY_CACHECONTROL)) {
            this.m_sCacheControl = value;
        }
    }

    public String getCacheControl() {
        return this.m_sCacheControl;
    }

    public int getOption() {
        return this.m_iOptionMode;
    }

    public String getMimeType() {
        return this.m_sMimeType;
    }

    private void setMimeType(String type) {
        block3: {
            try {
                ContentType ct = new ContentType(type);
                if (ct.getPrimaryType().equals("text") && (null == ct.getParameterList() || null == ct.getParameterList().get("charset"))) {
                    ct.setParameter("charset", "utf-8");
                }
                this.m_sMimeType = ct.toString();
            }
            catch (ParseException e) {
                this.m_sMimeType = MIMETYPE_DEFAULT;
                if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block3;
                StringBuffer msg = new StringBuffer();
                msg.append("Default mime type: ").append(MIMETYPE_DEFAULT);
                msg.append(" will be used due to parsing error: ").append(e.getMessage()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                if (logger == null) break block3;
                logger.log(null, 8, msg.toString(), null, null);
            }
        }
    }

    public String getContentId() {
        return this.m_sContentId;
    }

    public String getPartId() {
        return this.m_sPartId;
    }

    public boolean isProtocolHeader() {
        return this.m_bProtocolHeader;
    }

    public String getProtocolHeaderSelect() {
        return this.m_sProtocolHeaderSelect;
    }

    public String getOptionString() {
        return this.m_sOptionString;
    }

    private static String getOptionString(int option) throws XTSException {
        switch (option) {
            case 4: {
                return "part";
            }
            case 2: {
                return "content";
            }
            case 1: {
                return "xml";
            }
            case 8: {
                return "xml-multipart";
            }
        }
        Object[] args = new String[]{Integer.toString(option)};
        throw new XTSException("output.unrecognizedoptionparam", args);
    }
}

