/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.output;

import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class XTSOutputObject {
    private static final int CONVERSION_BUFFER_SIZE = 4096;
    private InputStream m_in = null;
    private boolean m_bInMemory = false;
    private int m_iStreamStize = -1;
    private IXTSOutputableInstructionResult m_instResultObj = null;
    private ArrayList m_childResultList = new ArrayList();

    public XTSOutputObject(InputStream in) {
        this.m_in = in;
    }

    public XTSOutputObject(IXTSOutputableInstructionResult instResultObj) {
        this.m_instResultObj = instResultObj;
    }

    public XTSOutputObject(IXTSOutputableInstructionResult instResultObj, List childResultList) {
        this.m_instResultObj = instResultObj;
        this.m_childResultList.addAll(childResultList);
        childResultList.clear();
    }

    public boolean isInMemory() {
        return this.m_bInMemory;
    }

    public void setInMemory(boolean inMemory) {
        this.m_bInMemory = inMemory;
    }

    public int getStreamSize() {
        return this.m_iStreamStize;
    }

    public void setStreamSize(int streamSize) {
        this.m_iStreamStize = streamSize;
    }

    public InputStream getInputStream() throws XTSException {
        if (this.m_instResultObj != null) {
            InputStream in = this.m_instResultObj.getResult().getInputStream();
            if (in == null && this.m_instResultObj.attachmentsSupported()) {
                in = this.m_instResultObj.getAttachmentInputStream();
            }
            if (in == null) {
                try {
                    Reader reader = this.m_instResultObj.getResult().getReader();
                    in = new ReaderInputStream(reader, "UTF-8");
                }
                catch (IOException e) {
                    throw new XTSException("output.failedtoconvertreadertoinputstream", e);
                }
            }
            return in;
        }
        return this.m_in;
    }

    public void release() {
        block6: {
            try {
                if (this.m_instResultObj != null) {
                    this.m_instResultObj.release();
                } else {
                    this.m_in.close();
                }
                if (this.m_childResultList != null) {
                    for (int i = 0; i < this.m_childResultList.size(); ++i) {
                        IXTSInstructionResult childResult = (IXTSInstructionResult)this.m_childResultList.get(i);
                        childResult.release();
                    }
                }
            }
            catch (Exception e) {
                if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block6;
                StringBuffer msg = new StringBuffer();
                msg.append("Failed to release output object: ").append(e.getMessage()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                if (logger == null) break block6;
                logger.log(null, 8, msg.toString(), null, null);
            }
        }
    }
}

