/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.output;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputContext;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSSAXContentHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public final class XTSOutputSpecUtils {
    private static final String NEWLINE = "\r\n";
    private static final char OPEN_BRACKET_START = '<';
    private static final char OPEN_BRACKET_END = '>';
    private static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    private static final char CLOSE_BRACKET_END = '>';
    private static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char EQUALS = '=';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';

    public static void updateOutputSpec(XTSOutputContext outputContext, Element outputElem, Element contentElem) throws XTSException {
        Element entityBodyElem;
        String cacheControlSetting;
        Element paramElem;
        Element entityHeaderElem;
        Element partElem = null;
        String sPartId = outputContext.getPartId();
        if (sPartId == null) {
            partElem = XTSConstants.getPartLast(outputElem);
            if (partElem == null) {
                partElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PART);
                outputElem.add(partElem);
            }
        } else {
            List partEleList = outputElem.elements(XTSConstants.ELEM_NM_PART);
            if (partEleList.size() > 0) {
                for (int i = 0; i < partEleList.size(); ++i) {
                    Element outputPartEle = (Element)partEleList.get(i);
                    String att = outputPartEle.attributeValue("id");
                    if (att == null || !att.equals(outputContext.getPartId())) continue;
                    partElem = outputPartEle;
                    break;
                }
            }
            if (partElem == null) {
                partElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PART);
                partElem.addAttribute("id", outputContext.getPartId());
                outputElem.add(partElem);
            }
        }
        if ((entityHeaderElem = partElem.element(XTSConstants.ELEM_NM_ENTITYHEADER)) == null) {
            entityHeaderElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_ENTITYHEADER);
            partElem.add(entityHeaderElem);
        }
        if ((paramElem = XTSConstants.getParamContentIDElement(entityHeaderElem)) == null) {
            paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
            paramElem.addAttribute("name", "Content-ID");
            paramElem.addText(contentElem.attributeValue("refId"));
            entityHeaderElem.add(paramElem);
        }
        if ((paramElem = XTSConstants.getParamContentTypeElement(entityHeaderElem)) == null) {
            paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
            paramElem.addAttribute("name", "Content-Type");
            String sMimeType = outputContext.getMimeType();
            if (sMimeType != null) {
                paramElem.addText(sMimeType);
            }
            entityHeaderElem.add(paramElem);
        }
        if ((cacheControlSetting = outputContext.getCacheControl()) != null && !"".equals(cacheControlSetting)) {
            Element cacheControlParamElem = XTSConstants.getParamCacheControlElement(entityHeaderElem);
            if (cacheControlParamElem != null) {
                cacheControlParamElem.setText(cacheControlSetting);
            } else {
                cacheControlParamElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
                cacheControlParamElem.addAttribute("name", "Cache-Control");
                cacheControlParamElem.addText(cacheControlSetting);
                entityHeaderElem.add(cacheControlParamElem);
            }
        }
        if ((entityBodyElem = partElem.element(XTSConstants.ELEM_NM_ENTITYBODY)) == null) {
            entityBodyElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_ENTITYBODY);
            partElem.add(entityBodyElem);
        }
        if (entityBodyElem.attributeValue("refId") != null) {
            throw new XTSException("output.contentaddedtorefbody");
        }
        entityBodyElem.add(contentElem);
    }

    public static Element createPartElement(XTSOutputContext outputContext, InternetHeaders hdrs, String refId) {
        String userSpecifiedContentType;
        Element partElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PART);
        String partId = outputContext.getPartId();
        if (partId != null) {
            partElem.addAttribute("id", partId);
        }
        Element entityBodyElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_ENTITYBODY);
        entityBodyElem.addAttribute("refId", refId);
        partElem.add(entityBodyElem);
        Element entityHeaderElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_ENTITYHEADER);
        partElem.add(entityHeaderElem);
        if (hdrs != null) {
            Header hdrObj = null;
            String hdrName = null;
            Enumeration allHdrs = hdrs.getAllHeaders();
            while (allHdrs.hasMoreElements()) {
                hdrObj = (Header)allHdrs.nextElement();
                hdrName = hdrObj.getName();
                if (!hdrName.startsWith("Content-")) continue;
                Element paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
                paramElem.addAttribute("name", hdrName);
                String hdrValue = hdrObj.getValue();
                if (hdrValue != null) {
                    paramElem.addText(hdrValue);
                }
                entityHeaderElem.add(paramElem);
            }
        }
        if (hdrs != null && hdrs.getHeader("Content-ID", null) == null) {
            Element paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
            paramElem.addAttribute("name", "Content-ID");
            if (refId != null) {
                paramElem.addText(refId);
            }
            entityHeaderElem.add(paramElem);
        }
        if (hdrs != null && hdrs.getHeader("Content-Type", null) == null && (userSpecifiedContentType = outputContext.getMimeType()) != null) {
            Element paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
            paramElem.addAttribute("name", "Content-Type");
            paramElem.addText(userSpecifiedContentType);
            entityHeaderElem.add(paramElem);
        }
        return partElem;
    }

    public static void createPartElementAsString(XTSOutputContext outputContext, InternetHeaders hdrs, String refId, StringBuffer buf) {
        String userSpecifiedContentType;
        buf.append('<');
        buf.append(XTSConstants.ELEM_NM_PART.getQualifiedName());
        buf.append(' ');
        buf.append(XMLNS);
        buf.append(':');
        buf.append("xos");
        buf.append('=');
        buf.append('\"');
        buf.append("http://developer.cognos.com/schemas/xts/output/");
        buf.append('\"');
        String partId = outputContext.getPartId();
        if (partId != null) {
            buf.append(' ');
            buf.append("id");
            buf.append('=');
            buf.append('\"');
            buf.append(partId);
            buf.append('\"');
        }
        buf.append('>');
        buf.append('<');
        buf.append(XTSConstants.ELEM_NM_ENTITYBODY.getQualifiedName());
        buf.append(' ');
        buf.append("refId");
        buf.append('=');
        buf.append('\"');
        buf.append(refId);
        buf.append('\"');
        buf.append('>');
        buf.append(CLOSE_BRACKET_START);
        buf.append(XTSConstants.ELEM_NM_ENTITYBODY.getQualifiedName());
        buf.append('>');
        buf.append('<');
        buf.append(XTSConstants.ELEM_NM_ENTITYHEADER.getQualifiedName());
        buf.append('>');
        if (hdrs != null) {
            Header hdrObj = null;
            String hdrName = null;
            Enumeration allHdrs = hdrs.getAllHeaders();
            while (allHdrs.hasMoreElements()) {
                hdrObj = (Header)allHdrs.nextElement();
                hdrName = hdrObj.getName();
                if (!hdrName.startsWith("Content-")) continue;
                buf.append('<');
                buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
                buf.append(' ');
                buf.append("name");
                buf.append('=');
                buf.append('\"');
                buf.append(hdrName);
                buf.append('\"');
                buf.append('>');
                buf.append(hdrObj.getValue());
                buf.append(CLOSE_BRACKET_START);
                buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
                buf.append('>');
            }
        }
        if (hdrs != null && hdrs.getHeader("Content-ID", null) == null) {
            buf.append('<');
            buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
            buf.append(' ');
            buf.append("name");
            buf.append('=');
            buf.append('\"');
            buf.append("Content-ID");
            buf.append('\"');
            buf.append('>');
            buf.append(refId);
            buf.append(CLOSE_BRACKET_START);
            buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
            buf.append('>');
        }
        if (hdrs != null && hdrs.getHeader("Content-Type", null) == null && (userSpecifiedContentType = outputContext.getMimeType()) != null) {
            buf.append('<');
            buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
            buf.append(' ');
            buf.append("name");
            buf.append('=');
            buf.append('\"');
            buf.append("Content-Type");
            buf.append('\"');
            buf.append('>');
            buf.append(userSpecifiedContentType);
            buf.append(CLOSE_BRACKET_START);
            buf.append(XTSConstants.ELEM_NM_PARAM.getQualifiedName());
            buf.append('>');
        }
        buf.append(CLOSE_BRACKET_START);
        buf.append(XTSConstants.ELEM_NM_ENTITYHEADER.getQualifiedName());
        buf.append('>');
        buf.append(CLOSE_BRACKET_START);
        buf.append(XTSConstants.ELEM_NM_PART.getQualifiedName());
        buf.append('>');
    }

    public static Element createContentElement(XTSOutputContext outputContext, String refId) {
        Element contentElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_CONTENT);
        contentElem.addAttribute("refId", refId);
        String contentId = outputContext.getContentId();
        if (contentId != null) {
            contentElem.addAttribute("id", contentId);
        }
        return contentElem;
    }

    public static Element createStatusHeaderElement(InternetHeaders iHdrs) {
        Element statusElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_STATUS);
        if (iHdrs != null) {
            Header hdrObj = null;
            Enumeration allHdrs = iHdrs.getAllHeaders();
            while (allHdrs.hasMoreElements()) {
                hdrObj = (Header)allHdrs.nextElement();
                Element paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
                paramElem.addAttribute("name", hdrObj.getName());
                String hdrValue = hdrObj.getValue();
                if (hdrValue != null) {
                    paramElem.addText(hdrValue);
                }
                statusElem.add(paramElem);
            }
        }
        return statusElem;
    }

    public static Element createProtocolHeaderElement(InternetHeaders iHdrs) {
        Element protocolHeaderElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        if (iHdrs != null) {
            Header hdrObj = null;
            Enumeration allHdrs = iHdrs.getAllHeaders();
            while (allHdrs.hasMoreElements()) {
                hdrObj = (Header)allHdrs.nextElement();
                Element paramElem = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PARAM);
                paramElem.addAttribute("name", hdrObj.getName());
                String hdrValue = hdrObj.getValue();
                if (hdrValue != null) {
                    paramElem.addText(hdrValue);
                }
                protocolHeaderElem.add(paramElem);
            }
        }
        return protocolHeaderElem;
    }

    public static InputStream generateInputStream(XTSEnvironment env, Element partElem, boolean includeHeaders, List contentObjList, HttpServletResponse servletResponse) throws XTSException {
        Element entityBodyElem;
        Element entityHeaderElem;
        if (partElem == null) {
            return null;
        }
        InputStream in = null;
        if (includeHeaders && (entityHeaderElem = partElem.element(XTSConstants.ELEM_NM_ENTITYHEADER)) != null) {
            String paramName = null;
            Element paramElem = null;
            List paramElemList = entityHeaderElem.elements(XTSConstants.ELEM_NM_PARAM);
            int numParams = paramElemList.size();
            if (servletResponse != null) {
                for (int i = 0; i < numParams; ++i) {
                    paramElem = (Element)paramElemList.get(i);
                    paramName = paramElem.attributeValue("name");
                    if (paramName == null || paramName.equals("Content-Length")) continue;
                    servletResponse.addHeader(paramName, paramElem.getText());
                }
            } else {
                StringBuffer hdrs = new StringBuffer();
                for (int i = 0; i < numParams; ++i) {
                    paramElem = (Element)paramElemList.get(i);
                    paramName = paramElem.attributeValue("name");
                    if (paramName == null || paramName.equals("Content-Length")) continue;
                    hdrs.append(paramName + ": ");
                    hdrs.append(paramElem.getText());
                    hdrs.append(NEWLINE);
                }
                hdrs.append(NEWLINE);
                try {
                    in = new ByteArrayInputStream(hdrs.toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new XTSException("request.inputstreamfailed", e);
                }
            }
        }
        if ((entityBodyElem = partElem.element(XTSConstants.ELEM_NM_ENTITYBODY)) == null) {
            return in;
        }
        String refId = entityBodyElem.attributeValue("refId");
        if (refId != null) {
            XTSOutputObject obj = env.getContentStream(refId);
            if (obj == null) {
                Object[] args = new String[]{refId};
                throw new XTSException("output.invalidrefid", args);
            }
            in = in == null ? obj.getInputStream() : new SequenceInputStream(in, obj.getInputStream());
            if (contentObjList != null) {
                contentObjList.add(obj);
            }
        } else {
            XTSSAXContentHandler contentHandler = new XTSSAXContentHandler(env, contentObjList);
            InputStream contentIn = contentHandler.getContentStream(new StreamSource(new StringReader(entityBodyElem.asXML())));
            if (contentIn != null) {
                in = in == null ? contentIn : new SequenceInputStream(in, contentIn);
            }
        }
        return in;
    }

    public static boolean isMimeHeader(String header) {
        return header.startsWith("Content-");
    }
}

