/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.output;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.util.xmlutil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class XTSSAXContentHandler
extends DefaultHandler
implements LexicalHandler {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String OPEN_BRACKET_START = "<";
    private static final String OPEN_BRACKET_END = ">";
    private static final String CLOSE_BRACKET_START = "</";
    private static final String CLOSE_BRACKET_END = ">";
    private static final String PROCESSING_INSTRUCTION_START = "<?";
    private static final String PROCESSING_INSTRUCTION_END = "?>";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private XTSEnvironment m_env = null;
    private InputStream m_in = null;
    private StringBuffer m_tempHoldingArea = null;
    private String m_currentEntity = null;
    private List m_contentObjList = null;

    public XTSSAXContentHandler(XTSEnvironment env, List contentObjList) {
        this.m_env = env;
        this.m_contentObjList = contentObjList;
    }

    private XTSSAXContentHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContentStream(StreamSource stream) throws XTSException {
        this.m_tempHoldingArea = new StringBuffer();
        this.m_in = null;
        try {
            InputStream streamInput = stream.getInputStream();
            Reader streamReader = stream.getReader();
            InputSource input = null;
            if (streamInput != null) {
                input = new InputSource(streamInput);
            } else if (streamReader != null) {
                input = new InputSource(streamReader);
            }
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setFeature(NAMESPACE_PREFIXES_FEATURE, true);
                try {
                    reader.setContentHandler(this);
                    reader.setProperty(LEXICALHANDLER_PROPERTY, this);
                    reader.parse(input);
                }
                finally {
                    reader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        catch (SAXException e) {
            throw new XTSException("output.failedtogeneratecontentstream", e);
        }
        catch (IOException e) {
            throw new XTSException("output.failedtogeneratecontentstream", e);
        }
        catch (XTSException e) {
            throw new XTSException("output.failedtogeneratecontentstream", e);
        }
        return this.m_in;
    }

    @Override
    public void endDocument() {
        byte[] bytes;
        block2: {
            bytes = null;
            try {
                bytes = this.m_tempHoldingArea.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block2;
                StringBuffer msg = new StringBuffer();
                msg.append("Ignore UnsupportedEncodingException: ").append(e.getMessage()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                if (logger == null) break block2;
                logger.log(null, 8, msg.toString(), null, null);
            }
        }
        this.m_in = this.m_in == null ? new ByteArrayInputStream(bytes) : new SequenceInputStream(this.m_in, new ByteArrayInputStream(bytes));
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_currentEntity != null) {
            this.m_currentEntity = xmlutil.outEntityReference(this.m_currentEntity, ch, start, length);
            this.m_tempHoldingArea.append(this.m_currentEntity.toCharArray(), 0, this.m_currentEntity.length());
        } else {
            this.m_tempHoldingArea.append(ch, start, length);
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.m_currentEntity != null) {
            this.m_currentEntity = xmlutil.outEntityReference(this.m_currentEntity, ch, start, length);
            this.m_tempHoldingArea.append(this.m_currentEntity.toCharArray(), 0, this.m_currentEntity.length());
            this.m_currentEntity = null;
        } else {
            this.m_tempHoldingArea.append(ch, start, length);
        }
        this.m_currentEntity = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        if (namespaceURI.equals("http://developer.cognos.com/schemas/xts/output/")) {
            String refId;
            if (localName.equals(XTSConstants.ELEM_NM_CONTENT.getName()) && (refId = atts.getValue("refId")) != null) {
                byte[] bytes;
                block10: {
                    bytes = null;
                    try {
                        bytes = this.m_tempHoldingArea.toString().getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block10;
                        StringBuffer msg = new StringBuffer();
                        msg.append("Ignore UnsupportedEncodingException: ").append(e.getMessage()).append("\n");
                        IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                        if (logger == null) break block10;
                        logger.log(null, 8, msg.toString(), null, null);
                    }
                }
                this.m_in = this.m_in == null ? new ByteArrayInputStream(bytes) : new SequenceInputStream(this.m_in, new ByteArrayInputStream(bytes));
                this.m_tempHoldingArea = new StringBuffer();
                XTSOutputObject obj = this.m_env.getContentStream(refId);
                if (obj == null) {
                    Object[] args = new String[]{refId};
                    throw new SAXException(MessagesManager.getInstance().getMessage(this.m_env.getLocale(), "output.invalidrefid", args));
                }
                try {
                    this.m_in = this.m_in == null ? obj.getInputStream() : new SequenceInputStream(this.m_in, obj.getInputStream());
                }
                catch (XTSException e) {
                    throw new SAXException(e.getRootCauseLocalizedMsgString(this.m_env.getLocale()));
                }
                if (this.m_contentObjList != null) {
                    this.m_contentObjList.add(obj);
                }
            }
        } else {
            this.m_tempHoldingArea.append(OPEN_BRACKET_START);
            this.m_tempHoldingArea.append(qName);
            int attlen = atts.getLength();
            for (int i = 0; i < attlen; ++i) {
                this.m_tempHoldingArea.append(SPACE);
                this.m_tempHoldingArea.append(atts.getQName(i));
                this.m_tempHoldingArea.append(EQUALS);
                this.m_tempHoldingArea.append(QUOTE);
                xmlutil.xmlencode(atts.getValue(i), this.m_tempHoldingArea);
                this.m_tempHoldingArea.append(QUOTE);
            }
            this.m_tempHoldingArea.append(">");
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (namespaceURI.equals("http://developer.cognos.com/schemas/xts/output/")) {
            return;
        }
        this.m_tempHoldingArea.append(CLOSE_BRACKET_START);
        this.m_tempHoldingArea.append(qName);
        this.m_tempHoldingArea.append(">");
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.m_tempHoldingArea.append(PROCESSING_INSTRUCTION_START);
        this.m_tempHoldingArea.append(target);
        this.m_tempHoldingArea.append(SPACE);
        this.m_tempHoldingArea.append(data);
        this.m_tempHoldingArea.append(PROCESSING_INSTRUCTION_END);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int end) throws SAXException {
    }
}

