/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.properties;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.FactoryDefault;
import com.cognos.xts.properties.IXTSPropertiesCallback;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public final class PropertiesManager
extends AXTSManager {
    private static final String m_identifier = "PropertiesManager";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String XTS_PROPERTIES_FILENAME = "xts.properties";
    private static final String MULTIPLE_PROPFILE_PROPERTIES = "resource.propertiesfiles";
    private static final String MACRO_START = "$(";
    private static final String MACRO_END = ")";
    private static final int MACRO_MAX = 50;
    private static final PropertiesManager m_instance = new PropertiesManager();
    private Properties m_oProperties = new Properties();

    public static PropertiesManager getInstance() {
        return m_instance;
    }

    private PropertiesManager() {
        this.addProperties(FactoryDefault.getProperties());
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return XTSConfigManager.getInstance().isInitialized();
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        throw new UnsupportedOperationException("Please use initialize(IXTSPropertiesCallback, Properties)");
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_oProperties.clear();
        this.addProperties(FactoryDefault.getProperties());
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public void initialize(IXTSPropertiesCallback callback, Properties overrides) throws XTSException {
        IXTSLogger logger;
        if (!this.dependenciesCheck()) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("manager.depinitfailed", args);
        }
        this.m_oProperties.clear();
        this.addProperties(FactoryDefault.getProperties());
        Properties prop = XTSConfigManager.getInstance().getProperties();
        if (prop != null) {
            this.addProperties(prop);
        }
        if (callback != null && (prop = callback.loadRuntimeProperties()) != null) {
            this.addProperties(prop);
        }
        if (callback != null && (prop = callback.loadProperties(XTS_PROPERTIES_FILENAME)) != null) {
            this.addProperties(prop);
        }
        if (callback != null) {
            String propFileList = null;
            if (overrides != null) {
                propFileList = overrides.getProperty(MULTIPLE_PROPFILE_PROPERTIES);
            }
            if (propFileList == null) {
                propFileList = this.m_oProperties.getProperty(MULTIPLE_PROPFILE_PROPERTIES);
            }
            if (propFileList != null) {
                StringTokenizer token = new StringTokenizer(propFileList, ",");
                while (token.hasMoreTokens()) {
                    prop = callback.loadProperties(token.nextToken().trim() + PROPERTIES_EXT);
                    if (prop == null) continue;
                    this.addProperties(prop);
                }
            }
        }
        if (overrides != null) {
            this.addProperties(overrides);
        }
        this.m_bInitialized = true;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public void reinitialize(IXTSPropertiesCallback callback, Properties overrides) throws XTSException {
        this.terminate();
        this.initialize(callback, overrides);
    }

    public String getProperty(String key) {
        return this.getProperty(key, 0);
    }

    private String getProperty(String key, int level) {
        if (!this.m_bInitialized) {
            return null;
        }
        if (level > 50) {
            return key;
        }
        String val = this.m_oProperties.getProperty(key);
        if (val == null) {
            try {
                val = XTSConfigManager.getInstance().getProperty(key);
            }
            catch (XTSConfigurationException e) {
                return null;
            }
        }
        if (val != null) {
            val = this.substituteMacro(val, level).toString();
        }
        return val;
    }

    private StringBuffer substituteMacro(String value, int level) {
        String newvalue;
        int start = value.indexOf(MACRO_START);
        if (start == -1) {
            return new StringBuffer(value);
        }
        int end = value.indexOf(MACRO_END, start);
        if (end == -1) {
            return new StringBuffer(value);
        }
        StringBuffer ret = new StringBuffer();
        ret.append(value.substring(0, start));
        String macro = value.substring(start + MACRO_START.length(), end);
        if (macro.length() > 0 && (newvalue = this.getProperty(macro, level + 1)) != null && newvalue.length() > 0) {
            ret.append(newvalue);
        }
        ret.append(value.substring(end + 1));
        return this.substituteMacro(ret.toString(), level);
    }

    public HashMap getPropertiesMap(String pattern) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.m_bInitialized) {
            return ret;
        }
        Enumeration<?> propNames = this.m_oProperties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            if (!key.startsWith(pattern)) continue;
            ret.put(key, this.getProperty(key));
        }
        return ret;
    }

    public HashMap getAllProperties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.m_bInitialized) {
            return ret;
        }
        Enumeration<?> keys = this.m_oProperties.propertyNames();
        String name = null;
        String value = null;
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            value = this.getProperty(name);
            ret.put(name, value);
        }
        return ret;
    }

    private void addProperties(Properties prop) {
        Enumeration<?> keys = prop.propertyNames();
        String name = null;
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            this.m_oProperties.setProperty(name, prop.getProperty(name));
        }
    }
}

