/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.baltic.UXTSBusExceptionUtils;
import com.cognos.xts.baltic.configuration.CCLConfig;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.request.DispatcherOutput;
import com.cognos.xts.request.PropCallback;
import com.cognos.xts.request.XTSBusHelper;
import com.cognos.xts.request.XTSDispatcherResourceReader;
import com.cognos.xts.request.cleanupObj;
import com.cognos.xts.util.RWLockManager;
import com.cognos.xts.util.soaputil;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class AXTSDispatcherHandler
extends BasicHandler {
    protected static final String DEFAULT_MIME_BOUNDARY = "---=_MIME_BOUNDARY_Q739K9UU82UDLK73";
    protected static final String NAME_BUS_NAMESPACE_PREFIX = "bus";
    protected static final String BUS_NAMESPACE_URI = "http://developer.cognos.com/schemas/bibus/3/";
    protected static final Namespace BUS_NAMESPACE = new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
    protected static final QName BUS_EXCEPTION_QNAME = new QName("exception", BUS_NAMESPACE);
    protected static final QName BUS_MESSAGE_QNAME = new QName("message", BUS_NAMESPACE);
    protected static final String CALLER_ID = "CRN";
    protected PogoEngineContext m_context = null;
    protected String m_request_root_name = "request";
    protected String m_response_root_name = "response";
    protected String m_cleanup_list = "cleanup";
    protected ICCLConfiguration m_cclConfig = null;
    protected IXTSConfiguration m_xtsConfig = null;
    protected RWLockManager m_oMutex = new RWLockManager(new Object());
    protected boolean m_started = false;
    protected boolean m_suspended = false;

    public AXTSDispatcherHandler() {
        super(null);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        try {
            this.m_oMutex.writeLock();
            try {
                this.m_context = engine.getContext();
                this.m_request_root_name = this.getRequiredAttribute(null, "request_root_name");
                this.m_response_root_name = this.getRequiredAttribute(null, "response_root_name");
                this.m_cleanup_list = this.getRequiredAttribute(null, "cleanup_list");
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new PogoException(e.getMessage());
        }
    }

    public void configure(Configuration configuration) {
        try {
            this.m_oMutex.writeLock();
            try {
                this.m_cclConfig = configuration.getICCLConfiguration();
                this.m_xtsConfig = this.m_cclConfig != null ? new CCLConfig(this.m_cclConfig) : null;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void initialize() {
    }

    public void start() {
        try {
            this.m_oMutex.writeLock();
            try {
                if (!this.m_started) {
                    try {
                        XTSProcessor.getInstance(CALLER_ID).initialize(this.m_xtsConfig, new XTSDispatcherResourceReader(this.m_context, this.m_cclConfig), new PropCallback(this.m_context), null, true);
                        this.m_started = true;
                    }
                    catch (XTSException e) {
                        this.m_started = false;
                    }
                }
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.m_oMutex.writeLock();
            try {
                if (this.m_started) {
                    try {
                        XTSProcessor.getInstance(CALLER_ID).terminate(false);
                        this.m_started = false;
                    }
                    catch (XTSException e) {
                        this.m_started = true;
                    }
                }
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void suspend(boolean immediate) {
        try {
            this.m_oMutex.writeLock();
            try {
                this.m_suspended = true;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resume() {
        try {
            this.m_oMutex.writeLock();
            try {
                this.m_suspended = false;
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Configuration configuration) {
        block11: {
            try {
                this.m_oMutex.writeLock();
                try {
                    this.m_cclConfig = configuration.getICCLConfiguration();
                    this.m_xtsConfig = this.m_cclConfig != null ? new CCLConfig(this.m_cclConfig) : null;
                    if (!this.m_started) break block11;
                    boolean fullRestart = false;
                    try {
                        fullRestart = XTSProcessor.getInstance(CALLER_ID).checkConfig(this.m_xtsConfig);
                    }
                    catch (XTSException e) {
                        fullRestart = true;
                    }
                    try {
                        XTSProcessor.getInstance(CALLER_ID).reinitialize(this.m_xtsConfig, new XTSDispatcherResourceReader(this.m_context, this.m_cclConfig), new PropCallback(this.m_context), null, fullRestart, false);
                    }
                    catch (XTSException e) {
                        try {
                            XTSProcessor.getInstance(CALLER_ID).terminate(false);
                        }
                        catch (XTSException xTSException) {
                            // empty catch block
                        }
                        this.m_started = false;
                    }
                }
                finally {
                    this.m_oMutex.releaseWriteLock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope soapEnvelope;
        String pathInfo;
        IXTSLogger pLogger = null;
        XTSEnvironment perfEnv = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[0][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(0, 0)) != null) {
            pathInfo = (String)mc.getProperty("path_info");
            soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
            XTSBusHelper busHelper = null;
            try {
                busHelper = new XTSBusHelper(soapEnvelope, pathInfo);
            }
            catch (XTSException e) {
                busHelper = null;
            }
            if (busHelper != null) {
                perfEnv = busHelper.generateEnv(CALLER_ID);
            }
            pLogger.log(perfEnv, 2, ((Object)((Object)this)).getClass().getName(), "invokeImpl", "Start Request");
            pLogger.starttimer();
        }
        pathInfo = (String)mc.getProperty("path_info");
        soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
        Element soapHdr = soapEnvelope.getHeader();
        boolean suspended = false;
        boolean started = false;
        try {
            this.m_oMutex.readLock();
            try {
                suspended = this.m_suspended;
                started = this.m_started;
            }
            finally {
                this.m_oMutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            throw new PogoException(MessagesManager.getInstance().getBootStrapMessage(Locale.getDefault(), "bootstrap.failedtoexecute"));
        }
        if (started && !suspended) {
            this.handleRequest(mc);
        } else {
            int version = 11;
            Locale locale = Locale.getDefault();
            Element header = null;
            try {
                XTSBusHelper busHelper = new XTSBusHelper(soapEnvelope, pathInfo, true);
                version = busHelper.getSoapVersion();
                locale = busHelper.getLocale();
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                if (soapHdr != null) {
                    header = soapHdr.createCopy();
                    header.detach();
                }
            }
            catch (XTSException busHelper) {
                // empty catch block
            }
            XTSException error = suspended ? new XTSException("bootstrap.suspended") : new XTSException("bootstrap.stopped");
            this.setErrorResponse(mc, error, version, locale, header);
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(perfEnv, 3, ((Object)((Object)this)).getClass().getName(), "invokeImpl", "End Request");
            pLogger = null;
        }
    }

    protected abstract void handleRequest(MessageContext var1) throws PogoException;

    protected abstract DispatcherOutput generateDispatcherOutput(XTSEnvironment var1, Document var2) throws XTSException;

    protected DispatcherOutput executeMorphlet(XTSEnvironment env, Document inputdoc) throws XTSException {
        String morphlet = env.getMorphletName();
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "ExecuteMorphlet", null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "execute morphlet name: " + morphlet, null, null);
            traceLogger5.log(env, 8, "input document: " + inputdoc.asXML(), null, null);
        }
        DispatcherOutput dOutput = null;
        try {
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                traceLogger3.log(env, 2, "XTSProcessor - execute", null, null);
            }
            XTSProcessor.getInstance(CALLER_ID).execute(morphlet, inputdoc, env);
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger.log(env, 6, ((Object)((Object)this)).getClass().getName(), "executeMorphlet", "Start convert output to dispatcher format");
                pLogger.starttimer();
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                traceLogger5.log(env, 8, "return document: " + inputdoc.asXML(), null, null);
            }
            dOutput = this.generateDispatcherOutput(env, inputdoc);
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                traceLogger3.log(env, 3, "XTSProcessor - execute", null, null);
            }
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(env, 1, ((Object)((Object)this)).getClass().getName(), "executeMorphlet", "Completed convert output to dispatcher format.: " + (env.getMorphletName() == null ? "" : env.getMorphletName()));
            }
        }
        catch (XTSException e) {
            dOutput = this.executeErrorMorphlet(env, inputdoc, morphlet, e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "ExecuteMorphlet", null, null);
        }
        return dOutput;
    }

    protected DispatcherOutput executeErrorMorphlet(XTSEnvironment env, Document inputdoc, String morphlet, XTSException e) throws XTSException {
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(env, 4, "RenderErrorMorphlet", null, null);
        }
        String errorMorphlet = null;
        Element processingElement = null;
        Element rootEle = inputdoc.getRootElement();
        if (rootEle != null) {
            processingElement = rootEle.element("processing");
        }
        if (processingElement == null) {
            processingElement = XTSApplicationManager.getInstance().searchProcessingOptions(morphlet);
        }
        if (processingElement != null) {
            List paramList = processingElement.elements("param");
            for (int i = 0; i < paramList.size(); ++i) {
                Element paramEle = (Element)paramList.get(i);
                String att = paramEle.attributeValue("name");
                if (att == null || !att.equals("errorMorphlet")) continue;
                errorMorphlet = paramEle.getTextTrim();
                break;
            }
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "error morphlet name: " + errorMorphlet, null, null);
        }
        DispatcherOutput dOutput = null;
        if (errorMorphlet == null || errorMorphlet.length() == 0) {
            throw e;
        }
        env.setMorphletName(errorMorphlet);
        Element errorEle = UXTSExceptionUtils.generateErrorXML(e, env.getLocale());
        inputdoc.getRootElement().add(errorEle);
        Element outputElement = inputdoc.getRootElement().element("output");
        if (outputElement != null) {
            List outputContentList = outputElement.elements();
            Element outputContent = null;
            int outputContentListSize = outputContentList.size();
            for (int i = 0; i < outputContentListSize; ++i) {
                outputContent = (Element)outputContentList.get(i);
                outputContent.detach();
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
            traceLogger5.log(env, 8, "input document: " + inputdoc.asXML(), null, null);
        }
        XTSProcessor.getInstance(CALLER_ID).execute(errorMorphlet, inputdoc, env);
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
            traceLogger5.log(env, 8, "return document: " + inputdoc.asXML(), null, null);
        }
        dOutput = this.generateDispatcherOutput(env, inputdoc);
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(env, 5, "RenderErrorMorphlet", null, null);
        }
        return dOutput;
    }

    protected void setOutputResponse(XTSEnvironment env, MessageContext mc, DispatcherOutput dOutput) throws PogoException {
        mc.setProperty(this.m_response_root_name + ".status_code", (Object)(dOutput.m_sStatusCode == null ? "200" : dOutput.m_sStatusCode));
        mc.setProperty(this.m_response_root_name + ".headers", (Object)(dOutput.m_oHeaders == null ? new InternetHeaders() : dOutput.m_oHeaders));
        mc.setProperty(this.m_response_root_name + ".envelope", (Object)(dOutput.m_oBIBusEnveope == null ? new BIBusEnvelope() : dOutput.m_oBIBusEnveope));
        if (dOutput.m_oAttactments != null) {
            mc.setProperty(this.m_response_root_name + ".attachments", dOutput.m_oAttactments.iterator());
            mc.setProperty(this.m_response_root_name + ".boundary", (Object)DEFAULT_MIME_BOUNDARY);
            if (dOutput.m_sStartParameter != null) {
                mc.setProperty(this.m_response_root_name + ".start", (Object)dOutput.m_sStartParameter);
            }
        }
        if (dOutput.m_oCleanupList != null && !dOutput.m_oCleanupList.isEmpty()) {
            List cleanables = (List)mc.getProperty(this.m_cleanup_list);
            if (cleanables == null) {
                String msg = MessagesManager.getInstance().getMessage(env.getLocale(), "request.emptycleanuplist");
                throw new PogoException(msg);
            }
            cleanables.add(new cleanupObj(dOutput.m_oCleanupList));
        }
    }

    protected void setErrorResponse(MessageContext mc, XTSException e, int soapVersion, Locale locale, Element soapHdr) {
        mc.setProperty(this.m_response_root_name + ".status_code", (Object)"500");
        InternetHeaders response_hdrs = new InternetHeaders();
        mc.setProperty(this.m_response_root_name + ".headers", (Object)response_hdrs);
        Element soapEnvelope = UXTSBusExceptionUtils.convertXTSExceptionToBusFault(e, soapVersion, locale);
        Element body = soapEnvelope.element(soaputil.getSOAPBodyQName(soapVersion)).createCopy();
        body.detach();
        BIBusEnvelope soapFault = new BIBusEnvelope(soapHdr, body);
        mc.setFault(new Fault("xts_fault", (SOAPEnvelope)soapFault));
    }

    protected Element removeSetSoapHeaderFromOutputSpec(Document inputdoc) {
        Element outputElement = inputdoc.getRootElement().element("output");
        if (outputElement == null) {
            return null;
        }
        return this.removeSetSoapHeaderFromOutputSpec(outputElement);
    }

    protected Element removeSetSoapHeaderFromOutputSpec(Element outputElement) {
        if (outputElement == null) {
            return null;
        }
        List setSoapHdrParamList = XTSConstants.getProtocolHeaderParamSetSoapHeaderList(outputElement);
        if (setSoapHdrParamList.size() > 0) {
            Element setSoapHeaderParam = (Element)setSoapHdrParamList.get(0);
            setSoapHeaderParam.detach();
            for (int i = 1; i < setSoapHdrParamList.size(); ++i) {
                ((Element)setSoapHdrParamList.get(i)).detach();
            }
            return setSoapHeaderParam;
        }
        return null;
    }

    protected String getStatusCodeFromOutputSpec(Element outputElement) {
        if (outputElement != null) {
            Element statusCodeElement = XTSConstants.getStatusCodeElement(outputElement);
            if (statusCodeElement != null) {
                String status = statusCodeElement.getText();
                if (status != null && status.length() > 0) {
                    return status;
                }
            } else {
                String status;
                Element childStatusCodeElement;
                Element statusElement = XTSConstants.getStatusElement(outputElement);
                if (statusElement != null && (childStatusCodeElement = XTSConstants.getParamStatusCodeHeaderElement(statusElement)) != null && (status = childStatusCodeElement.getText()) != null && status.length() > 0) {
                    return status;
                }
            }
        }
        return "200";
    }
}

