/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.request.XTSRequestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public abstract class AXTSHttpServletRequest {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_MIME_BOUNDARY = "---=_MIME_BOUNDARY_Q739K9UU82UDLK73";
    private static final String DEFAULT_MIME_BOUNDARY_LINE = "\r\n-----=_MIME_BOUNDARY_Q739K9UU82UDLK73\r\n";
    private static final String DEFAULT_MIME_BOUNDARY_LINE_END = "\r\n-----=_MIME_BOUNDARY_Q739K9UU82UDLK73--\r\n";
    private static final String MULTIPART_CONTENT_TYPE = "multipart/related; type=\"text/xml\"; boundary=\"---=_MIME_BOUNDARY_Q739K9UU82UDLK73\"";
    private static final String CONTENT_TYPE_START_PARAM = "start";
    private static final String SESSION_PREFIX = "com.cognos.xts.servlet.transerv.";
    private static final int SESSION_PREFIX_LENGTH = "com.cognos.xts.servlet.transerv.".length();
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;
    private String m_callerID;
    private static Set m_httpHeaderExclusionSet = new HashSet();

    protected void initialize(HttpServletRequest request, HttpServletResponse response, String callerID) {
        this.m_request = request;
        this.m_response = response;
        this.m_callerID = callerID;
    }

    protected HttpServletRequest httpServletRequest() {
        return this.m_request;
    }

    protected HttpServletResponse httpServletResponse() {
        return this.m_response;
    }

    protected String getCallerID() {
        return this.m_callerID;
    }

    public abstract void execute() throws XTSException;

    protected Document createHttpRootDocument() {
        Document doc = this.createRootDocument();
        doc.getRootElement().add(this.createHttpElement());
        doc.getRootElement().add(this.createCookiesElement());
        doc.getRootElement().add(this.createUserSession());
        return doc;
    }

    protected Document createRootDocument() {
        Element root = DocumentHelper.createElement((String)"root");
        Element outputElement = DocumentHelper.createElement((String)"output");
        Element protocolHeaderElement = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        outputElement.add(protocolHeaderElement);
        root.add(outputElement);
        Document doc = DocumentHelper.createDocument((Element)root);
        return doc;
    }

    protected void sendOutput(XTSEnvironment env, Element outputElement) throws XTSException {
        ArrayList cleanUpObjList = new ArrayList();
        try {
            this.m_response.setStatus(200);
            ServletOutputStream sos = this.m_response.getOutputStream();
            if (outputElement == null) {
                sos.flush();
                sos.close();
                return;
            }
            Element statusCodeElement = outputElement.element(XTSConstants.ELEM_NM_STATUSCODE);
            if (statusCodeElement != null) {
                String status = statusCodeElement.getText();
                if (status != null && status.length() > 0) {
                    int code = Integer.parseInt(status);
                    this.m_response.setStatus(code);
                }
            } else {
                Element statusElement = outputElement.element(XTSConstants.ELEM_NM_STATUS);
                if (statusElement != null) {
                    String status;
                    Element childStatusCodeElement;
                    String reason = "";
                    Element childStatusTextElement = XTSConstants.getParamStatusTextHeaderElement(statusElement);
                    if (childStatusTextElement != null) {
                        reason = childStatusTextElement.getText();
                    }
                    if ((childStatusCodeElement = XTSConstants.getParamStatusCodeHeaderElement(statusElement)) != null && (status = childStatusCodeElement.getText()) != null && status.length() > 0) {
                        int code = Integer.parseInt(status);
                        if (reason.length() > 0) {
                            this.m_response.sendError(code, reason);
                        } else {
                            this.m_response.setStatus(code);
                        }
                    }
                }
            }
            List setUSList = outputElement.elements(XTSConstants.ELEM_NM_SETUSERSESSION);
            for (int i = 0; i < setUSList.size(); ++i) {
                Element setUserSession = (Element)setUSList.get(i);
                String invalidate = setUserSession.attributeValue("invalidate");
                if (invalidate != null && invalidate.equals("true")) {
                    this.invalidateUserSession();
                }
                HttpSession session = this.m_request.getSession(true);
                List paramList = setUserSession.elements(XTSConstants.ELEM_NM_PARAM);
                for (Element paramElement : paramList) {
                    String name = paramElement.attributeValue("name");
                    if (name == null) continue;
                    String keyname = SESSION_PREFIX + name;
                    if (name.endsWith(".xml")) {
                        List childList = paramElement.elements();
                        if (childList.size() == 0) {
                            session.removeAttribute(keyname);
                            continue;
                        }
                        Element child = (Element)childList.get(0);
                        session.setAttribute(keyname, (Object)child.asXML());
                        continue;
                    }
                    String value = paramElement.getText();
                    if (value == null || value.length() == 0) {
                        session.removeAttribute(keyname);
                        continue;
                    }
                    session.setAttribute(keyname, (Object)value);
                }
            }
            String sRedirectURL = null;
            List protocolHeaderList = outputElement.elements(XTSConstants.ELEM_NM_PROTOCOLHEADER);
            Element protocolHeader2 = null;
            for (Element protocolHeader2 : protocolHeaderList) {
                if (protocolHeader2 == null) continue;
                List paramList = protocolHeader2.elements(XTSConstants.ELEM_NM_PARAM);
                for (Element paramElement : paramList) {
                    String paramName = paramElement.attributeValue("name");
                    if (paramName == null) continue;
                    String paramValue = paramElement.getText();
                    if (paramName.equals("Location") && paramValue != null) {
                        sRedirectURL = paramValue;
                        continue;
                    }
                    if (paramValue == null) continue;
                    this.m_response.addHeader(paramName, paramValue);
                }
            }
            if (sRedirectURL != null) {
                this.m_response.sendRedirect(this.m_response.encodeRedirectURL(sRedirectURL));
                try {
                    sos.flush();
                    sos.close();
                }
                catch (IOException phIt) {
                    // empty catch block
                }
                return;
            }
            InputStream in = null;
            List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
            int partCount = partElemList.size();
            if (partCount == 1) {
                Element partElem = (Element)partElemList.get(0);
                in = XTSOutputSpecUtils.generateInputStream(env, partElem, true, cleanUpObjList, this.m_response);
                if (in != null) {
                    byte[] buf = new byte[4096];
                    int bytesRead = in.read(buf, 0, 4096);
                    while (bytesRead != -1) {
                        sos.write(buf, 0, bytesRead);
                        bytesRead = in.read(buf, 0, 4096);
                    }
                }
            } else if (partCount > 1) {
                ContentType contentType = null;
                try {
                    contentType = new ContentType(MULTIPART_CONTENT_TYPE);
                }
                catch (ParseException buf) {
                    // empty catch block
                }
                String sContentId = null;
                Element ctparamEle = XTSConstants.getPartEntityHeaderParamContentIDElement(outputElement);
                if (ctparamEle != null) {
                    sContentId = ctparamEle.getTextTrim();
                }
                if (sContentId == null || sContentId.length() == 0) {
                    throw new XTSException("output.multipartnocontentid");
                }
                contentType.setParameter(CONTENT_TYPE_START_PARAM, sContentId);
                this.m_response.addHeader("Content-Type", contentType.toString());
                Element partElem = null;
                for (int i = 0; i < partCount; ++i) {
                    partElem = (Element)partElemList.get(i);
                    in = XTSOutputSpecUtils.generateInputStream(env, partElem, true, cleanUpObjList, null);
                    if (in == null) continue;
                    sos.write(DEFAULT_MIME_BOUNDARY_LINE.getBytes("UTF-8"));
                    byte[] buf = new byte[4096];
                    int bytesRead = in.read(buf, 0, 4096);
                    while (bytesRead != -1) {
                        sos.write(buf, 0, bytesRead);
                        bytesRead = in.read(buf, 0, 4096);
                    }
                }
                sos.write(DEFAULT_MIME_BOUNDARY_LINE_END.getBytes());
            }
            sos.flush();
            sos.close();
        }
        catch (SocketException it) {
        }
        catch (IOException e) {
            throw new XTSException("request.outputfailed", e);
        }
        catch (NumberFormatException e) {
            throw new XTSException("request.outputfailed", e);
        }
        finally {
            for (XTSOutputObject outputObj : cleanUpObjList) {
                outputObj.release();
                outputObj = null;
            }
            cleanUpObjList.clear();
        }
    }

    private void invalidateUserSession() {
        ArrayList<String> toDelete = new ArrayList<String>();
        HttpSession session = this.m_request.getSession(false);
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(SESSION_PREFIX)) continue;
                toDelete.add(key);
            }
        }
        for (int i = 0; i < toDelete.size(); ++i) {
            session.removeAttribute((String)toDelete.get(i));
        }
    }

    private Element createUserSession() {
        Element sessionEle = DocumentHelper.createElement((String)"userSession");
        HttpSession session = this.m_request.getSession(false);
        if (session != null) {
            Enumeration keys = session.getAttributeNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(SESSION_PREFIX)) continue;
                String name = key.substring(SESSION_PREFIX_LENGTH);
                String value = (String)session.getAttribute(key);
                Element paramElement = DocumentHelper.createElement((String)"param");
                paramElement.addAttribute("name", name);
                if (value != null) {
                    if (name.endsWith(".xml")) {
                        try {
                            Document doc = DocumentHelper.parseText((String)value);
                            Element paramValueEle = doc.getRootElement();
                            paramValueEle.detach();
                            paramElement.add(paramValueEle);
                        }
                        catch (Exception e) {
                            paramElement.addText(value);
                        }
                    } else {
                        paramElement.addText(value);
                    }
                }
                sessionEle.add(paramElement);
            }
        }
        return sessionEle;
    }

    private Element createHttpElement() {
        String host;
        String acceptlang;
        String useragent;
        String servletpath;
        String remoteuser;
        String querystring;
        String pathtranslated;
        String pathinfo;
        StringBuffer requesturi;
        String requestmethod;
        String authtype;
        String remotehost;
        String servername;
        String serverprotocol;
        String contenttype;
        Element httpElement = DocumentHelper.createElement((String)"http");
        int contentlength = this.m_request.getContentLength();
        if (contentlength != -1) {
            httpElement.add(XTSRequestUtil.createParamElement("CONTENT_LENGTH", Integer.toString(contentlength)));
        }
        if ((contenttype = this.m_request.getContentType()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("CONTENT_TYPE", contenttype));
        }
        if ((serverprotocol = this.m_request.getProtocol()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("SERVER_PROTOCOL", serverprotocol));
        }
        if ((servername = this.m_request.getServerName()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("SERVER_NAME", servername));
        }
        int serverport = this.m_request.getServerPort();
        httpElement.add(XTSRequestUtil.createParamElement("SERVER_PORT", Integer.toString(serverport)));
        String remoteaddr = this.m_request.getRemoteAddr();
        if (remoteaddr != null) {
            httpElement.add(XTSRequestUtil.createParamElement("REMOTE_ADDR", remoteaddr));
        }
        if ((remotehost = this.m_request.getRemoteHost()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("REMOTE_HOST", remotehost));
        }
        if ((authtype = this.m_request.getAuthType()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("AUTH_TYPE", authtype));
        }
        if ((requestmethod = this.m_request.getMethod()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("REQUEST_METHOD", requestmethod));
        }
        if ((requesturi = HttpUtils.getRequestURL((HttpServletRequest)this.m_request)) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("REQUEST_URI", requesturi.toString()));
        }
        if ((pathinfo = this.m_request.getPathInfo()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("PATH_INFO", pathinfo));
        }
        if ((pathtranslated = this.m_request.getPathTranslated()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("PATH_TRANSLATED", pathtranslated));
        }
        if ((querystring = this.m_request.getQueryString()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("QUERY_STRING", querystring));
        }
        if ((remoteuser = this.m_request.getRemoteUser()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("REMOTE_USER", remoteuser));
        }
        if ((servletpath = this.m_request.getServletPath()) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("SCRIPT_NAME", servletpath));
        }
        if ((useragent = this.m_request.getHeader("User-Agent")) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("HTTP_USER_AGENT", useragent));
        }
        if ((acceptlang = this.m_request.getHeader("Accept-Language")) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("HTTP_ACCEPT_LANGUAGE", acceptlang));
        }
        if ((host = this.m_request.getHeader("Host")) != null) {
            httpElement.add(XTSRequestUtil.createParamElement("HTTP_HOST", host));
        }
        Enumeration hdrEnum = this.m_request.getHeaderNames();
        while (hdrEnum.hasMoreElements()) {
            String hdrName = ((String)hdrEnum.nextElement()).toUpperCase();
            if (m_httpHeaderExclusionSet.contains(hdrName)) continue;
            Enumeration hdrValueEnum = this.m_request.getHeaders(hdrName);
            while (hdrValueEnum.hasMoreElements()) {
                httpElement.add(XTSRequestUtil.createParamElement(hdrName, (String)hdrValueEnum.nextElement()));
            }
        }
        return httpElement;
    }

    private Element createCookiesElement() {
        Element cookiesElement = DocumentHelper.createElement((String)"cookies");
        Cookie[] cookies = this.m_request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Element cookieElement = DocumentHelper.createElement((String)"cookie");
                cookieElement.addAttribute("name", cookies[i].getName());
                String cookieValue = cookies[i].getValue();
                if (cookieValue != null) {
                    cookieElement.addText(cookieValue);
                }
                cookiesElement.add(cookieElement);
            }
        }
        return cookiesElement;
    }

    static {
        m_httpHeaderExclusionSet.add("CONTENT-LENGTH");
        m_httpHeaderExclusionSet.add("COOKIE");
    }
}

