/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.IXTSPropertiesCallback;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

class PropCallback
implements IXTSPropertiesCallback {
    private static final String BASEPATH = "/WEB-INF/";
    private PogoEngineContext m_context = null;

    public PropCallback(PogoEngineContext context) {
        this.m_context = context;
    }

    @Override
    public Properties loadRuntimeProperties() throws XTSException {
        Properties prop = new Properties();
        if (this.m_context != null) {
            block5: {
                try {
                    String tempdir = CCLConfigurationFactory.getInstance().getValue("temp", false);
                    if (tempdir != null) {
                        prop.put("xts.tempdir", tempdir);
                    }
                }
                catch (CCLConfigurationException e) {
                    IXTSLogger traceLogger1 = null;
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[0][0] || (traceLogger1 = XTSTraceLoggerManager.getInstance().getLogger(0, 0)) == null) break block5;
                    StringBuffer msg = new StringBuffer();
                    msg.append("An error occurred trying to get 'temp' value from CCLConfigurationFactory.\n");
                    traceLogger1.log(null, 8, msg.toString(), null, null);
                }
            }
            Map instCmpnts = (Map)this.m_context.getAttribute("com.cognos.pogo.InstalledComponents");
            if (instCmpnts != null && instCmpnts.size() > 0) {
                String xml = this.getInstalledComponentsXML((Set)instCmpnts.get("system"));
                prop.put("installedComponents", xml);
                String xml2 = this.getInstalledComponentsPerDispatcherXML(instCmpnts);
                prop.put("installedComponentsPerDispatcher", xml2);
            }
        }
        return prop;
    }

    @Override
    public Properties loadProperties(String filename) throws XTSException {
        InputStream is;
        Properties prop = new Properties();
        if (this.m_context != null && (is = this.m_context.getResourceAsStream(BASEPATH + filename)) != null) {
            try {
                prop.load(is);
            }
            catch (IOException e) {
                Object[] args = new String[]{filename};
                throw new XTSException("property.loadPropertyFile", args, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    @Override
    public InputStream loadResource(String filename) throws XTSException {
        InputStream is = null;
        if (this.m_context != null) {
            is = this.m_context.getResourceAsStream(BASEPATH + filename);
        }
        return is;
    }

    private void appendComponents(Element parentNode, Set cmpnts) {
        if (cmpnts != null) {
            Iterator it = cmpnts.iterator();
            while (it.hasNext()) {
                Element ele = DocumentHelper.createElement((String)"component");
                ele.addText((String)it.next());
                parentNode.add(ele);
            }
        }
    }

    private String getInstalledComponentsXML(Set cmpnts) {
        Element paramElem = DocumentHelper.createElement((String)"property");
        paramElem.addAttribute("name", "installedComponents");
        this.appendComponents(paramElem, cmpnts);
        return paramElem.asXML();
    }

    private String getInstalledComponentsPerDispatcherXML(Map dispatchers) {
        Element paramElem = DocumentHelper.createElement((String)"property");
        paramElem.addAttribute("name", "installedComponentsPerDispatcher");
        if (dispatchers != null) {
            Iterator it = dispatchers.entrySet().iterator();
            while (it.hasNext()) {
                Element dispEle = DocumentHelper.createElement((String)"dispatcher");
                Map.Entry entry = it.next();
                dispEle.addAttribute("name", (String)entry.getKey());
                this.appendComponents(dispEle, (Set)entry.getValue());
                paramElem.add(dispEle);
            }
        }
        return paramElem.asXML();
    }
}

