/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceInfo;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.ext.CCLCAMUtils;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.request.XTSBusRequestUtil;
import com.cognos.xts.util.soaputil;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public final class XTSBusHelper {
    private static final String NAME_XTS_OPERATION = "run";
    private static final int CALL_METHOD_UNKNOWN = 0;
    private static final int CALL_METHOD_FORMFIELD = 1;
    private static final int CALL_METHOD_IMORPHLET = 2;
    private static final int CALL_METHOD_INTERFACE = 3;
    private int m_soapVersion = 11;
    private int m_mode = 0;
    private Locale m_locale = null;
    private ArrayList m_lookupList = null;
    private Document m_resultDoc = null;
    private Element m_soapHeader = null;
    private String m_morphletName = null;
    private String m_pathInfo = null;
    private String m_requestContext = "";
    private String m_sessionContext = "";
    private String m_stepContext = "";
    private String m_subRequestContext = "";
    private HashSet userCapabilities = null;

    public XTSBusHelper(Element busRequestRootElem, String pathInfo) throws XTSException {
        Document busRequestDoc = DocumentHelper.createDocument((Element)busRequestRootElem);
        this.initialize(busRequestDoc, pathInfo, false);
    }

    public XTSBusHelper(BIBusEnvelope busEnvelope, String pathInfo) throws XTSException {
        this.initialize(busEnvelope.getAsDocument(), pathInfo, false);
    }

    public XTSBusHelper(BIBusEnvelope busEnvelope, String pathInfo, boolean bSkip) throws XTSException {
        this.initialize(busEnvelope.getAsDocument(), pathInfo, bSkip);
    }

    private void initialize(Document busRequestDoc, String pathInfo, boolean bSkip) throws XTSException {
        Element systemElement;
        Element processingElement;
        List iInfoList;
        Element envelope;
        List operationList;
        Element busRequestMsgBodyElem;
        Element cookies;
        Element busTracking;
        Element biBusHeader;
        Element header;
        Element docSoapHeader;
        Element docSoapEnvelope;
        this.m_pathInfo = pathInfo == null || pathInfo.length() == 0 ? "/" : pathInfo;
        this.m_resultDoc = XTSBusRequestUtil.convertBusRequestToXTSInput(busRequestDoc);
        Element docEnvelope = this.m_resultDoc.getRootElement().element("envelope");
        if (docEnvelope != null && (docSoapEnvelope = docEnvelope.element(soaputil.getSOAPEnvelopeQName(11))) != null && (docSoapHeader = docSoapEnvelope.element(soaputil.getSOAPHeaderQName(11))) != null) {
            this.m_soapHeader = docSoapHeader.createCopy();
            this.m_soapHeader.detach();
        }
        if ((header = this.m_resultDoc.getRootElement().element("header")) != null && (biBusHeader = header.element("biBusHeader")) != null && (busTracking = biBusHeader.element("tracking")) != null) {
            Element busSubRequestContext;
            Element busStepContext;
            Element busSessionContext;
            Element busRequestContext = busTracking.element("requestContext");
            if (busRequestContext != null) {
                this.m_requestContext = busRequestContext.getText();
                if (this.m_requestContext == null) {
                    this.m_requestContext = "";
                }
            }
            if ((busSessionContext = busTracking.element("sessionContext")) != null) {
                this.m_sessionContext = busSessionContext.getText();
                if (this.m_sessionContext == null) {
                    this.m_sessionContext = "";
                }
            }
            if ((busStepContext = busTracking.element("stepContext")) != null) {
                this.m_stepContext = busStepContext.getText();
                if (this.m_stepContext == null) {
                    this.m_stepContext = "";
                }
            }
            if ((busSubRequestContext = busTracking.element("hopCount")) != null) {
                this.m_subRequestContext = busSubRequestContext.getText();
                if (this.m_subRequestContext == null) {
                    this.m_subRequestContext = "";
                }
            }
        }
        this.m_soapVersion = soaputil.getSOAPVersion(busRequestDoc.getRootElement().getNamespaceURI());
        String lang = null;
        String mode = null;
        Element userEnv = this.m_resultDoc.getRootElement().element("env");
        if (userEnv != null) {
            List paramEleList = userEnv.elements("param");
            for (int i = 0; i < paramEleList.size(); ++i) {
                Element paramEle = (Element)paramEleList.get(i);
                String att = paramEle.attributeValue("name");
                if (att != null && att.equals("lang")) {
                    lang = paramEle.getTextTrim();
                    continue;
                }
                if (att == null || !att.equals("mode")) continue;
                mode = paramEle.getTextTrim();
            }
        }
        if ((cookies = this.m_resultDoc.getRootElement().element("cookies")) != null) {
            List cookieEleList = cookies.elements("cookie");
            for (int i = 0; i < cookieEleList.size(); ++i) {
                Element cookie = (Element)cookieEleList.get(i);
                String att = cookie.attributeValue("name");
                if (att == null || !att.equals("XTS_DEBUG")) continue;
                String xts_debug = cookie.getTextTrim();
                if (xts_debug == null || !xts_debug.equals("true")) break;
                this.m_mode |= 2;
                break;
            }
        }
        if (mode != null) {
            StringTokenizer st = new StringTokenizer(mode, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("test")) {
                    this.m_mode |= 1;
                    continue;
                }
                if (token.equalsIgnoreCase("debug")) {
                    this.m_mode |= 2;
                    continue;
                }
                if (!token.equalsIgnoreCase("restart")) continue;
                this.m_mode |= 4;
            }
        }
        boolean useContentMapping = lang != null && lang.length() > 0;
        this.m_locale = XTSBusRequestUtil.getRequestLocale(this.m_resultDoc, lang, null);
        this.m_lookupList = XTSBusRequestUtil.getRequestLocaleLookupList(this.m_locale, useContentMapping);
        if (bSkip) {
            return;
        }
        int nCallMethod = 0;
        this.m_morphletName = null;
        if (nCallMethod == 0 && (busRequestMsgBodyElem = busRequestDoc.getRootElement().element(soaputil.getSOAPBodyQName(this.m_soapVersion))) != null && (operationList = busRequestMsgBodyElem.elements()).size() > 0) {
            Element operationElem = (Element)operationList.get(0);
            if (operationElem.getName().equals(NAME_XTS_OPERATION)) {
                nCallMethod = 2;
                Element objEle = operationElem.element("obj");
                if (objEle != null) {
                    this.m_morphletName = objEle.getTextTrim();
                }
                if (this.m_morphletName == null || this.m_morphletName.length() == 0) {
                    Object[] params = new String[]{"/", "", "run object"};
                    throw new XTSException("request.invalidoperation", params);
                }
                envelope = this.m_resultDoc.getRootElement().element("envelope");
                if (envelope != null) {
                    envelope.detach();
                }
            } else {
                String op;
                String ns = operationElem.getNamespaceURI();
                XTSInterfaceInfo iInfo = XTSInterfaceInfo.searchInterfaceInfo(this.m_pathInfo, ns, op = operationElem.getName());
                if (iInfo != null) {
                    Element processingElement2;
                    nCallMethod = 3;
                    this.m_morphletName = iInfo.getMorphlet();
                    if (this.m_morphletName == null || this.m_morphletName.length() == 0) {
                        Object[] params = new String[]{"/", operationElem.getNamespaceURI(), operationElem.getName()};
                        throw new XTSException("request.invalidoperation", params);
                    }
                    Element ifaceRootElem = this.m_resultDoc.getRootElement().addElement("interfaces");
                    ifaceRootElem.add(iInfo.toElement());
                    Element command = DocumentHelper.createElement((String)"command");
                    command.add(operationElem.createCopy());
                    this.m_resultDoc.getRootElement().add(command);
                    XTSInterface iface = iInfo.getXTSInterface();
                    if (iface != null && (processingElement2 = iface.getProcessingOptions()) != null) {
                        this.m_resultDoc.getRootElement().add(processingElement2);
                    }
                } else if (XTSInterfaceInfo.interfaceExists(this.m_pathInfo, ns)) {
                    Object[] params = new String[]{"/", "", "xts.run"};
                    throw new XTSException("request.invalidoperation", params);
                }
            }
        }
        if (nCallMethod == 0 && userEnv != null) {
            List envList = userEnv.elements();
            for (int i = 0; i < envList.size(); ++i) {
                Element envParam = (Element)envList.get(i);
                String envParamValue = envParam.attributeValue("name");
                if (envParamValue == null || !envParamValue.equals("m")) continue;
                nCallMethod = 1;
                this.m_morphletName = envParam.getText();
                if (this.m_morphletName == null || this.m_morphletName.length() == 0) {
                    Object[] params = new String[]{"/", "", "xts.run"};
                    throw new XTSException("request.invalidoperation", params);
                }
                envelope = this.m_resultDoc.getRootElement().element("envelope");
                if (envelope == null) break;
                envelope.detach();
                break;
            }
        }
        if (nCallMethod == 0 && (iInfoList = XTSInterfaceInfo.searchInterfaceInfo(this.m_pathInfo)).size() > 0) {
            nCallMethod = 3;
            XTSInterfaceInfo iInfo = (XTSInterfaceInfo)iInfoList.get(0);
            this.m_morphletName = iInfo.getMorphlet();
            Element ifaceRootElem = this.m_resultDoc.getRootElement().addElement("interfaces");
            for (int i = 0; i < iInfoList.size(); ++i) {
                XTSInterfaceInfo info = (XTSInterfaceInfo)iInfoList.get(i);
                ifaceRootElem.add(info.toElement());
            }
            XTSInterface iface = iInfo.getXTSInterface();
            if (iface != null && (processingElement = iface.getProcessingOptions()) != null) {
                this.m_resultDoc.getRootElement().add(processingElement);
            }
        }
        if (nCallMethod == 0 || this.m_morphletName == null || this.m_morphletName.length() == 0) {
            Object[] params = new String[]{"/", "", "xts.run"};
            throw new XTSException("request.invalidoperation", params);
        }
        if (!this.m_morphletName.startsWith("/")) {
            this.m_morphletName = "/" + this.m_morphletName;
        }
        Element outputElement = DocumentHelper.createElement((String)"output");
        Element protocolHeaderElement = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        outputElement.add(protocolHeaderElement);
        this.m_resultDoc.getRootElement().add(outputElement);
        Element paramElement = protocolHeaderElement.addElement(XTSConstants.ELEM_NM_PARAM);
        paramElement.addAttribute("name", "setSoapHeader");
        if (this.m_soapHeader != null) {
            Element setSoapHeader = this.m_soapHeader.createCopy();
            setSoapHeader.detach();
            paramElement.add(setSoapHeader);
        }
        if ((systemElement = XTSApplicationManager.getInstance().searchSystemOptions(this.m_morphletName)) != null) {
            this.m_resultDoc.getRootElement().add(systemElement);
        }
        if (nCallMethod != 3 && (processingElement = XTSApplicationManager.getInstance().searchProcessingOptions(this.m_morphletName)) != null) {
            this.m_resultDoc.getRootElement().add(processingElement);
        }
        StringReader resultReader = new StringReader(this.createSessionString(systemElement).toString());
        AXTSPoolObject reader = XTSSAXReaderPool.getInstance().acquire();
        try {
            Element sessionEle = ((SAXReader)reader.get()).read((Reader)resultReader).getRootElement();
            sessionEle.detach();
            this.m_resultDoc.getRootElement().add(sessionEle);
        }
        catch (DocumentException e) {
            throw new XTSException("request.parsefailed", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
    }

    private StringBuffer createSessionString(Element systemElement) throws XTSException {
        Element cookiesEle;
        Element setCookiesEle;
        String d1 = null;
        String d2 = null;
        String cc_session = null;
        String cc_state = null;
        String CRN = null;
        if (systemElement != null) {
            Element sysParamEle = null;
            List sysParamList = systemElement.elements("param");
            for (int i = 0; i < sysParamList.size(); ++i) {
                sysParamEle = (Element)sysParamList.get(i);
                if (!sysParamEle.attributeValue("name").equals("delimiters")) continue;
                d1 = sysParamEle.attributeValue("d1");
                d2 = sysParamEle.attributeValue("d2");
                break;
            }
        }
        if ((setCookiesEle = this.m_resultDoc.getRootElement().element("setCookies")) != null) {
            Element cookieEle = null;
            List cookieEleList = setCookiesEle.elements("cookie");
            for (int i = 0; i < cookieEleList.size(); ++i) {
                cookieEle = (Element)cookieEleList.get(i);
                if (!cookieEle.attributeValue("name").equals("CRN")) continue;
                CRN = cookieEle.getText();
                break;
            }
        }
        if ((cookiesEle = this.m_resultDoc.getRootElement().element("cookies")) != null) {
            Element cookieEle = null;
            List cookieEleList = cookiesEle.elements("cookie");
            for (int i = 0; i < cookieEleList.size(); ++i) {
                cookieEle = (Element)cookieEleList.get(i);
                if (cookieEle.attributeValue("name").equals("cc_session")) {
                    cc_session = cookieEle.getText();
                    continue;
                }
                if (cookieEle.attributeValue("name").equals("cc_state")) {
                    cc_state = this.getStateText(cookieEle);
                    continue;
                }
                if (CRN != null || !cookieEle.attributeValue("name").equals("CRN")) continue;
                CRN = cookieEle.getText();
            }
            if (cc_session != null) {
                Element cam_passportEle = (Element)this.m_soapHeader.selectSingleNode("./*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='setCookieVars']/item[name='cam_passport']/value");
                if (cam_passportEle == null) {
                    cam_passportEle = (Element)cookiesEle.selectSingleNode("./cookie[@name='cam_passport']");
                }
                try {
                    boolean isSessionValid;
                    String CAMPassportCookie = cam_passportEle != null ? cam_passportEle.getText() : null;
                    String CAMPassportId = "";
                    if (CAMPassportCookie != null && !"".equals(CAMPassportCookie)) {
                        CAMPassportId = CCLCAMUtils.executeCAMCookieCommand("getPassportID", CAMPassportCookie);
                    }
                    if (!(isSessionValid = XTSExt.isCCSessionValid(cc_session, CAMPassportId, d1, d2))) {
                        Element cc_sessionEle = (Element)cookiesEle.selectSingleNode("./cookie[@name='cc_session']");
                        if (cc_sessionEle != null) {
                            cc_sessionEle.getParent().remove(cc_sessionEle);
                        }
                        cc_session = null;
                    }
                }
                catch (Exception e) {
                    throw new XTSException("request.parsefailed", e);
                }
            }
        }
        StringBuffer result = new StringBuffer(256);
        result.append("<session>");
        this.userCapabilities = new XTSEnvironment().setupUserCapabilities(this.m_soapHeader, this.m_resultDoc);
        result.append(this.buildSessionCapabilitiesParams(this.userCapabilities));
        if (cc_session != null && cc_session.length() > 0 && d1 != null && d2 != null) {
            if (cc_state == null) {
                cc_state = "";
            }
            try {
                result.append(XTSExt.decodeCCSession(cc_session + d1 + cc_state, d1, d2));
            }
            catch (UnsupportedEncodingException e) {
                throw new XTSException("request.parsefailed", e);
            }
        }
        if (CRN != null && CRN.length() > 0) {
            try {
                result.append(XTSExt.decodeCRNCookie(CRN));
            }
            catch (UnsupportedEncodingException e) {
                throw new XTSException("request.parsefailed", e);
            }
        }
        result.append("</session>");
        return result;
    }

    private String getStateText(Element cookieEle) {
        String stateText = cookieEle.getText();
        if (stateText.startsWith("\"")) {
            return stateText.substring(1, stateText.length() - 1);
        }
        return stateText;
    }

    private StringBuffer buildSessionCapabilitiesParams(HashSet userCapabilities) {
        StringBuffer result = new StringBuffer(512);
        if (userCapabilities != null) {
            Iterator iter = userCapabilities.iterator();
            result.append("<param name=\"capabilities\" type=\"CRN\">");
            while (iter.hasNext()) {
                String capability = (String)iter.next();
                if (capability == null || "".equals(capability)) continue;
                result.append("<");
                result.append(capability);
                result.append("/>");
            }
            result.append("</param>");
        }
        return result;
    }

    public XTSEnvironment generateEnv(String callerID) {
        XTSEnvironment env = new XTSEnvironment(callerID);
        env.setMorphletName(this.m_morphletName);
        env.setMode(this.m_mode);
        env.setLocale(this.m_locale);
        env.setLookupList(this.m_lookupList);
        env.setRequestContext(this.m_requestContext);
        env.setSessionContext(this.m_sessionContext);
        env.setStepContext(this.m_stepContext);
        env.setSubRequestContext(this.m_subRequestContext);
        env.setUserCapabilities(this.userCapabilities);
        return env;
    }

    public int getSoapVersion() {
        return this.m_soapVersion;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public ArrayList getLookupList() {
        return this.m_lookupList;
    }

    public int getMode() {
        return this.m_mode;
    }

    public Document getInputDoc() {
        return this.m_resultDoc;
    }

    public String getMorphletName() {
        return this.m_morphletName;
    }

    public Element getRequestSoapHeader() {
        return this.m_soapHeader;
    }
}

