/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.XTSException;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.util.LocaleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class XTSBusRequestUtil {
    public static final String SOAP_HEADER = "Header";
    public static final String BIBUS_HEADER = "biBusHeader";
    public static final String BIBUS_HDRSESSION = "hdrSession";
    private static final String BIBUS_ENVIRONMENTVARS = "environmentVars";
    private static final String BIBUS_FORMFIELDVARS = "formFieldVars";
    private static final String BIBUS_COOKIEVARS = "cookieVars";
    private static final String BIBUS_USERPREFERENCE = "userPreferenceVars";
    public static final String BIBUS_SETCOOKIEVARS = "setCookieVars";
    public static final String BIBUS_CAM = "CAM";
    public static final String BIBUS_CAF = "CAF";
    public static final String CAM_CAMPASSPORT = "CAMPassport";
    public static final String CAM_ID = "id";
    private static final String ROOT = "root";
    private static final String ENVELOPE = "envelope";
    public static final String HEADER = "header";
    private static final String HTTP = "http";
    private static final String ENV = "env";
    private static final String USER = "user";
    private static final String COOKIES = "cookies";
    private static final String SET_COOKIES = "setCookies";
    public static final String PARAM = "param";
    private static final String COOKIE = "cookie";
    public static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String FORMAT = "format";
    private static final String MAXAGE = "maxAge";
    public static final String DOMAIN = "domain";
    private static final String PATH = "path";
    private static final String SECURE = "secure";
    public static final String CREDENTIAL = "credential";
    private static final Namespace XSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final Namespace XSD = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace SOAP_ENC = new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
    private static final QName XSI_TYPE = new QName("type", XSI);
    public static final QName SOAPENC_ARRAYTYPE = new QName("arrayType", SOAP_ENC);

    private static Element getXTSInputRoot(Document busDoc) {
        Element rootEl = DocumentHelper.createElement((String)ROOT);
        rootEl.add(XTSConstants.XTS_OUTPUT_SPEC_NAMESPACE);
        return rootEl;
    }

    private static Element getXTSEnvelopeElement(Element soapEnvelope) {
        if (soapEnvelope != null) {
            Element envEl = DocumentHelper.createElement((String)ENVELOPE);
            envEl.add(soapEnvelope.createCopy());
            return envEl;
        }
        return null;
    }

    private static Element getXTSHeaderElement(Element soapHeader) {
        if (soapHeader != null) {
            Element headerEl = DocumentHelper.createElement((String)HEADER);
            headerEl.appendContent((Branch)soapHeader);
            return headerEl;
        }
        return null;
    }

    private static void buildXTSParamList(Element parent, List paramList) {
        for (int i = 0; i < paramList.size(); ++i) {
            Element value;
            Element curVar = (Element)paramList.get(i);
            Element name = curVar.element(NAME);
            if (name == null) continue;
            Element param = DocumentHelper.createElement((String)PARAM);
            param.addAttribute(NAME, name.getText());
            Element format = curVar.element(FORMAT);
            if (format != null) {
                param.addAttribute(FORMAT, format.getText());
            }
            if ((value = curVar.element(VALUE)) != null) {
                param.addText(value.getText());
            }
            parent.add(param);
        }
    }

    private static Element getXTSHTTPElement(Element hdrSession) {
        if (hdrSession != null) {
            Element httpEl = null;
            Element envVars = hdrSession.element(BIBUS_ENVIRONMENTVARS);
            if (envVars != null) {
                httpEl = DocumentHelper.createElement((String)HTTP);
                XTSBusRequestUtil.buildXTSParamList(httpEl, envVars.elements());
            }
            return httpEl;
        }
        return null;
    }

    private static Element getXTSEnvElement(Element hdrSession) {
        if (hdrSession != null) {
            Element envEl = null;
            Element ffVars = hdrSession.element(BIBUS_FORMFIELDVARS);
            if (ffVars != null) {
                envEl = DocumentHelper.createElement((String)ENV);
                XTSBusRequestUtil.buildXTSParamList(envEl, ffVars.elements());
            }
            return envEl;
        }
        return null;
    }

    private static Element getXTSUserElement(Element userPreference) {
        if (userPreference != null) {
            Element userEl = DocumentHelper.createElement((String)USER);
            XTSBusRequestUtil.buildXTSParamList(userEl, userPreference.elements());
            return userEl;
        }
        return null;
    }

    public static Element getXTSCredentialElement(Element CAM) {
        if (CAM != null) {
            Element param = DocumentHelper.createElement((String)PARAM);
            param.addAttribute(NAME, CAM.getName());
            param.add(CAM.createCopy());
            Element credentialEl = DocumentHelper.createElement((String)CREDENTIAL);
            credentialEl.add(param);
            return credentialEl;
        }
        return null;
    }

    private static void buildXTSCookieList(Element parent, List cookieList) {
        for (int i = 0; i < cookieList.size(); ++i) {
            Element value;
            Element secure;
            Element domain;
            Element maxAge;
            Element curVar = (Element)cookieList.get(i);
            Element name = curVar.element(NAME);
            if (name == null) continue;
            Element cookie = DocumentHelper.createElement((String)COOKIE);
            cookie.addAttribute(NAME, name.getText());
            Element path = curVar.element(PATH);
            if (path != null) {
                cookie.addAttribute(PATH, path.getText());
            }
            if ((maxAge = curVar.element(MAXAGE)) != null) {
                cookie.addAttribute(MAXAGE, maxAge.getText());
            }
            if ((domain = curVar.element(DOMAIN)) != null) {
                cookie.addAttribute(DOMAIN, domain.getText());
            }
            if ((secure = curVar.element(SECURE)) != null) {
                cookie.addAttribute(SECURE, secure.getText());
            }
            if ((value = curVar.element(VALUE)) != null) {
                cookie.addText(value.getText());
            }
            parent.add(cookie);
        }
    }

    private static Element getXTSCookieElement(Element hdrSession) {
        if (hdrSession != null) {
            Element cookieEl = null;
            Element cookieVars = hdrSession.element(BIBUS_COOKIEVARS);
            if (cookieVars != null) {
                cookieEl = DocumentHelper.createElement((String)COOKIES);
                XTSBusRequestUtil.buildXTSCookieList(cookieEl, cookieVars.elements());
            }
            return cookieEl;
        }
        return null;
    }

    private static Element getXTSSetCookieElement(Element hdrSession) {
        if (hdrSession != null) {
            Element setCookieEl = null;
            Element setCookieVars = hdrSession.element(BIBUS_SETCOOKIEVARS);
            if (setCookieVars != null) {
                setCookieEl = DocumentHelper.createElement((String)SET_COOKIES);
                XTSBusRequestUtil.buildXTSCookieList(setCookieEl, setCookieVars.elements());
            }
            return setCookieEl;
        }
        return null;
    }

    public static Document convertBusRequestToXTSInput(Document busDoc) throws XTSException {
        if (busDoc == null) {
            throw new XTSException("request.emptyrequest");
        }
        Element soapEnvelope = busDoc.getRootElement();
        Element soapHeader = soapEnvelope != null ? soapEnvelope.element(SOAP_HEADER) : null;
        Element biBusHeader = soapHeader != null ? soapHeader.element(BIBUS_HEADER) : null;
        Element hdrSession = biBusHeader != null ? biBusHeader.element(BIBUS_HDRSESSION) : null;
        Element userPreference = biBusHeader != null ? biBusHeader.element(BIBUS_USERPREFERENCE) : null;
        Element CAM = biBusHeader != null ? biBusHeader.element(BIBUS_CAM) : null;
        Element rootEl = XTSBusRequestUtil.getXTSInputRoot(busDoc);
        if (rootEl == null) {
            return null;
        }
        Element child = XTSBusRequestUtil.getXTSEnvelopeElement(soapEnvelope);
        if (child != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSHeaderElement(soapHeader)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSHTTPElement(hdrSession)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSEnvElement(hdrSession)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSUserElement(userPreference)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSCredentialElement(CAM)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSCookieElement(hdrSession)) != null) {
            rootEl.add(child);
        }
        if ((child = XTSBusRequestUtil.getXTSSetCookieElement(hdrSession)) != null) {
            rootEl.add(child);
        }
        return DocumentHelper.createDocument((Element)rootEl);
    }

    public static Element createBusSetCookieElement(String headerValue) throws XTSException {
        Element result = null;
        HeaderElement[] headers = XTSBusRequestUtil.parse(headerValue);
        if (headers.length > 0) {
            result = DocumentHelper.createElement((String)BIBUS_SETCOOKIEVARS);
            result.add(XSI);
            result.add(XSD);
            result.add(SOAP_ENC);
            result.addAttribute(XSI_TYPE, "SOAP-ENC:Array");
            result.addAttribute(SOAPENC_ARRAYTYPE, "bus:setCookieVar[]");
        }
        for (int i = 0; i < headers.length; ++i) {
            Element item = DocumentHelper.createElement((String)"item");
            item.addAttribute(XSI_TYPE, "bus:setCookieVar");
            result.add(item);
            Element name = DocumentHelper.createElement((String)NAME);
            name.addAttribute(XSI_TYPE, "xsd:string");
            name.addText(headers[i].getName());
            item.add(name);
            Element value = DocumentHelper.createElement((String)VALUE);
            value.addAttribute(XSI_TYPE, "xsd:string");
            value.addText(headers[i].getValue() == null ? "" : headers[i].getValue());
            item.add(value);
            NameValuePair[] pairs = headers[i].getParameters();
            if (pairs == null) continue;
            for (int j = 0; j < pairs.length; ++j) {
                Element param;
                String pairValue;
                String pairName = pairs[j].getName();
                String string = pairValue = pairs[j].getValue() == null ? "" : pairs[j].getValue();
                if (pairName.equalsIgnoreCase("Comment")) {
                    param = DocumentHelper.createElement((String)"comment");
                    param.addAttribute(XSI_TYPE, "xsd:string");
                    param.addText(pairValue);
                    item.add(param);
                    continue;
                }
                if (pairName.equalsIgnoreCase("Domain")) {
                    param = DocumentHelper.createElement((String)DOMAIN);
                    param.addAttribute(XSI_TYPE, "xsd:string");
                    param.addText(pairValue);
                    item.add(param);
                    continue;
                }
                if (pairName.equalsIgnoreCase("Max-Age")) {
                    param = DocumentHelper.createElement((String)MAXAGE);
                    param.addAttribute(XSI_TYPE, "xsd:int");
                    param.addText(pairValue);
                    item.add(param);
                    continue;
                }
                if (pairName.equalsIgnoreCase("Path")) {
                    param = DocumentHelper.createElement((String)PATH);
                    param.addAttribute(XSI_TYPE, "xsd:string");
                    param.addText(pairValue);
                    item.add(param);
                    continue;
                }
                if (pairName.equalsIgnoreCase("Secure")) {
                    param = DocumentHelper.createElement((String)SECURE);
                    param.addAttribute(XSI_TYPE, "xsd:string");
                    item.add(param);
                    continue;
                }
                if (pairName.equalsIgnoreCase("Version")) {
                    param = DocumentHelper.createElement((String)PATH);
                    param.addAttribute(XSI_TYPE, "xsd:int");
                    param.addText(pairValue);
                    item.add(param);
                    continue;
                }
                param = DocumentHelper.createElement((String)pairName);
                param.addAttribute(XSI_TYPE, "xsd:string");
                param.addText(pairValue);
                item.add(param);
            }
        }
        return result;
    }

    private static HeaderElement[] parse(String headerValue) throws XTSException {
        if (headerValue == null) {
            return null;
        }
        Vector<HeaderElement> elements = new Vector<HeaderElement>();
        StringTokenizer tokenizer = new StringTokenizer(headerValue.trim(), ",");
        while (tokenizer.countTokens() > 0) {
            String tmp;
            String s;
            StringBuilder nextToken = new StringBuilder(tokenizer.nextToken());
            while (XTSBusRequestUtil.hasOddNumberOfQuotationMarks(nextToken.toString())) {
                nextToken.append(",").append(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens() && ((s = nextToken.toString().toLowerCase()).endsWith("mon") || s.endsWith("tue") || s.endsWith("wed") || s.endsWith("thu") || s.endsWith("fri") || s.endsWith("sat") || s.endsWith("sun") || s.endsWith("monday") || s.endsWith("tuesday") || s.endsWith("wednesday") || s.endsWith("thursday") || s.endsWith("friday") || s.endsWith("saturday") || s.endsWith("sunday"))) {
                nextToken.append(",").append(tokenizer.nextToken());
            }
            if (!(tmp = nextToken.toString().trim()).endsWith(";")) {
                tmp = tmp + ";";
            }
            char[] header = tmp.toCharArray();
            String elementName = null;
            String elementValue = null;
            Object[] elementNVPairs = null;
            Vector<NameValuePair> paramlist = new Vector<NameValuePair>();
            boolean inAString = false;
            int startPos = 0;
            for (int i = 0; i < header.length; ++i) {
                if (header[i] == ';' && !inAString) {
                    NameValuePair pair = XTSBusRequestUtil.parsePair(header, startPos, i);
                    if (startPos == 0) {
                        if (pair == null) {
                            Object[] args = new Object[]{new String(header)};
                            throw new XTSException("output.invalidcookie", args);
                        }
                        elementName = pair.getName();
                        elementValue = pair.getValue();
                    } else if (pair != null) {
                        paramlist.addElement(pair);
                    }
                    startPos = i + 1;
                    continue;
                }
                if (header[i] != '\"' || inAString && i > 0 && header[i - 1] == '\\') continue;
                inAString = !inAString;
            }
            if (paramlist.size() > 0) {
                elementNVPairs = new NameValuePair[paramlist.size()];
                paramlist.copyInto(elementNVPairs);
                paramlist.removeAllElements();
            }
            HeaderElement element = new HeaderElement(elementName, elementValue, (NameValuePair[])elementNVPairs);
            elements.addElement(element);
        }
        Object[] headerElements = new HeaderElement[elements.size()];
        elements.copyInto(headerElements);
        return headerElements;
    }

    private static final boolean hasOddNumberOfQuotationMarks(String string) {
        boolean odd = false;
        int start = -1;
        while ((start = string.indexOf(34, start + 1)) != -1) {
            odd = !odd;
        }
        return odd;
    }

    private static final NameValuePair parsePair(char[] header, int start, int end) {
        String name = new String(header, start, end - start).trim();
        String value = null;
        int index = name.indexOf("=");
        if (index >= 0) {
            if (index + 1 < name.length() && (value = name.substring(index + 1).trim()).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            name = name.substring(0, index).trim();
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return new NameValuePair(name, value);
    }

    public static final String getRequestLang(Document root) {
        String lang = null;
        Element userEnv = root.getRootElement().element(ENV);
        if (userEnv != null) {
            List paramEleList = userEnv.elements(PARAM);
            for (int i = 0; i < paramEleList.size(); ++i) {
                Element paramEle = (Element)paramEleList.get(i);
                String att = paramEle.attributeValue(NAME);
                if (att == null || !att.equals("lang")) continue;
                lang = paramEle.getTextTrim();
            }
        }
        return lang;
    }

    public static final Locale getRequestLocale(Document root, String lang, Locale rLoc) {
        Locale locale = null;
        if (lang == null || lang.length() == 0) {
            Element busHdrEle;
            Element userPreference = null;
            Element header = root.getRootElement().element(HEADER);
            if (header != null && (busHdrEle = header.element(BIBUS_HEADER)) != null) {
                userPreference = busHdrEle.element(BIBUS_USERPREFERENCE);
            }
            if (userPreference != null) {
                List varList = userPreference.elements();
                for (int i = 0; i < varList.size(); ++i) {
                    Element varEleValueEle;
                    String varEleName;
                    Element varEle = (Element)varList.get(i);
                    Element varEleNameEle = varEle.element(NAME);
                    if (varEleNameEle == null || (varEleName = varEleNameEle.getTextTrim()) == null || !varEleName.equals("productLocale") || (varEleValueEle = varEle.element(VALUE)) == null) continue;
                    lang = varEleValueEle.getTextTrim();
                    break;
                }
            } else {
                Element userEnv;
                Element httpEnv = root.getRootElement().element(HTTP);
                if (httpEnv != null && (userEnv = root.getRootElement().element(ENV)) != null) {
                    List paramEleList = userEnv.elements(PARAM);
                    for (int i = 0; i < paramEleList.size(); ++i) {
                        Element paramEle = (Element)paramEleList.get(i);
                        String att = paramEle.attributeValue(NAME);
                        if (att == null || !att.equals("HTTP_ACCEPT_LANGUAGE")) continue;
                        lang = paramEle.getTextTrim();
                        break;
                    }
                }
            }
            if (lang != null && lang.length() > 0) {
                locale = LocaleUtils.parseHttpLocaleList(lang, false);
            }
        } else {
            locale = LocaleUtils.parseHttpLocaleList(lang, true);
        }
        if (locale == null) {
            locale = rLoc;
        }
        if (locale == null) {
            try {
                locale = XTSConfigManager.getInstance().getServerLocale();
            }
            catch (XTSConfigurationException e) {
                locale = null;
            }
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public static final ArrayList getRequestLocaleLookupList(Locale locale, boolean bContentLocale) {
        return LocaleUtils.createLookupList(locale, bContentLocale);
    }
}

