/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.xts.XTSVersions;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.properties.PropertiesManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;

public class XTSDiagnosticHandler
extends BasicHandler {
    private static final String DEFAULT_MIME_BOUNDARY = "---=_MIME_BOUNDARY_Q739K9UU82UDLK75";

    public XTSDiagnosticHandler() {
        super(null);
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        String response_root_name = this.getRequiredAttribute(null, "response_root_name");
        mc.setProperty(response_root_name + ".status_code", (Object)"200");
        mc.setProperty(response_root_name + ".headers", (Object)new InternetHeaders());
        mc.setProperty(response_root_name + ".envelope", (Object)new BIBusEnvelope());
        InputStream is = this.createDiagnosticInfo();
        ArrayList<InputStream> l = new ArrayList<InputStream>();
        l.add(is);
        mc.setProperty(response_root_name + ".attachments", l.iterator());
        mc.setProperty(response_root_name + ".boundary", (Object)DEFAULT_MIME_BOUNDARY);
    }

    private InputStream createDiagnosticInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Content-Type: text/html; charset=utf-8\r\n");
        buf.append("\r\n");
        buf.append("<html><body>");
        buf.append("<table border=\"2\" width=\"100%\">");
        buf.append("<tr><td colspan=\"3\" align=\"center\" width=\"100%\"><b><i>XML Transformation Service</i></b></td></tr>");
        this.getXTSVersion(buf);
        this.getSAXParserInfo(buf);
        this.getXSLTParserInfo(buf);
        buf.append("</table>");
        buf.append("</body></html>");
        try {
            return new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createSectionTitle(StringBuffer buf, String s) {
        buf.append("<tr><td colspan=\"3\"><b><i>");
        buf.append(s);
        buf.append("</i></b></td></tr>");
    }

    private void createSectionDetails(StringBuffer buf, String key, String value) {
        buf.append("<tr>");
        buf.append("<td width=\"10%\"/>");
        buf.append("<td width=\"30%\"><b>");
        buf.append(key);
        buf.append("</b></td>");
        buf.append("<td width=\"60%\">");
        buf.append(value);
        buf.append("</td>");
        buf.append("</tr>");
    }

    private void getXTSVersion(StringBuffer buf) {
        String s;
        this.createSectionTitle(buf, "XTS");
        try {
            s = XTSVersions.getXTSVersionString();
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "version", s);
        try {
            s = PropertiesManager.getInstance().getProperty("template.root");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "template", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSAXParserInfo(StringBuffer buf) {
        String s;
        String fs;
        this.createSectionTitle(buf, "SAX Parser");
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            fs = factory.getClass().getName();
        }
        catch (Exception e) {
            fs = "Unknown";
        }
        this.createSectionDetails(buf, "factory class", fs);
        try {
            AXTSPoolObject parserObj = XTSSAXParserPool.getInstance().acquire();
            try {
                s = parserObj.get().getClass().getName();
            }
            finally {
                XTSSAXParserPool.getInstance().put(parserObj);
            }
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "parser class", s);
    }

    private void getXSLTParserInfo(StringBuffer buf) {
        String s;
        String fs;
        this.createSectionTitle(buf, "XSLT Transformer");
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            fs = factory.getClass().getName();
        }
        catch (Exception e) {
            fs = "Unknown";
        }
        this.createSectionDetails(buf, "factory class", fs);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            s = factory.newTransformer().getClass().getName();
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "transformer class", s);
    }

    private void getDispatcherInfo(StringBuffer buf) {
        String s;
        this.createSectionTitle(buf, "Known Dispatcher");
        try {
            s = PropertiesManager.getInstance().getProperty("dispatcher.host");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "host", s);
        try {
            s = PropertiesManager.getInstance().getProperty("dispatcher.port");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "port", s);
        try {
            s = PropertiesManager.getInstance().getProperty("dispatcher.url");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "url", s);
        try {
            s = PropertiesManager.getInstance().getProperty("dispatcher.secure");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "secure", s);
    }

    private void getCMInfo(StringBuffer buf) {
        String s;
        this.createSectionTitle(buf, "Active Content Manager");
        try {
            s = PropertiesManager.getInstance().getProperty("cm.host");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "host", s);
        try {
            s = PropertiesManager.getInstance().getProperty("cm.port");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "port", s);
        try {
            s = PropertiesManager.getInstance().getProperty("cm.url");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "url", s);
        try {
            s = PropertiesManager.getInstance().getProperty("cm.secure");
        }
        catch (Exception e) {
            s = "Unknown";
        }
        this.createSectionDetails(buf, "secure", s);
    }

    private void getPropertiesManagerContent(StringBuffer buf) {
        this.createSectionTitle(buf, "Properties Manager");
        HashMap map = PropertiesManager.getInstance().getAllProperties();
        for (Map.Entry ent : map.entrySet()) {
            this.createSectionDetails(buf, (String)ent.getKey(), (String)ent.getValue());
        }
    }
}

