/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.request.IXTSHttpServletRequest;
import com.cognos.xts.request.XTSHttpServletRequestException;
import com.cognos.xts.util.XTSObjectCache;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XTSHttpServletRequestGenerator {
    private static final String PROPERTY_PREFIX = "httpservletrequest.class.";
    private static XTSObjectCache m_oObjCache = new XTSObjectCache();
    private static Object m_oMutexObj = new Object();

    public static boolean isHandlerDefined(String handler) {
        String prop = PROPERTY_PREFIX + handler;
        String handlerClassName = PropertiesManager.getInstance().getProperty(prop);
        return handlerClassName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IXTSHttpServletRequest createHandler(String handler, HttpServletRequest request, HttpServletResponse response, String callerID) throws XTSHttpServletRequestException {
        Class<?> requestHandlerClass;
        String handlerrClassName;
        block12: {
            String prop = PROPERTY_PREFIX + handler;
            handlerrClassName = PropertiesManager.getInstance().getProperty(prop);
            if (handlerrClassName == null) {
                Object[] args = new String[]{handler};
                throw new XTSHttpServletRequestException("request.unknownimplementation", args);
            }
            requestHandlerClass = null;
            try {
                requestHandlerClass = (Class<?>)m_oObjCache.getObject(prop);
                if (requestHandlerClass != null) break block12;
                Object object = m_oMutexObj;
                synchronized (object) {
                    requestHandlerClass = (Class)m_oObjCache.getObject(prop);
                    if (requestHandlerClass == null) {
                        try {
                            requestHandlerClass = Class.forName(handlerrClassName);
                            m_oObjCache.addObject(prop, requestHandlerClass);
                        }
                        catch (ClassNotFoundException e) {
                            Object[] args = new String[]{handlerrClassName};
                            throw new XTSHttpServletRequestException("request.classloaderror", args, e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                throw new XTSHttpServletRequestException("request.lockgeneratorcachefailed", e);
            }
        }
        IXTSHttpServletRequest requestHandler = null;
        try {
            requestHandler = (IXTSHttpServletRequest)requestHandlerClass.newInstance();
        }
        catch (IllegalAccessException e) {
            Object[] args = new String[]{handlerrClassName};
            throw new XTSHttpServletRequestException("request.illegalaccesserror", args, e);
        }
        catch (InstantiationException e) {
            Object[] args = new String[]{handlerrClassName};
            throw new XTSHttpServletRequestException("request.instantiationerror", args, e);
        }
        requestHandler.initialize(request, response, callerID);
        return requestHandler;
    }
}

