/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.request.AXTSDispatcherHandler;
import com.cognos.xts.request.DispatcherOutput;
import com.cognos.xts.request.XTSBusHelper;
import com.cognos.xts.request.XTSBusRequestUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;

public class XTSNonBusDispatcherRequestHandler
extends AXTSDispatcherHandler {
    @Override
    public void suspend(boolean immediate) {
    }

    @Override
    public void resume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRequest(MessageContext mc) throws PogoException {
        IXTSLogger auditLogger2 = null;
        if (XTSAuditLoggerManager.getInstance().isEnabled[4][1]) {
            BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
            auditLogger2 = XTSAuditLoggerManager.getInstance().getLogger(3, 1);
            if (auditLogger2 != null) {
                auditLogger2.log(null, 2, "Raw Request From Dispatcher: " + soapEnvelope.getEnvelope().asXML(), null, null);
            }
        }
        IXTSLogger pLogger1 = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger1 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            pLogger1.log(null, 6, ((Object)((Object)this)).getClass().getName(), "handleRequest", "Start convert bus request to xts format");
            pLogger1.starttimer();
        }
        BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
        XTSBusHelper busHelper = null;
        try {
            String pathInfo = (String)mc.getProperty("path_info");
            busHelper = new XTSBusHelper(soapEnvelope, pathInfo);
        }
        catch (XTSException e) {
            Element originalSoapHdr = soapEnvelope.getHeader();
            if (originalSoapHdr != null) {
                originalSoapHdr = originalSoapHdr.createCopy();
                originalSoapHdr.detach();
            }
            this.setErrorResponse(mc, e, 11, Locale.getDefault(), null);
            return;
        }
        XTSEnvironment env = busHelper.generateEnv("CRN");
        IXTSLogger auditLogger = null;
        if (XTSAuditLoggerManager.getInstance().isEnabled[3][1] && (auditLogger = XTSAuditLoggerManager.getInstance().getLogger(3, 1)) != null) {
            auditLogger.log(env, 2, soapEnvelope.getEnvelope().asXML(), null, null);
        }
        if (pLogger1 != null) {
            pLogger1.stoptimer();
            pLogger1.log(env, 1, ((Object)((Object)this)).getClass().getName(), "handleRequest", "Completed convert bus request to xts format");
        }
        IXTSLogger traceLogger2 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger2.log(env, 4, "XTSDispatcherRequestHandler", null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(env, 8, "dispatcher request: " + soapEnvelope.getEnvelope().asXML(), null, null);
        }
        try {
            Document inputDoc = busHelper.getInputDoc();
            DispatcherOutput dOutput = null;
            try {
                dOutput = this.executeMorphlet(env, inputDoc);
            }
            catch (XTSException e) {
                Element setSoapHeaderParam = this.removeSetSoapHeaderFromOutputSpec(inputDoc);
                Element soapHeader = null;
                if (setSoapHeaderParam != null && (soapHeader = setSoapHeaderParam.element("Header")) != null) {
                    soapHeader.detach();
                }
                this.setErrorResponse(mc, e, busHelper.getSoapVersion(), env.getLocale(), soapHeader);
                env.cleanup();
                return;
            }
            IXTSLogger pLogger2 = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger2 = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger2.log(env, 6, ((Object)((Object)this)).getClass().getName(), "handleRequest", "Start send output to dispatcher");
                pLogger2.starttimer();
            }
            if (XTSAuditLoggerManager.getInstance().isEnabled[3][1] && dOutput.m_oBIBusEnveope != null && auditLogger != null) {
                auditLogger.log(env, 3, dOutput.m_oBIBusEnveope.getAsDocument().asXML(), null, null);
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && dOutput.m_oBIBusEnveope != null && traceLogger5 != null) {
                traceLogger5.log(env, 8, "dispatcher response: " + dOutput.m_oBIBusEnveope.getAsDocument().asXML(), null, null);
            }
            this.setOutputResponse(env, mc, dOutput);
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                traceLogger2.log(env, 5, "XTSDispatcherRequestHandler", null, null);
            }
            if (pLogger2 != null) {
                pLogger2.stoptimer();
                pLogger2.log(env, 1, ((Object)((Object)this)).getClass().getName(), "handleRequest", "Completed send output to dispatcher");
            }
        }
        finally {
            env.cleanup();
        }
    }

    @Override
    protected DispatcherOutput generateDispatcherOutput(XTSEnvironment env, Document inputdoc) throws XTSException {
        DispatcherOutput dOutput = new DispatcherOutput();
        try {
            Element setCookieVars;
            String setCookies;
            Element outputElement = inputdoc.getRootElement().element("output");
            if (outputElement == null) {
                return dOutput;
            }
            dOutput.m_sStatusCode = this.getStatusCodeFromOutputSpec(outputElement);
            dOutput.m_oHeaders = new InternetHeaders();
            List protocolHeaderList = outputElement.elements(XTSConstants.ELEM_NM_PROTOCOLHEADER);
            for (Element protocolHeader : protocolHeaderList) {
                if (protocolHeader == null) continue;
                List paramList = protocolHeader.elements(XTSConstants.ELEM_NM_PARAM);
                for (Element paramElement : paramList) {
                    if (paramElement == null) continue;
                    String paramName = paramElement.attributeValue("name");
                    String paramValue = paramElement.getText();
                    if (paramName == null || paramValue == null || paramName.equals("setSoapHeader")) continue;
                    dOutput.m_oHeaders.addHeader(paramName, paramValue);
                }
            }
            this.removeSetSoapHeaderFromOutputSpec(outputElement);
            dOutput.m_oCleanupList = new ArrayList();
            dOutput.m_oAttactments = new ArrayList();
            dOutput.m_sBoundaryString = "---=_MIME_BOUNDARY_Q739K9UU82UDLK73";
            dOutput.m_sStartParameter = null;
            List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
            int partCount = partElemList.size();
            if (partCount > 0) {
                this.handleFirstPart(env, (Element)partElemList.get(0), dOutput);
                for (int i = 1; i < partCount; ++i) {
                    dOutput.m_oAttactments.add(XTSOutputSpecUtils.generateInputStream(env, (Element)partElemList.get(i), true, dOutput.m_oCleanupList, null));
                }
            }
            if ((setCookies = dOutput.m_oHeaders.getHeader("Set-Cookie", ",")) != null && (setCookieVars = XTSBusRequestUtil.createBusSetCookieElement(setCookies)) != null) {
                Element origSetCookieVar = dOutput.m_oBIBusEnveope.getSetCookieVars();
                if (origSetCookieVar == null) {
                    dOutput.m_oBIBusEnveope.getHdrSession().add(setCookieVars);
                } else {
                    origSetCookieVar.appendContent((Branch)setCookieVars);
                }
            }
        }
        catch (XTSException e) {
            throw new XTSException("request.outputfailed", e);
        }
        catch (SOAPException e) {
            throw new XTSException("request.outputfailed", e);
        }
        return dOutput;
    }

    private void handleFirstPart(XTSEnvironment env, Element partElem, DispatcherOutput dOutput) throws XTSException, SOAPException {
        InputStream body;
        Element entityHeaderElem = partElem.element(XTSConstants.ELEM_NM_ENTITYHEADER);
        if (entityHeaderElem != null) {
            List paramElemList = entityHeaderElem.elements(XTSConstants.ELEM_NM_PARAM);
            for (int i = 0; i < paramElemList.size(); ++i) {
                Element paramElem = (Element)paramElemList.get(i);
                if (paramElem == null) continue;
                String paramName = paramElem.attributeValue("name");
                String paramValue = paramElem.getText();
                if (paramName == null || paramValue == null || paramName.equals("Content-Length")) continue;
                dOutput.m_oHeaders.addHeader(paramName, paramValue);
            }
        }
        if ((body = XTSOutputSpecUtils.generateInputStream(env, partElem, false, dOutput.m_oCleanupList, null)) != null) {
            dOutput.m_oBIBusEnveope = new BIBusEnvelope(body);
        }
    }
}

