/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceInfo;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.request.AXTSHttpServletRequest;
import com.cognos.xts.request.IXTSHttpServletRequest;
import com.cognos.xts.request.XTSHttpServletRequestException;
import com.cognos.xts.request.XTSRequestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XTSParameterizedHttpRequest
extends AXTSHttpServletRequest
implements IXTSHttpServletRequest {
    @Override
    public void initialize(HttpServletRequest request, HttpServletResponse response, String callerID) {
        super.initialize(request, response, callerID);
    }

    protected Document createParameterizedHttpRootDocument() {
        Document doc = this.createHttpRootDocument();
        doc.getRootElement().add(this.createEnvElement());
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws XTSHttpServletRequestException {
        Document rootDoc = this.createParameterizedHttpRootDocument();
        Object[] obj = XTSRequestUtil.getRequestLocaleAndLookupList(this.httpServletRequest());
        XTSEnvironment env = new XTSEnvironment(this.getCallerID());
        env.setLocale((Locale)obj[0]);
        env.setLookupList((ArrayList)obj[1]);
        env.setMode(this.getRequestMode());
        try {
            IXTSLogger traceLogger2;
            block34: {
                int i;
                traceLogger2 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                    traceLogger2.log(env, 4, "XTSParameterizedHttpRequest", null, null);
                }
                Element systemElement = null;
                Element processingElement = null;
                String morphlet = this.httpServletRequest().getParameter("m");
                if (morphlet != null) {
                    if (!morphlet.startsWith("/")) {
                        morphlet = "/" + morphlet;
                    }
                    systemElement = XTSApplicationManager.getInstance().searchSystemOptions(morphlet);
                    processingElement = XTSApplicationManager.getInstance().searchProcessingOptions(morphlet);
                } else {
                    String pathInfo = this.httpServletRequest().getPathInfo();
                    if (pathInfo == null) {
                        pathInfo = "/";
                    } else if (!pathInfo.startsWith("/")) {
                        pathInfo = "/" + pathInfo;
                    }
                    List iInfoList = XTSInterfaceInfo.searchInterfaceInfo(pathInfo);
                    if (iInfoList.size() == 0) {
                        Object[] params = new String[]{pathInfo};
                        this.sendHttpError(env, new XTSHttpServletRequestException("request.invalidpath", params));
                        return;
                    }
                    XTSInterfaceInfo iInfo = (XTSInterfaceInfo)iInfoList.get(0);
                    morphlet = iInfo.getMorphlet();
                    if (morphlet == null) {
                        Object[] params = new String[]{pathInfo};
                        this.sendHttpError(env, new XTSHttpServletRequestException("request.invalidpath", params));
                        return;
                    }
                    systemElement = XTSApplicationManager.getInstance().searchSystemOptions(morphlet);
                    XTSInterface iface = iInfo.getXTSInterface();
                    processingElement = iface.getProcessingOptions();
                    Element ifaceRootElem = rootDoc.getRootElement().addElement("interfaces");
                    for (i = 0; i < iInfoList.size(); ++i) {
                        XTSInterfaceInfo info = (XTSInterfaceInfo)iInfoList.get(i);
                        ifaceRootElem.add(info.toElement());
                    }
                }
                if (systemElement != null) {
                    rootDoc.getRootElement().add(systemElement);
                }
                if (processingElement != null) {
                    rootDoc.getRootElement().add(processingElement);
                }
                try {
                    IXTSLogger traceLogger3 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger3.log(env, 2, "XTSProcessor - execute", null, null);
                    }
                    env.setMorphletName(morphlet);
                    IXTSLogger traceLogger5 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger5.log(env, 8, "execute morphlet name: " + morphlet, null, null);
                        traceLogger5.log(env, 8, "input document: " + rootDoc.asXML(), null, null);
                    }
                    XTSProcessor.getInstance(this.getCallerID()).execute(morphlet, rootDoc, env);
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                        traceLogger5.log(env, 8, "return document: " + rootDoc.asXML(), null, null);
                    }
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                        traceLogger3.log(env, 3, "XTSProcessor - execute", null, null);
                    }
                    Element outputElement = rootDoc.getRootElement().element("output");
                    this.sendOutput(env, outputElement);
                }
                catch (XTSException e) {
                    XTSException ex = e;
                    boolean handledByErrorMorphlet = false;
                    String errorMorphlet = null;
                    if (processingElement != null) {
                        List paramList = processingElement.elements("param");
                        for (i = 0; i < paramList.size(); ++i) {
                            Element paramEle = (Element)paramList.get(i);
                            String att = paramEle.attributeValue("name");
                            if (att == null || !att.equals("errorMorphlet")) continue;
                            errorMorphlet = paramEle.getTextTrim();
                            break;
                        }
                    }
                    IXTSLogger traceLogger5 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger5.log(env, 8, "error morphlet name: " + errorMorphlet, null, null);
                    }
                    if (errorMorphlet != null && errorMorphlet.length() > 0) {
                        try {
                            Element errorEle = UXTSExceptionUtils.generateErrorXML(e, env.getLocale());
                            rootDoc.getRootElement().add(errorEle);
                            Element outputElement = rootDoc.getRootElement().element("output");
                            if (outputElement != null) {
                                List outputContentList = outputElement.elements();
                                Element outputContent = null;
                                int outputContentListSize = outputContentList.size();
                                for (int i2 = 0; i2 < outputContentListSize; ++i2) {
                                    outputContent = (Element)outputContentList.get(i2);
                                    outputContent.detach();
                                }
                            }
                            env.setMorphletName(errorMorphlet);
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                                traceLogger5.log(env, 8, "input document: " + rootDoc.asXML(), null, null);
                            }
                            XTSProcessor.getInstance(this.getCallerID()).execute(errorMorphlet, rootDoc, env);
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                                traceLogger5.log(env, 8, "return document: " + rootDoc.asXML(), null, null);
                            }
                            this.sendOutput(env, outputElement);
                            handledByErrorMorphlet = true;
                        }
                        catch (XTSException errorMorphletEx) {
                            ex = errorMorphletEx;
                        }
                    }
                    if (handledByErrorMorphlet) break block34;
                    this.sendHttpError(env, ex);
                }
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                traceLogger2.log(env, 5, "XTSParameterizedHttpRequest", null, null);
            }
        }
        finally {
            env.cleanup();
        }
    }

    private Element createEnvElement() {
        Element envElement = DocumentHelper.createElement((String)"env");
        Enumeration keys = this.httpServletRequest().getParameterNames();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String[] values = this.httpServletRequest().getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                envElement.add(XTSRequestUtil.createParamElement(name, values[i]));
            }
        }
        return envElement;
    }

    private int getRequestMode() {
        Cookie[] cookies;
        int xtsMode = 0;
        String mode = this.httpServletRequest().getParameter("mode");
        if (mode != null) {
            StringTokenizer st = new StringTokenizer(mode, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("test")) {
                    xtsMode |= 1;
                    continue;
                }
                if (token.equalsIgnoreCase("debug")) {
                    xtsMode |= 2;
                    continue;
                }
                if (!token.equalsIgnoreCase("restart")) continue;
                xtsMode |= 4;
            }
        }
        if ((cookies = this.httpServletRequest().getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("XTS_DEBUG") || !cookies[i].getValue().equals("true")) continue;
                xtsMode |= 2;
            }
        }
        return xtsMode;
    }

    private void sendHttpError(XTSEnvironment env, XTSException xtsException) throws XTSHttpServletRequestException {
        Element errorElement = UXTSExceptionUtils.generateErrorXML(xtsException, env.getLocale());
        String errorString = this.sendHttpError(env, errorElement);
        if (errorString == null || errorString.equalsIgnoreCase("null")) {
            errorString = xtsException.getMessage();
        }
        try {
            this.httpServletResponse().setContentType("text/plain; charset=utf-8");
            ServletOutputStream sos = this.httpServletResponse().getOutputStream();
            sos.write(errorString.getBytes("UTF-8"));
            sos.flush();
            sos.close();
        }
        catch (IOException e) {
            throw new XTSHttpServletRequestException("http.errormsgfailed", e);
        }
    }

    private String sendHttpError(XTSEnvironment env, Element errorElement) throws XTSHttpServletRequestException {
        StringBuffer errorString = new StringBuffer();
        Element faultCodeEle = errorElement.element("faultcode");
        if (faultCodeEle != null) {
            errorString.append(faultCodeEle.getTextTrim());
        }
        errorString.append(System.getProperty("line.separator"));
        Element faultStringEle = errorElement.element("faultstring");
        if (faultStringEle != null) {
            errorString.append(faultStringEle.getTextTrim());
        }
        errorString.append(System.getProperty("line.separator"));
        Element detailEle = errorElement.element("detail");
        if (detailEle != null) {
            List exList = detailEle.elements("exception");
            for (int i = 0; i < exList.size(); ++i) {
                Element exDetailEle;
                String msg;
                Element exMsgEle;
                Element exEle = (Element)exList.get(i);
                Element exCodeEle = exEle.element("exceptionCode");
                if (exCodeEle != null) {
                    errorString.append(" ");
                    errorString.append(exCodeEle.getTextTrim());
                }
                if ((exMsgEle = exEle.element("exceptionMsg")) != null && (msg = exMsgEle.getTextTrim()) != null && msg.length() != 0 && !msg.equalsIgnoreCase("null")) {
                    errorString.append(" : ");
                    errorString.append(msg);
                }
                if ((exDetailEle = exEle.element("exceptionDetail")) != null) {
                    List errorElementList = exDetailEle.elements("error");
                    if (errorElementList.size() > 0) {
                        for (int j = 0; j < errorElementList.size(); ++j) {
                            this.sendHttpError(env, (Element)errorElementList.get(j));
                        }
                    } else {
                        String exceptionDetail = exDetailEle.getText();
                        if (exceptionDetail.length() != 0 && !exceptionDetail.equalsIgnoreCase("null")) {
                            errorString.append(" : ");
                            errorString.append(exceptionDetail);
                        }
                    }
                }
                errorString.append(System.getProperty("line.separator"));
            }
        }
        return errorString.toString();
    }
}

