/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.XTSException;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.util.LocaleUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XTSRequestUtil {
    private static String COOKIE_SEPARATOR = ",";
    private static String COOKIE_ATTRIBUTE_SEPARATOR = ";";
    private static String COOKIE_PARAM_COMMENT = "Comment";
    private static String COOKIE_PARAM_DOMAIN = "Domain";
    private static String COOKIE_PARAM_EXPIRES = "Expires";
    private static String COOKIE_PARAM_MAXAGE = "Max-age";
    private static String COOKIE_PARAM_PATH = "Path";
    private static String COOKIE_PARAM_SECURE = "Secure";
    private static String COOKIE_PARAM_VERSION = "Version";
    private static String COOKIE_PARAM_VERSION_VALUE_0 = "0";
    private static String COOKIE_PARAM_VERSION_VALUE_1 = "1";

    public static Element createParamElement(String name, String value) {
        Element paramElement = DocumentHelper.createElement((String)"param");
        paramElement.addAttribute("name", name);
        if (value != null) {
            paramElement.addText(value);
        }
        return paramElement;
    }

    public static Element createCommandFromOperation(Element operation) {
        Element cmdEle = DocumentHelper.createElement((String)"command");
        if (operation != null) {
            cmdEle.add(operation.createCopy());
        }
        return cmdEle;
    }

    public static Cookie[] parseSetCookieHeader(String headerValue) throws XTSException {
        StringTokenizer tk = new StringTokenizer(headerValue, COOKIE_SEPARATOR, false);
        if (!tk.hasMoreTokens()) {
            Cookie[] cookies = new Cookie[]{XTSRequestUtil.parseCookieDef(headerValue)};
            return cookies;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String cookie = null;
        StringBuffer cookieBuf = new StringBuffer();
        while (tk.hasMoreTokens()) {
            String expiresValue;
            int equalsPos;
            int expiresPos;
            cookieBuf.append(tk.nextToken());
            cookie = cookieBuf.toString();
            boolean bGotCookieDef = true;
            int quotePos = cookie.indexOf(34);
            while (quotePos != -1) {
                bGotCookieDef = !bGotCookieDef;
                quotePos = cookie.indexOf(34, quotePos + 1);
            }
            if (bGotCookieDef && (expiresPos = cookieBuf.toString().indexOf("Expires=")) != -1 && (equalsPos = (expiresValue = cookieBuf.toString().substring(expiresPos + 8)).indexOf(",")) == -1) {
                bGotCookieDef = false;
            }
            if (bGotCookieDef || !tk.hasMoreTokens()) {
                cookies.add(XTSRequestUtil.parseCookieDef(cookieBuf.toString().trim()));
                cookieBuf = new StringBuffer();
                continue;
            }
            cookieBuf.append(COOKIE_SEPARATOR);
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    private static Cookie parseCookieDef(String cookieDef) throws XTSException {
        Cookie cookie = null;
        StringTokenizer tk = new StringTokenizer(cookieDef, COOKIE_ATTRIBUTE_SEPARATOR, false);
        String cookie1 = null;
        StringBuffer cookieBuf = new StringBuffer();
        while (tk.hasMoreTokens()) {
            cookieBuf.append(tk.nextToken());
            cookie1 = cookieBuf.toString();
            int quotePos = cookie1.indexOf(34);
            int quoteCount = 0;
            while (quotePos != -1) {
                quotePos = cookie1.indexOf(34, quotePos + 1);
                ++quoteCount;
            }
            boolean bGotCookieDef = true;
            if (quoteCount == 0 || quoteCount == 2) {
                bGotCookieDef = true;
            } else if (quoteCount == 1) {
                bGotCookieDef = false;
            } else {
                Object[] args = new Object[]{cookieBuf.toString()};
                throw new XTSException("output.invalidcookie", args);
            }
            if (bGotCookieDef) {
                int equalsPos = cookieBuf.toString().indexOf(61);
                if (equalsPos == -1) {
                    Object[] args = new Object[]{cookieBuf.toString()};
                    throw new XTSException("output.invalidcookie", args);
                }
                String name = cookieBuf.toString().substring(0, equalsPos);
                String value = cookieBuf.toString().substring(equalsPos + 1);
                if (cookie == null) {
                    cookie = new Cookie(name, value);
                } else {
                    XTSRequestUtil.setCookieProperty(cookie, name.trim(), value.trim());
                }
                cookieBuf = new StringBuffer();
                continue;
            }
            cookieBuf.append(';');
        }
        return cookie;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setCookieProperty(Cookie cookie, String property, String value) throws XTSException {
        if (property.equalsIgnoreCase(COOKIE_PARAM_COMMENT)) {
            cookie.setComment(value);
            return;
        }
        if (property.equalsIgnoreCase(COOKIE_PARAM_DOMAIN)) {
            cookie.setDomain(value);
            return;
        }
        if (property.equalsIgnoreCase(COOKIE_PARAM_MAXAGE)) {
            int quotepos = value.indexOf(34);
            if (quotepos != -1) {
                if (value.charAt(value.length() - 1) != '\"') {
                    Object[] args = new Object[]{value, property, cookie.getName()};
                    throw new XTSException("output.invalidcookieparametervalue", args);
                }
                value = value.substring(quotepos + 1, value.indexOf(34, quotepos + 1));
            }
            int maxage = 0;
            try {
                maxage = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Object[] args = new Object[]{value, property, cookie.getName()};
                throw new XTSException("output.invalidcookieparametervalue", args, e);
            }
            cookie.setMaxAge(maxage);
            return;
        }
        if (property.equalsIgnoreCase(COOKIE_PARAM_EXPIRES)) {
            int quotepos = value.indexOf(34);
            if (quotepos != -1) {
                if (value.charAt(value.length() - 1) != '\"') {
                    Object[] args = new Object[]{value, property, cookie.getName()};
                    throw new XTSException("output.invalidcookieparametervalue", args);
                }
                value = value.substring(quotepos + 1, value.indexOf(34, quotepos + 1));
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
            Date date = null;
            try {
                date = simpleDateFormat.parse(value);
            }
            catch (Exception e) {
                Object[] args = new Object[]{value, property, cookie.getName()};
                throw new XTSException("output.invalidcookieparametervalue", args, e);
            }
            long age = date.getTime() - System.currentTimeMillis();
            if (age < 0L) {
                cookie.setMaxAge(0);
                return;
            }
            cookie.setMaxAge((int)(age / 1000L));
            return;
        }
        if (property.equalsIgnoreCase(COOKIE_PARAM_PATH)) {
            cookie.setPath(value);
            return;
        }
        if (property.equalsIgnoreCase(COOKIE_PARAM_SECURE)) {
            cookie.setSecure(true);
            return;
        }
        if (!property.equalsIgnoreCase(COOKIE_PARAM_VERSION)) {
            Object[] args = new Object[]{property, cookie.getName()};
            throw new XTSException("output.invalidcookieparameter", args);
        }
        if (value.equals(COOKIE_PARAM_VERSION_VALUE_0)) {
            cookie.setVersion(0);
            return;
        }
        if (value.equals(COOKIE_PARAM_VERSION_VALUE_1)) {
            cookie.setVersion(1);
            return;
        }
        Object[] args = new Object[]{value, property, cookie.getName()};
        throw new XTSException("output.invalidcookieparametervalue", args);
    }

    public static final Object[] getRequestLocaleAndLookupList(HttpServletRequest request) {
        boolean useContentMapping;
        Object[] ret = new Object[2];
        Locale locale = null;
        String formLang = request.getParameter("lang");
        boolean bl = useContentMapping = formLang != null && formLang.length() > 0;
        if (formLang != null && formLang.length() > 0) {
            locale = LocaleUtils.parseHttpLocaleList(formLang, true);
        } else {
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang != null && acceptLang.length() > 0) {
                locale = LocaleUtils.parseHttpLocaleList(acceptLang, false);
            }
        }
        if (locale == null) {
            try {
                locale = XTSConfigManager.getInstance().getServerLocale();
            }
            catch (XTSConfigurationException e) {
                locale = null;
            }
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        ArrayList lookupList = LocaleUtils.createLookupList(locale, useContentMapping);
        ret[0] = locale;
        ret[1] = lookupList;
        return ret;
    }

    public static final Locale getRequestLocale(HttpServletRequest request) {
        Object[] ret = XTSRequestUtil.getRequestLocaleAndLookupList(request);
        return (Locale)ret[0];
    }
}

