/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.request;

import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceInfo;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.request.AXTSHttpServletRequest;
import com.cognos.xts.request.IXTSHttpServletRequest;
import com.cognos.xts.request.XTSHttpServletRequestException;
import com.cognos.xts.request.XTSRequestUtil;
import com.cognos.xts.util.Dereferencer;
import com.cognos.xts.util.soaputil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XTSSoapOverHttpRequest
extends AXTSHttpServletRequest
implements IXTSHttpServletRequest {
    private Element m_command;

    @Override
    public void initialize(HttpServletRequest request, HttpServletResponse response, String callerID) {
        super.initialize(request, response, callerID);
    }

    protected Document createSoapRootDocument() throws XTSException {
        Document doc = this.createHttpRootDocument();
        doc.getRootElement().add(this.createEnvelopeElement());
        return doc;
    }

    private int getRequestMode() {
        Cookie[] cookies;
        int xtsMode = 0;
        String mode = this.httpServletRequest().getParameter("mode");
        if (mode != null) {
            StringTokenizer st = new StringTokenizer(mode, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("test")) {
                    xtsMode |= 1;
                    continue;
                }
                if (token.equalsIgnoreCase("debug")) {
                    xtsMode |= 2;
                    continue;
                }
                if (!token.equalsIgnoreCase("restart")) continue;
                xtsMode |= 4;
            }
        }
        if ((cookies = this.httpServletRequest().getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("XTS_DEBUG") || !cookies[i].getValue().equals("true")) continue;
                xtsMode |= 2;
            }
        }
        return xtsMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws XTSHttpServletRequestException {
        Object[] obj = XTSRequestUtil.getRequestLocaleAndLookupList(this.httpServletRequest());
        XTSEnvironment env = new XTSEnvironment(this.getCallerID());
        env.setLocale((Locale)obj[0]);
        env.setLookupList((ArrayList)obj[1]);
        env.setMode(this.getRequestMode());
        try {
            IXTSLogger traceLogger2;
            block33: {
                traceLogger2 = null;
                if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger2 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                    traceLogger2.log(env, 4, "XTSSoapOverHttpRequest", null, null);
                }
                Document rootDoc = null;
                try {
                    rootDoc = this.createSoapRootDocument();
                }
                catch (XTSException e) {
                    this.sendSoapFault(env, e);
                }
                String pathInfo = this.httpServletRequest().getPathInfo();
                if (pathInfo == null) {
                    pathInfo = "/";
                } else {
                    if (!pathInfo.startsWith("/")) {
                        pathInfo = "/" + pathInfo;
                    }
                    if (!pathInfo.endsWith("/")) {
                        pathInfo = "/" + pathInfo + "/";
                    }
                }
                String ns = this.m_command.getNamespaceURI();
                String op = this.m_command.getName();
                XTSInterfaceInfo iInfo = XTSInterfaceInfo.searchInterfaceInfo(pathInfo, ns, op);
                if (iInfo == null) {
                    Object[] params = new String[]{pathInfo, ns};
                    this.sendSoapFault(env, new XTSHttpServletRequestException("request.invalidinterface", params));
                    return;
                }
                String morphlet = iInfo.getMorphlet();
                if (morphlet == null) {
                    Object[] params = new String[]{pathInfo, this.m_command.getNamespaceURI(), this.m_command.getName()};
                    this.sendSoapFault(env, new XTSHttpServletRequestException("request.invalidoperation", params));
                    return;
                }
                Element systemElement = XTSApplicationManager.getInstance().searchSystemOptions(morphlet);
                XTSInterface iface = iInfo.getXTSInterface();
                Element processingElement = iface.getProcessingOptions();
                Element ifaceRootElem = rootDoc.getRootElement().addElement("interfaces");
                ifaceRootElem.add(iInfo.toElement());
                if (systemElement != null) {
                    rootDoc.getRootElement().add(systemElement);
                }
                if (processingElement != null) {
                    rootDoc.getRootElement().add(processingElement);
                }
                rootDoc.getRootElement().add(XTSRequestUtil.createCommandFromOperation(this.m_command));
                try {
                    IXTSLogger traceLogger3 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger3.log(env, 2, "XTSProcessor - execute", null, null);
                    }
                    env.setMorphletName(morphlet);
                    IXTSLogger traceLogger5 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger5.log(env, 8, "execute morphlet name: " + morphlet, null, null);
                        traceLogger5.log(env, 8, "input document: " + rootDoc.asXML(), null, null);
                    }
                    XTSProcessor.getInstance(this.getCallerID()).execute(morphlet, rootDoc, env);
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                        traceLogger5.log(env, 8, "return document: " + rootDoc.asXML(), null, null);
                    }
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                        traceLogger3.log(env, 3, "XTSProcessor - execute", null, null);
                    }
                    Element outputElement = rootDoc.getRootElement().element("output");
                    this.sendOutput(env, outputElement);
                }
                catch (XTSException e) {
                    XTSException ex = e;
                    boolean handledByErrorMorphlet = false;
                    String errorMorphlet = null;
                    if (processingElement != null) {
                        List paramList = processingElement.elements("param");
                        for (int i = 0; i < paramList.size(); ++i) {
                            Element paramEle = (Element)paramList.get(i);
                            String att = paramEle.attributeValue("name");
                            if (att == null || !att.equals("errorMorphlet")) continue;
                            errorMorphlet = paramEle.getTextTrim();
                            break;
                        }
                    }
                    IXTSLogger traceLogger5 = null;
                    if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                        traceLogger5.log(env, 8, "error morphlet name: " + errorMorphlet, null, null);
                    }
                    if (errorMorphlet != null && errorMorphlet.length() > 0) {
                        try {
                            Element errorEle = UXTSExceptionUtils.generateErrorXML(e, env.getLocale());
                            rootDoc.getRootElement().add(errorEle);
                            Element outputElement = rootDoc.getRootElement().element("output");
                            if (outputElement != null) {
                                List outputContentList = outputElement.elements();
                                Element outputContent = null;
                                int outputContentListSize = outputContentList.size();
                                for (int i = 0; i < outputContentListSize; ++i) {
                                    outputContent = (Element)outputContentList.get(i);
                                    outputContent.detach();
                                }
                            }
                            env.setMorphletName(errorMorphlet);
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                                traceLogger5.log(env, 8, "input document: " + rootDoc.asXML(), null, null);
                            }
                            XTSProcessor.getInstance(this.getCallerID()).execute(errorMorphlet, rootDoc, env);
                            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                                traceLogger5.log(env, 8, "return document: " + rootDoc.asXML(), null, null);
                            }
                            this.sendOutput(env, outputElement);
                            handledByErrorMorphlet = true;
                        }
                        catch (XTSException errorMorphletEx) {
                            ex = errorMorphletEx;
                        }
                    }
                    if (handledByErrorMorphlet) break block33;
                    this.sendSoapFault(env, ex);
                }
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger2 != null) {
                traceLogger2.log(env, 5, "XTSSoapOverHttpRequest", null, null);
            }
        }
        finally {
            env.cleanup();
        }
    }

    private Element createEnvelopeElement() throws XTSHttpServletRequestException {
        Element envelopeElement = DocumentHelper.createElement((String)"envelope");
        envelopeElement.add(this.createSoapEnvelope());
        return envelopeElement;
    }

    private Element createSoapEnvelope() throws XTSHttpServletRequestException {
        ServletInputStream is;
        try {
            is = this.httpServletRequest().getInputStream();
        }
        catch (IOException e) {
            throw new XTSHttpServletRequestException("soap.invalidservletinputstream", e);
        }
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            throw new XTSHttpServletRequestException("soap.documentparseerror1", e);
        }
        Document soapDoc = null;
        try {
            Dereferencer deref = new Dereferencer();
            soapDoc = deref.dereference(((SAXReader)reader.get()).read((InputStream)is));
        }
        catch (DocumentException e) {
            throw new XTSHttpServletRequestException("soap.documentparseerror1", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        if (soapDoc == null) {
            throw new XTSHttpServletRequestException("soap.documentparseerror2");
        }
        Element soapEnv = soapDoc.getRootElement();
        if (!soapEnv.getName().equals("Envelope")) {
            throw new XTSHttpServletRequestException("soap.invalidenvelope");
        }
        int version = soaputil.getSOAPVersion(soapEnv.getNamespaceURI());
        if (version == -1) {
            throw new XTSHttpServletRequestException("soap.invalidenvelope");
        }
        Element soapBody = soapEnv.element(soaputil.getSOAPBodyQName(version));
        if (soapBody != null) {
            Iterator it = soapBody.elementIterator();
            if (it.hasNext()) {
                this.m_command = (Element)it.next();
            } else {
                throw new XTSHttpServletRequestException("soap.emptysoapbody");
            }
        }
        soapEnv.detach();
        return soapEnv;
    }

    private void sendSoapFault(XTSEnvironment env, XTSException xtsException) throws XTSHttpServletRequestException {
        try {
            Element soapEnvelope = UXTSExceptionUtils.convertXTSExceptionToSoapEnvelope(xtsException, 11, env.getLocale());
            String xml = soapEnvelope.asXML();
            this.httpServletResponse().setContentType("text/xml; charset=utf-8");
            ServletOutputStream sos = this.httpServletResponse().getOutputStream();
            sos.write(xml.getBytes("UTF-8"));
            sos.flush();
            sos.close();
        }
        catch (IOException e) {
            throw new XTSHttpServletRequestException("soap.faultmsgfailed", e);
        }
    }
}

