/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.resource;

import com.cognos.xts.resource.PathUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DirEnt {
    private String m_name = null;
    private String m_path = null;
    private DirEnt m_parent = null;
    private ArrayList m_children = null;

    public DirEnt(String name) {
        this.m_name = name;
        this.m_path = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_path;
    }

    public DirEnt getParent() {
        return this.m_parent;
    }

    public List getChildren() {
        return this.m_children;
    }

    public DirEnt getImmediateChild(String name) {
        if (this.m_children != null) {
            for (int i = 0; i < this.m_children.size(); ++i) {
                DirEnt childEnt = (DirEnt)this.m_children.get(i);
                if (!childEnt.getName().equals(name)) continue;
                return childEnt;
            }
        }
        return null;
    }

    public DirEnt getChild(String path) throws IOException {
        String newpath = PathUtils.buildPath(path);
        StringTokenizer st = new StringTokenizer(newpath, "/");
        DirEnt curNode = this;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals(".")) {
                curNode = token.equals("..") ? curNode.getParent() : curNode.getImmediateChild(token);
            }
            if (curNode != null) continue;
            return null;
        }
        return curNode;
    }

    public DirEnt addImmediateChild(String child) {
        DirEnt childEnt = this.getImmediateChild(child);
        if (childEnt == null) {
            childEnt = new DirEnt(child);
            childEnt.m_path = this.m_path + "/" + child;
            childEnt.m_parent = this;
            if (this.m_children == null) {
                this.m_children = new ArrayList();
            }
            this.m_children.add(childEnt);
        }
        return childEnt;
    }

    public DirEnt addChild(String path) throws IOException {
        String newpath = PathUtils.buildPath(path);
        StringTokenizer st = new StringTokenizer(newpath, "/");
        DirEnt curNode = this;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equals(".")) {
                curNode = token.equals("..") ? curNode.getParent() : curNode.addImmediateChild(token);
            }
            if (curNode != null) continue;
            return null;
        }
        return curNode;
    }

    public void dump() {
        this.dump(0);
    }

    private void dump(int ident) {
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < ident; ++i) {
            prefix.append("    ");
        }
        System.out.println(prefix.toString() + this.m_name + " (" + this.m_path + ")");
        if (this.m_children != null) {
            for (int j = 0; j < this.m_children.size(); ++j) {
                ((DirEnt)this.m_children.get(j)).dump(ident + 1);
            }
        }
    }
}

