/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.resource;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public final class PathUtils {
    public static final String NORMALIZE_PATH_SEPARATOR = "/";
    public static final char NORMALIZE_PATH_SEPARATOR_CHAR = '/';
    public static final String NORMALIZE_CLASS_SEPARATOR = ".";
    public static final char NORMALIZE_CLASS_SEPARATOR_CHAR = '.';
    public static final String CURRENT_DIR = ".";
    public static final String PARENT_DIR = "..";

    public static String normalizeToPath(String path) {
        return path.replace('\\', '/').replace('/', '/');
    }

    public static String normalizeToClass(String path) {
        return path.replace('.', '_').replace('-', '_').replace('\\', '.').replace('/', '.');
    }

    private static String calculateRelative(File target) throws IOException {
        int i;
        File dir;
        File cwdFile = new File(".").getCanonicalFile();
        String cwdPath = cwdFile.getCanonicalPath();
        File targetFile = target.getCanonicalFile();
        String targetPath = target.getCanonicalPath();
        if (targetPath.equals(cwdPath)) {
            return ".";
        }
        if (targetPath.startsWith(cwdPath + File.separator)) {
            return targetPath.substring(cwdPath.length() + File.separator.length());
        }
        LinkedList<File> cwdList = new LinkedList<File>();
        for (dir = cwdFile; dir != null; dir = dir.getParentFile()) {
            cwdList.addFirst(dir);
        }
        LinkedList<File> fullList = new LinkedList<File>();
        for (dir = targetFile; dir != null; dir = dir.getParentFile()) {
            fullList.addFirst(dir);
        }
        while (!cwdList.isEmpty() && !fullList.isEmpty() && ((File)cwdList.getFirst()).equals((File)fullList.getFirst())) {
            cwdList.removeFirst();
            fullList.removeFirst();
        }
        StringBuffer ret = new StringBuffer();
        for (i = 0; i < cwdList.size(); ++i) {
            ret.append(File.separator).append(PARENT_DIR);
        }
        for (i = 0; i < fullList.size(); ++i) {
            ret.append(File.separator).append(((File)fullList.get(i)).getName());
        }
        return ret.substring(File.separator.length());
    }

    public static String buildPath(String path) throws IOException {
        return PathUtils.buildPath(".", path);
    }

    public static String buildPath(String base, String path) throws IOException {
        File baseFile = new File(base);
        File fullFile = new File(baseFile, path);
        if (baseFile.isAbsolute()) {
            return PathUtils.normalizeToPath(fullFile.getCanonicalPath());
        }
        return PathUtils.normalizeToPath(PathUtils.calculateRelative(fullFile));
    }

    public static boolean isChild(String root, String path) throws IOException {
        String rootPath = new File(root).getCanonicalFile().getCanonicalPath();
        String pathPath = new File(root, path).getCanonicalFile().getCanonicalPath();
        if (!rootPath.endsWith(File.separator)) {
            rootPath = rootPath + File.separator;
        }
        return pathPath.startsWith(rootPath);
    }
}

