/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.resource;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.IXTSResourceReader;
import java.io.InputStream;

public class XTSResourceManager
extends AXTSManager {
    public static final String XTS_PACKAGE_PATH = "com/cognos/xts";
    public static final String XTS_PACKAGE_INDEX = "com/cognos/xts/xts.lst";
    public static final String XTS_PACKAGE_CLASS = "com.cognos.xts";
    public static final String WEBAPPS_BASE_PATH = "WEB-INF";
    public static final String WEBAPPS_INDEX = "xts.lst";
    private static final String m_identifier = "XTSResourceManager";
    private static final XTSResourceManager m_instance = new XTSResourceManager();
    public static final String CONFIGURATION_ROOT_MACRO = "$CONFIG_ROOT$";
    public static final String CONFIGURATION_ROOT_DEFAULT = "../configuration";
    private IXTSResourceReader m_reader = null;

    public static XTSResourceManager getInstance() {
        return m_instance;
    }

    private XTSResourceManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return true;
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        throw new UnsupportedOperationException("Please use initialize(IXTSResourceReader).");
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_reader = null;
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public void initialize(IXTSResourceReader reader) throws XTSException {
        IXTSLogger logger;
        if (!this.dependenciesCheck()) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("manager.depinitfailed", args);
        }
        if (reader == null) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("manager.depinitfailed", args);
        }
        this.m_reader = reader;
        this.m_bInitialized = true;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public void reinitialize(IXTSResourceReader reader) throws XTSException {
        this.terminate();
        this.initialize(reader);
    }

    protected IXTSResourceReader getResourceReader() {
        return this.m_reader;
    }

    public InputStream getResourceFromClassLoader(String name) throws XTSException {
        if (this.m_reader == null) {
            return null;
        }
        return this.m_reader.getResourceFromClassLoader(name);
    }

    public InputStream getResourceFromTemplates(String name) throws XTSException {
        if (this.m_reader == null) {
            return null;
        }
        return this.m_reader.getResourceFromTemplates(name);
    }

    public InputStream getResource(String name) throws XTSException {
        if (this.m_reader == null) {
            return null;
        }
        return this.m_reader.getResource(name);
    }

    public boolean exists(String name) throws XTSException {
        if (this.m_reader == null) {
            return false;
        }
        return this.m_reader.getResource(name) != null;
    }

    public DirEnt getTemplateRoot() throws XTSException {
        if (this.m_reader == null) {
            return null;
        }
        return this.m_reader.getTemplateRoot();
    }
}

