/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.security;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.HashMap;
import java.util.Map;

public class XTSSecurityFactory
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "SecurityFactory";
    private static final String PROPERTY_PREFIX = "security.class.";
    private static final String CACHE_SIZE = "securitycache.size";
    public static final String ATTR_KEY1 = "name";
    private static XTSSecurityFactory m_factory = new XTSSecurityFactory();
    private HashMap m_oSecurityMap = new HashMap();
    private int m_iCacheSize = 25;

    public static XTSSecurityFactory getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        String classname = (String)this.m_oSecurityMap.get(key);
        if (classname == null) {
            Object[] args = new String[]{key};
            throw new XTSCacheException("securityfactory.undefinedsecurity", args);
        }
        return classname;
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return (String)atts.get(ATTR_KEY1);
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        HashMap propMap;
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("securityfactory.cacheinitfailed", e);
            }
        }
        if ((propMap = PropertiesManager.getInstance().getPropertiesMap(PROPERTY_PREFIX)).size() > 0) {
            String secClassName = null;
            String secName = null;
            Map.Entry pair2 = null;
            for (Map.Entry pair2 : propMap.entrySet()) {
                secClassName = (String)pair2.getValue();
                secName = ((String)pair2.getKey()).substring(PROPERTY_PREFIX.length());
                this.m_oSecurityMap.put(secName, secClassName);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
        this.m_oSecurityMap.clear();
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        String key = (String)atts.get(ATTR_KEY1);
        return this.m_oSecurityMap.containsKey(key);
    }
}

