/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.servlet;

import com.cognos.xts.XTSException;
import com.cognos.xts.properties.IXTSPropertiesCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;

class PropCallback
implements IXTSPropertiesCallback {
    private static final String BASEPATH = "/WEB-INF/";
    private ServletContext m_context = null;

    public PropCallback(ServletContext context) {
        this.m_context = context;
    }

    @Override
    public Properties loadRuntimeProperties() throws XTSException {
        File tempdir;
        Properties prop = new Properties();
        if (this.m_context != null && (tempdir = (File)this.m_context.getAttribute("javax.servlet.context.tempdir")) != null) {
            prop.put("xts.tempdir", tempdir.getAbsolutePath());
        }
        return prop;
    }

    @Override
    public Properties loadProperties(String filename) throws XTSException {
        InputStream is;
        Properties prop = new Properties();
        if (this.m_context != null && (is = this.m_context.getResourceAsStream(BASEPATH + filename)) != null) {
            try {
                prop.load(is);
            }
            catch (IOException e) {
                Object[] args = new String[]{filename};
                throw new XTSException("property.loadPropertyFile", args, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    @Override
    public InputStream loadResource(String filename) throws XTSException {
        InputStream is = null;
        if (this.m_context != null) {
            is = this.m_context.getResourceAsStream(BASEPATH + filename);
        }
        return is;
    }
}

