/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.servlet;

import com.cognos.xts.XTSException;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.IXTSResourceReader;
import com.cognos.xts.resource.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletContext;

public class XTSServletResourceReader
implements IXTSResourceReader {
    private ServletContext m_context = null;
    private IXTSConfiguration m_config = null;
    private DirEnt m_root = null;

    public XTSServletResourceReader(ServletContext context, IXTSConfiguration config) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.m_context = context;
        this.m_config = config;
    }

    @Override
    public InputStream getResourceFromClassLoader(String name) throws XTSException {
        InputStream is = null;
        try {
            String sFile = PathUtils.buildPath("com/cognos/xts", name);
            is = this.getClass().getClassLoader().getResourceAsStream(sFile);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public InputStream getResourceFromTemplates(String name) throws XTSException {
        String sFile;
        InputStream is = null;
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        try {
            if (!PathUtils.isChild(templateRoot, name)) {
                Object[] args = new String[]{name};
                throw new XTSException("reader.securityviolation", args);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new XTSException("reader.securityviolation", args);
        }
        try {
            sFile = PathUtils.buildPath(PathUtils.buildPath("WEB-INF", templateRoot), name);
            is = this.m_context.getResourceAsStream("/" + sFile);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        try {
            sFile = PathUtils.buildPath(templateRoot, name);
            is = this.m_config != null ? new FileInputStream(this.m_config.getPhysicalPath(sFile)) : new FileInputStream(sFile);
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public InputStream getResource(String name) throws XTSException {
        String sFile;
        InputStream is = null;
        try {
            String sFile2 = PathUtils.buildPath("com/cognos/xts", name);
            is = this.getClass().getClassLoader().getResourceAsStream(sFile2);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        try {
            if (!PathUtils.isChild(templateRoot, name)) {
                Object[] args = new String[]{name};
                throw new XTSException("reader.securityviolation", args);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new XTSException("reader.securityviolation", args);
        }
        try {
            sFile = PathUtils.buildPath(PathUtils.buildPath("WEB-INF", templateRoot), name);
            is = this.m_context.getResourceAsStream("/" + sFile);
            if (is != null) {
                return is;
            }
        }
        catch (IOException e) {
            is = null;
        }
        try {
            sFile = PathUtils.buildPath(templateRoot, name);
            is = this.m_config != null ? new FileInputStream(this.m_config.getPhysicalPath(sFile)) : new FileInputStream(sFile);
        }
        catch (IOException e) {
            is = null;
        }
        return is;
    }

    @Override
    public DirEnt getTemplateRoot() throws XTSException {
        if (this.m_root != null) {
            return this.m_root;
        }
        this.m_root = new DirEnt(".");
        this.getJARDirectories(this.m_root);
        this.getServletDirectories(this.m_root);
        this.getFSDirectories(this.m_root);
        return this.m_root;
    }

    private void getJARDirectories(DirEnt root) {
        Enumeration<URL> idxlist = null;
        try {
            idxlist = this.getClass().getClassLoader().getResources("com/cognos/xts/xts.lst");
        }
        catch (IOException e) {
            return;
        }
        while (idxlist.hasMoreElements()) {
            try {
                URL idxFile = idxlist.nextElement();
                InputStream is = idxFile.openStream();
                if (is == null) continue;
                this.addChildDirectories(root, is);
            }
            catch (IOException iOException) {}
        }
    }

    private void addChildDirectories(DirEnt root, InputStream is) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            root.addChild(line);
        }
    }

    private void getServletDirectories(DirEnt root) {
        if (this.m_context.getMajorVersion() == 2 && this.m_context.getMinorVersion() == 2) {
            this.getServlet22Directories(root);
        } else {
            this.getServlet23Directories(root);
        }
    }

    private void getServlet22Directories(DirEnt root) {
        StringBuffer idxFilePath = new StringBuffer("/").append("WEB-INF");
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        if (templateRoot.charAt(0) != '/') {
            idxFilePath.append("/");
        }
        idxFilePath.append(templateRoot);
        if (idxFilePath.charAt(idxFilePath.length() - 1) != '/') {
            idxFilePath.append("/");
        }
        idxFilePath.append("xts.lst");
        InputStream is = this.m_context.getResourceAsStream(idxFilePath.toString());
        if (is != null) {
            try {
                this.addChildDirectories(root, is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void getServlet23Directories(DirEnt root) {
        StringBuffer basePath = new StringBuffer("/").append("WEB-INF");
        String templateRoot = PathUtils.normalizeToPath(PropertiesManager.getInstance().getProperty("template.root"));
        if (templateRoot.charAt(0) != '/') {
            basePath.append("/");
        }
        basePath.append(templateRoot);
        if (basePath.charAt(basePath.length() - 1) != '/') {
            basePath.append("/");
        }
        this.addServlet23Ent(basePath.toString(), root);
    }

    private void addServlet23Ent(String basePath, DirEnt ent) {
        Set set = this.m_context.getResourcePaths(basePath);
        if (set != null) {
            for (String entry : set) {
                if (!entry.endsWith("/")) continue;
                try {
                    String childname = entry.substring(basePath.length(), entry.length() - "/".length());
                    DirEnt childEnt = ent.addChild(childname);
                    this.addServlet23Ent(entry, childEnt);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void getFSDirectories(DirEnt root) {
        String basePath = PropertiesManager.getInstance().getProperty("template.root");
        try {
            File baseFile = new File(this.m_config.getPhysicalPath(basePath));
            if (!baseFile.isDirectory()) {
                return;
            }
            this.addFSEnt(baseFile, root);
        }
        catch (XTSException e) {
            return;
        }
    }

    private void addFSEnt(File baseFile, DirEnt ent) {
        File[] childrenFiles = baseFile.listFiles();
        if (childrenFiles == null) {
            return;
        }
        for (int i = 0; i < childrenFiles.length; ++i) {
            File childFile = childrenFiles[i];
            if (!childFile.isDirectory()) continue;
            try {
                DirEnt childEnt = ent.addChild(childFile.getName());
                this.addFSEnt(childFile, childEnt);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

