/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.servlet;

import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.request.IXTSHttpServletRequest;
import com.cognos.xts.request.XTSHttpServletRequestGenerator;
import com.cognos.xts.servlet.IXTSServletConfiguration;
import com.cognos.xts.servlet.PropCallback;
import com.cognos.xts.servlet.XTSServletResourceReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class transerv
extends HttpServlet {
    private static final String CLASS_NAME_GET = "GET";
    private static final String CLASS_NAME_SOAP = "SOAP";
    private static final String CLASS_NAME_POST = "POST";
    private static final String CALLER_ID = "";
    private static int m_majorVersion = 0;
    private static int m_minorVersion = 0;
    private static boolean m_ServletAPI22 = false;

    public void init() throws ServletException {
        ServletContext context = this.getServletContext();
        m_majorVersion = context.getMajorVersion();
        m_minorVersion = context.getMinorVersion();
        if (m_majorVersion < 2) {
            throw new ServletException("Unsupported Servlet API version: " + m_majorVersion + "." + m_minorVersion);
        }
        if (m_minorVersion < 2) {
            throw new ServletException("Unsupported Servlet API version: " + m_majorVersion + "." + m_minorVersion);
        }
        if (m_majorVersion == 2 && m_minorVersion == 2) {
            m_ServletAPI22 = true;
        }
        try {
            IXTSConfiguration config = null;
            String configClass = this.getInitParameter("ConfigurationClass");
            if (configClass != null) {
                try {
                    Object obj = Class.forName(configClass).newInstance();
                    if (obj instanceof IXTSConfiguration && (config = (IXTSConfiguration)obj) instanceof IXTSServletConfiguration) {
                        IXTSServletConfiguration servletconfig = (IXTSServletConfiguration)config;
                        servletconfig.setServletContext(this.getServletContext());
                    }
                }
                catch (InstantiationException e) {
                    config = null;
                }
                catch (IllegalAccessException e) {
                    config = null;
                }
                catch (ClassNotFoundException e) {
                    config = null;
                }
            }
            XTSProcessor.getInstance(CALLER_ID).initialize(config, new XTSServletResourceReader(context, config), new PropCallback(context), null, true);
        }
        catch (XTSException e) {
            e.printStackTrace(System.err);
            throw new ServletException("XTS failed to start.");
        }
    }

    public void destroy() {
        try {
            XTSProcessor.getInstance(CALLER_ID).terminate(true);
        }
        catch (XTSException e) {
            e.printStackTrace(System.err);
        }
    }

    public String getServletInfo() {
        return "Cognos XTS Servlet: transerv";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (!m_ServletAPI22) {
                try {
                    String enc = PropertiesManager.getInstance().getProperty("servlet.encoding");
                    if (enc != null && enc.length() > 0) {
                        request.setCharacterEncoding(enc);
                    } else {
                        request.setCharacterEncoding("UTF-8");
                    }
                }
                catch (UnsupportedEncodingException enc) {
                    // empty catch block
                }
            }
            this.handleRequest(request, response, true);
        }
        catch (XTSException e) {
            throw new ServletException(e.getRootCauseLocalizedMsgString(Locale.getDefault()));
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (!m_ServletAPI22) {
                try {
                    String enc = PropertiesManager.getInstance().getProperty("servlet.encoding");
                    if (enc != null && enc.length() > 0) {
                        request.setCharacterEncoding(enc);
                    } else {
                        request.setCharacterEncoding("UTF-8");
                    }
                }
                catch (UnsupportedEncodingException enc) {
                    // empty catch block
                }
            }
            this.handleRequest(request, response, false);
        }
        catch (XTSException e) {
            throw new ServletException(e.getRootCauseLocalizedMsgString(Locale.getDefault()));
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response, boolean bGet) throws XTSException {
        String className = null;
        String servletPath = request.getServletPath();
        int lastSlashPos = servletPath.lastIndexOf(47);
        if (lastSlashPos > 0) {
            className = servletPath.substring(lastSlashPos + 1);
        }
        if (className != null && !XTSHttpServletRequestGenerator.isHandlerDefined(className)) {
            className = null;
        }
        if (className == null) {
            if (bGet) {
                className = CLASS_NAME_GET;
            } else {
                className = CLASS_NAME_POST;
                String sContentType = request.getContentType();
                if (sContentType == null) {
                    Object[] args = new String[]{className};
                    throw new XTSException("request.emptycontenttype", args);
                }
                if (sContentType.startsWith("text/xml")) {
                    className = CLASS_NAME_SOAP;
                } else if (!sContentType.startsWith("application/x-www-form-urlencoded")) {
                    Object[] args = new String[]{className, sContentType};
                    throw new XTSException("request.invalidpostcontenttype", args);
                }
            }
        }
        IXTSHttpServletRequest requestHandler = XTSHttpServletRequestGenerator.createHandler(className, request, response, CALLER_ID);
        requestHandler.execute();
    }
}

