/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.XTSException;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public final class BasicTransformer
implements URIResolver {
    private static final String XSLT_CLASS_NAME = "jd.xml.xslt.trax.TransformerFactoryImpl";
    private String m_sResolverBase = null;
    private Templates m_oCachedTemplate = null;

    public BasicTransformer(Source stylesheetSource) throws TransformerException {
        try {
            TransformerFactory factory = (TransformerFactory)Class.forName(XSLT_CLASS_NAME).newInstance();
            factory.setURIResolver(this);
            this.m_oCachedTemplate = factory.newTemplates(stylesheetSource);
            this.m_sResolverBase = ".";
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public BasicTransformer(Source stylesheetSource, String resolverBase) throws TransformerException {
        try {
            TransformerFactory factory = (TransformerFactory)Class.forName(XSLT_CLASS_NAME).newInstance();
            factory.setURIResolver(this);
            this.m_oCachedTemplate = factory.newTemplates(stylesheetSource);
            this.m_sResolverBase = resolverBase == null ? "." : resolverBase;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this.m_oCachedTemplate == null) {
            throw new TransformerException(new XTSException("util.transfomfailed"));
        }
        try {
            Transformer transformer = null;
            transformer = this.m_oCachedTemplate.newTransformer();
            transformer.setURIResolver(this);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException(new XTSException("util.transfomfailed"));
        }
        catch (TransformerException e) {
            throw new TransformerException(new XTSException("util.transfomfailed"));
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (href.indexOf(58) == -1) {
                String name = PathUtils.buildPath(this.m_sResolverBase, href);
                InputStream is = null;
                try {
                    is = XTSResourceManager.getInstance().getResource(name);
                }
                catch (XTSException e) {
                    Object[] args = new String[]{" ", href};
                    throw new TransformerException(new XTSException("reader.nonexistantfile", args));
                }
                if (is == null) {
                    Object[] args = new String[]{" ", href};
                    throw new TransformerException(new XTSException("reader.nonexistantfile", args));
                }
                return new StreamSource(is, name);
            }
            return new StreamSource(href);
        }
        catch (IOException e) {
            Object[] args = new String[]{href, this.m_sResolverBase};
            throw new TransformerException(new XTSException("util.resolverfailed", args));
        }
    }
}

