/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.properties.PropertiesManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;

public final class CogXConnection {
    private static final String PROPERTY_SUFFIX_HOST = ".host";
    private static final String PROPERTY_SUFFIX_PORT = ".port";
    private static final String PROPERTY_SUFFIX_ENCODING = ".encoding";
    private static final byte[] m_cogx_header = new byte[]{120, 48, 48, 50};
    private static final String m_XML_START_HEADER = "<?xml version=\"1.0\" encoding=\"";
    private static final String m_XML_END_HEADER = "\" standalone=\"yes\"?>";
    private static final String REQUEST_HREF_COGX = "cogx://";
    private byte[] m_routing;
    private byte[] m_result;
    private Socket m_socket;
    private String m_hostName = null;
    private int m_portNumber = 0;
    private boolean m_bConnected = false;
    private String m_sEncoding = "UTF-8";
    private String m_sCogxTarget = null;

    public CogXConnection(String target, String host, String port, String encoding) throws MalformedURLException {
        if (target == null) {
            throw new NullPointerException("No target specified for Cogx request.");
        }
        if (target.length() == 0) {
            throw new MalformedURLException("Empty target specified. for Cogx request.");
        }
        if (!target.startsWith(REQUEST_HREF_COGX)) {
            throw new MalformedURLException("Invalid target for Cogx request: " + target);
        }
        this.m_sCogxTarget = target.substring(REQUEST_HREF_COGX.length());
        this.m_hostName = host;
        if (this.m_hostName == null) {
            this.m_hostName = PropertiesManager.getInstance().getProperty(this.m_sCogxTarget + PROPERTY_SUFFIX_HOST);
            if (this.m_hostName == null) {
                throw new MalformedURLException("Failed to retrieve host from properties file for target: " + target);
            }
        }
        if (port == null) {
            port = PropertiesManager.getInstance().getProperty(this.m_sCogxTarget + PROPERTY_SUFFIX_PORT);
            if (port == null) {
                throw new MalformedURLException("Failed to retrieve port number from properties file for target: " + target);
            }
            try {
                this.m_portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Invalid port number in properties file for target: " + target);
            }
        }
        try {
            this.m_portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new MalformedURLException("Invalid port number in properties file for target: " + target);
        }
        this.m_sEncoding = encoding;
        if (this.m_sEncoding == null) {
            this.m_sEncoding = PropertiesManager.getInstance().getProperty(this.m_sCogxTarget + PROPERTY_SUFFIX_ENCODING);
            if (this.m_sEncoding == null) {
                throw new MalformedURLException("Failed to retrieve encoding from properties file for target: " + target);
            }
        }
    }

    public void connect() throws IOException {
        this.m_socket = new Socket(this.m_hostName, this.m_portNumber);
        this.m_bConnected = true;
    }

    public void disconnect() {
        if (this.m_bConnected) {
            try {
                if (this.m_socket != null) {
                    this.m_socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(byte[] routing, byte[] command) throws IOException {
        if (!this.m_bConnected) {
            throw new IOException("not connected");
        }
        DataOutputStream dos = new DataOutputStream(this.m_socket.getOutputStream());
        dos.write(m_cogx_header);
        routing = this.appendHeader(routing);
        dos.writeInt(routing.length);
        dos.write(routing);
        command = this.appendHeader(command);
        dos.writeInt(command.length);
        dos.write(command);
        dos.flush();
    }

    public void read() throws IOException {
        DataInputStream dis;
        if (this.m_bConnected) {
            dis = new DataInputStream(this.m_socket.getInputStream());
            byte[] cogx_header = new byte[4];
            this.read(cogx_header);
            if (!this.headers_match(cogx_header, m_cogx_header)) {
                throw new IOException("response.malformed.missingmarker: " + m_cogx_header.toString());
            }
        } else {
            throw new IOException("not connected");
        }
        int length = dis.readInt();
        this.m_routing = new byte[length];
        this.read(this.m_routing);
        length = dis.readInt();
        this.m_result = new byte[length];
        this.read(this.m_result);
    }

    public byte[] getRouting() {
        return this.m_routing;
    }

    public byte[] getResult() {
        return this.m_result;
    }

    public String getEncoding() {
        return this.m_sEncoding;
    }

    public String getHost() {
        return this.m_hostName;
    }

    public String getPortString() {
        return Integer.toString(this.m_portNumber);
    }

    public String getTarget() {
        return this.m_sCogxTarget;
    }

    private boolean headers_match(byte[] arr1, byte[] arr2) {
        boolean equal = arr1.length == arr2.length;
        for (int i = 0; i < arr1.length && equal; ++i) {
            equal = arr1[i] == arr2[i];
        }
        return equal;
    }

    private void read(byte[] buffer) throws IOException {
        int length = buffer.length;
        int amount_read = 0;
        int bytes_read = 0;
        while (amount_read < length && bytes_read >= 0) {
            bytes_read = this.m_socket.getInputStream().read(buffer, amount_read, length - amount_read);
            if (bytes_read < 0) continue;
            amount_read += bytes_read;
        }
    }

    private byte[] appendHeader(byte[] xml_section) {
        byte[] result = xml_section;
        if (!new String(xml_section).trim().startsWith("<?xml")) {
            result = new StringBuffer(new String(xml_section).trim()).insert(0, m_XML_START_HEADER + this.getEncoding() + m_XML_END_HEADER).toString().getBytes();
        }
        return result;
    }
}

