/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class Dereferencer {
    public Document dereference(Document document) {
        Element envelope = document.getRootElement();
        Element header = envelope.element("Header");
        HashMap headerMap = null;
        if (header != null) {
            headerMap = this.getIds(header);
        }
        if (header != null && headerMap.size() > 0) {
            this.fixupElement(header, headerMap);
            Element body = envelope.element("Body");
            HashMap bodyMap = this.getIds(body);
            if (bodyMap.size() > 0) {
                this.fixupElement(body, bodyMap);
            }
        } else {
            HashMap bodyMap;
            Element body = envelope.element("Body");
            if (body != null && (bodyMap = this.getIds(body)).size() > 0) {
                this.fixupElement(envelope, bodyMap);
            }
        }
        return document;
    }

    private HashMap getIds(Element baseElement) {
        HashMap<String, IdElement> idmap = new HashMap<String, IdElement>();
        Iterator iditer = baseElement.elementIterator();
        while (iditer.hasNext()) {
            Element element = (Element)iditer.next();
            String idAttr = element.attributeValue("id");
            if (idAttr == null) continue;
            idmap.put(idAttr, new IdElement(element));
        }
        return idmap;
    }

    private void fixupElement(Element idElement, HashMap idMap) {
        String attr = idElement.attributeValue("href");
        if (attr != null) {
            this.deref(idElement, idMap);
        } else {
            List list = idElement.elements();
            for (Element e : list) {
                this.fixupElement(e, idMap);
            }
        }
    }

    private void deref(Element refElement, HashMap idMap) {
        String hrefVal = refElement.attributeValue("href");
        if (hrefVal == null) {
            return;
        }
        String hrefName = hrefVal.substring(1);
        IdElement frog = (IdElement)idMap.get(hrefName);
        Element idElement = frog.element;
        if (!frog.fixed) {
            idElement.detach();
            idElement = frog.element.createCopy(refElement.getQName());
            this.fixupElement(idElement, idMap);
            idElement.remove(frog.element.attribute("id"));
            frog.fixed = true;
        } else {
            idElement = frog.element.createCopy(refElement.getQName());
        }
        Element parent = refElement.getParent();
        List parentContent = parent.content();
        int childIndex = parentContent.indexOf(refElement);
        parentContent.set(childIndex, idElement);
    }

    public static void main(String[] args) {
        Dereferencer deref = new Dereferencer();
        SAXReader reader = new SAXReader();
        long startTime = System.currentTimeMillis();
        Document doc = null;
        try {
            DataInputStream inStream = new DataInputStream(deref.getClass().getClassLoader().getResourceAsStream("com/cognos/pogo/pdk/test/multiref.xml"));
            doc = reader.read((InputStream)inStream);
        }
        catch (DocumentException e) {
            return;
        }
        try {
            Document derefed = deref.dereference(doc);
            XMLWriter output = new XMLWriter((OutputStream)System.out);
            output.write(derefed);
        }
        catch (UnsupportedEncodingException derefed) {
        }
        catch (IOException derefed) {
            // empty catch block
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        System.out.println("My Transform took: " + timeTaken + "ms");
    }

    private final class IdElement {
        Element element;
        boolean fixed = false;

        IdElement(Element element) {
            this.element = element;
        }
    }
}

