/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;

public class DirectoryManager {
    private LinkedList m_orderList = new LinkedList();
    private long m_curSize = 0L;
    private long m_maxSize = 0L;
    private String m_marker;

    public DirectoryManager(long maxSize, String marker) {
        this.m_maxSize = maxSize;
        this.m_marker = marker;
    }

    public synchronized void scan(File oFile) {
        if (!oFile.exists()) {
            return;
        }
        this.m_curSize = this.getsize(oFile);
        Collections.sort(this.m_orderList);
        if (this.m_curSize > this.m_maxSize) {
            this.cleanup(null);
        }
    }

    public synchronized void add(File oFile) {
        if (!oFile.exists()) {
            return;
        }
        this.m_curSize += this.getsize(oFile);
        Collections.sort(this.m_orderList);
        if (this.m_curSize > this.m_maxSize) {
            this.cleanup(oFile);
        }
    }

    public synchronized void clear() {
        this.m_curSize = 0L;
        this.m_orderList.clear();
    }

    private void cleanup(File oFile) {
        while (this.m_orderList.size() != 0) {
            dirent entry = (dirent)this.m_orderList.getFirst();
            if (oFile != null && entry.getPath().equals(oFile)) break;
            entry = (dirent)this.m_orderList.removeFirst();
            this.deletedir(entry.getPath());
            this.m_curSize -= entry.getSize();
            if (this.m_curSize >= this.m_maxSize) continue;
            break;
        }
    }

    private void deletedir(File oFile) {
        if (!oFile.exists()) {
            return;
        }
        if (oFile.isDirectory()) {
            File[] list = oFile.listFiles();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                this.deletedir(list[i]);
            }
        }
        oFile.delete();
    }

    private long getsize(File oFile) {
        if (!oFile.exists()) {
            return 0L;
        }
        boolean setMark = false;
        if (oFile.isDirectory()) {
            File[] list = oFile.listFiles();
            if (list == null) {
                return 0L;
            }
            long totalsize = 0L;
            for (int i = 0; i < list.length; ++i) {
                if (list[i].getName().equals(this.m_marker)) {
                    setMark = true;
                }
                totalsize += this.getsize(list[i]);
            }
            if (setMark) {
                dirent entry = new dirent(oFile, totalsize);
                this.m_orderList.add(entry);
            }
            return totalsize;
        }
        return oFile.length();
    }

    private class dirent
    implements Comparable {
        private File m_path;
        private long m_size;
        private long m_modifytime;

        public dirent(File path, long size) {
            this.m_path = path;
            this.m_size = size;
            this.m_modifytime = path.lastModified();
        }

        public File getPath() {
            return this.m_path;
        }

        public long getSize() {
            return this.m_size;
        }

        public int compareTo(Object o) {
            if (this.m_modifytime == ((dirent)o).m_modifytime) {
                return 0;
            }
            if (this.m_modifytime > ((dirent)o).m_modifytime) {
                return 1;
            }
            return -1;
        }
    }
}

