/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public final class LocaleUtils {
    public static String toJavaString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        if (country.length() == 0) {
            return locale.getLanguage();
        }
        StringBuffer ret = new StringBuffer();
        ret.append(locale.getLanguage()).append("_").append(country.toUpperCase());
        return ret.toString();
    }

    public static String toJavaString(String locale) {
        if (locale == null) {
            return null;
        }
        if ((locale = locale.trim()).length() == 0) {
            return null;
        }
        int idx = (locale = locale.replace('-', '_')).indexOf(95);
        if (idx != -1) {
            StringBuffer ret = new StringBuffer();
            ret.append(locale.substring(0, idx).toLowerCase()).append("_").append(locale.substring(idx + 1).toUpperCase());
            return ret.toString();
        }
        return locale.toLowerCase();
    }

    public static String toNormalizedString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        if (country.length() == 0) {
            return locale.getLanguage();
        }
        StringBuffer ret = new StringBuffer();
        ret.append(locale.getLanguage()).append("-").append(country.toLowerCase());
        return ret.toString();
    }

    public static String toNormalizedString(String locale) {
        if (locale == null) {
            return null;
        }
        if ((locale = locale.trim()).length() == 0) {
            return null;
        }
        if ((locale = locale.replace('_', '-').toLowerCase()).length() > 5) {
            locale = locale.substring(0, 5);
        }
        return locale;
    }

    public static Locale toLocale(String locale) {
        if (locale == null) {
            return null;
        }
        if ((locale = locale.trim()).length() == 0) {
            return null;
        }
        int idx = locale.indexOf(45);
        if (idx != -1) {
            return new Locale(locale.substring(0, idx).toLowerCase(), locale.substring(idx + 1).toUpperCase());
        }
        return new Locale(locale.toLowerCase(), "");
    }

    public static Locale parseHttpLocaleList(String localelist, boolean content) {
        if (localelist == null || localelist.length() == 0) {
            return null;
        }
        Locale firstNonEmptyMapping = null;
        StringTokenizer st = new StringTokenizer(localelist, ",");
        while (st.hasMoreTokens()) {
            String locale = st.nextToken().trim();
            int idx = locale.indexOf(";");
            if (idx != -1) {
                locale = locale.substring(0, idx);
            }
            Locale lo = LocaleUtils.toLocale(LocaleUtils.toNormalizedString(locale));
            try {
                if (content) {
                    if (XTSConfigManager.getInstance().validateContentLocale(lo)) {
                        return lo;
                    }
                    if (firstNonEmptyMapping != null) continue;
                    firstNonEmptyMapping = XTSConfigManager.getInstance().mapContentLocale(lo);
                    continue;
                }
                if (XTSConfigManager.getInstance().validateProductLocale(lo)) {
                    return lo;
                }
                if (firstNonEmptyMapping != null) continue;
                firstNonEmptyMapping = XTSConfigManager.getInstance().mapProductLocale(lo);
            }
            catch (XTSConfigurationException e) {
                return null;
            }
        }
        return firstNonEmptyMapping;
    }

    public static ArrayList createLookupList(Locale locale, boolean content) {
        ArrayList<Locale> ret = new ArrayList<Locale>();
        if (locale != null) {
            ret.add(locale);
            try {
                Locale mappedLocale;
                Locale locale2 = mappedLocale = content ? XTSConfigManager.getInstance().mapContentLocale(locale) : XTSConfigManager.getInstance().mapProductLocale(locale);
                if (mappedLocale != null) {
                    ret.add(mappedLocale);
                }
            }
            catch (XTSConfigurationException mappedLocale) {
                // empty catch block
            }
        }
        try {
            Locale serverLocale = XTSConfigManager.getInstance().getServerLocale();
            if (serverLocale != null) {
                ret.add(serverLocale);
            }
        }
        catch (XTSConfigurationException xTSConfigurationException) {
            // empty catch block
        }
        ret.add(Locale.ENGLISH);
        return ret;
    }
}

