/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.util.ByteArrayIOStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class MultipartMimeInputStream
extends InputStream {
    public static final String MIME_BOUNDARY_PREAMBLE = "--";
    public static final String MIME_BOUNDARY_POSTAMBLE = "--";
    InputStream m_isExternal = null;
    InputStream m_isInternal = null;
    String m_sOldBoundaryStart = null;
    String m_sOldBoundaryEnd = null;
    byte[] m_newBoundaryStartCRLF = null;
    byte[] m_newBoundaryEndCRLF = null;
    int m_nextByte = 0;
    boolean m_bIncludeBoundaryEnd = false;
    boolean m_bReturnFirstPartOnly = true;
    boolean m_closeOnClose = true;

    public MultipartMimeInputStream(InputStream in, String oldBoundaryString, boolean closeOnClose) throws UnsupportedEncodingException, IOException {
        this.m_isExternal = in;
        this.m_closeOnClose = closeOnClose;
        this.m_sOldBoundaryStart = "--" + oldBoundaryString;
        this.m_sOldBoundaryEnd = this.m_sOldBoundaryStart + "--";
        this.m_newBoundaryStartCRLF = (this.m_sOldBoundaryStart + "\r\n").getBytes("UTF-8");
        this.m_newBoundaryEndCRLF = (this.m_sOldBoundaryEnd + "\r\n").getBytes("UTF-8");
        this.m_nextByte = this.m_isExternal.read();
    }

    public boolean getReturnFirstPartOnly() {
        return this.m_bReturnFirstPartOnly;
    }

    public void setReturnFirstPartOnly(boolean bReturnFirstPartOnly) {
        this.m_bReturnFirstPartOnly = bReturnFirstPartOnly;
    }

    public void setBoundaryString(String newBoundaryString) throws UnsupportedEncodingException {
        this.m_newBoundaryStartCRLF = ("--" + newBoundaryString + "\r\n").getBytes("UTF-8");
        this.m_newBoundaryEndCRLF = ("--" + newBoundaryString + "--" + "\r\n").getBytes("UTF-8");
    }

    public void setIncludeBoundaryEnd(boolean bInclude) {
        this.m_bIncludeBoundaryEnd = bInclude;
    }

    public boolean getIncludeBoundaryEnd() {
        return this.m_bIncludeBoundaryEnd;
    }

    @Override
    public int available() throws IOException {
        return this.m_isExternal.available();
    }

    @Override
    public void close() throws IOException {
        if (this.m_closeOnClose && this.m_isExternal != null) {
            this.m_isExternal.close();
        }
        if (this.m_isInternal != null) {
            this.m_isInternal.close();
        }
        this.m_isExternal = null;
        this.m_isInternal = null;
        this.m_sOldBoundaryStart = null;
        this.m_sOldBoundaryEnd = null;
        this.m_newBoundaryStartCRLF = null;
        this.m_newBoundaryEndCRLF = null;
        this.m_closeOnClose = true;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int currentByte = this.m_nextByte;
        if (currentByte == -1) {
            return -1;
        }
        if (this.m_isInternal == null) {
            this.m_nextByte = this.m_isExternal.read();
        } else {
            this.m_nextByte = this.m_isInternal.read();
            if (this.m_nextByte == -1) {
                this.m_isInternal.close();
                this.m_isInternal = null;
                this.m_nextByte = this.m_isExternal.read();
            }
        }
        if (this.m_nextByte != -1 && currentByte == 13 && this.m_nextByte == 10) {
            String line;
            ByteArrayIOStream out = new ByteArrayIOStream(128);
            int aByte = this.m_isExternal.read();
            while (aByte != -1 && aByte != 10) {
                out.write(aByte);
                aByte = this.m_isExternal.read();
            }
            if (aByte != -1) {
                out.write(aByte);
            }
            if ((line = out.toString("UTF-8").trim()).equals(this.m_sOldBoundaryStart)) {
                if (this.m_bReturnFirstPartOnly) {
                    if (this.m_bIncludeBoundaryEnd) {
                        this.m_isInternal = new ByteArrayInputStream(this.m_newBoundaryEndCRLF);
                    } else {
                        currentByte = -1;
                        this.m_nextByte = -1;
                    }
                } else {
                    this.m_isInternal = new ByteArrayInputStream(this.m_newBoundaryStartCRLF);
                }
            } else if (line.equals(this.m_sOldBoundaryEnd)) {
                if (this.m_bIncludeBoundaryEnd) {
                    this.m_isInternal = new ByteArrayInputStream(this.m_newBoundaryEndCRLF);
                } else {
                    currentByte = -1;
                    this.m_nextByte = -1;
                }
            } else {
                this.m_isInternal = out.convert();
            }
        }
        return currentByte;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

