/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Scheduler {
    private LinkedHashMap taskList = new LinkedHashMap();
    private Task roottask = new Task("$$$root$$$", null);
    private final String roottaskname = "$$$root$$$";
    private Map visitedList = null;
    private Map evaluatedList = null;
    private ArrayList sortedObjList = null;
    private ArrayList cyclicKeyList = null;
    private ArrayList cyclicObjList = null;
    private ArrayList finalsortedObjList = null;
    private ArrayList finalcyclicKeyList = null;
    private ArrayList finalcyclicObjList = null;

    public boolean addTask(String name, Object obj) {
        if (this.taskList.containsKey(name)) {
            return false;
        }
        Task oTask = new Task(name, obj);
        this.taskList.put(name, oTask);
        return true;
    }

    public boolean removeTask(String name) {
        if (!this.taskList.containsKey(name)) {
            return false;
        }
        this.taskList.remove(name);
        return true;
    }

    public boolean addDependency(String child, String parent) {
        if (!this.taskList.containsKey(parent) || !this.taskList.containsKey(child)) {
            return false;
        }
        if (child.equals(parent)) {
            return false;
        }
        if (!((Task)this.taskList.get(parent)).getDependent().add(child)) {
            return false;
        }
        return ((Task)this.taskList.get(child)).getParent().add(parent);
    }

    public boolean removeDependency(String child, String parent) {
        if (!this.taskList.containsKey(parent) || !this.taskList.containsKey(child)) {
            return false;
        }
        if (!((Task)this.taskList.get(parent)).getDependent().remove(child)) {
            return false;
        }
        return ((Task)this.taskList.get(child)).getParent().remove(parent);
    }

    public void compile() {
        for (Task task : this.taskList.values()) {
            if (task.getParent().size() != 0) continue;
            this.roottask.getDependent().add(task.getTaskName());
            task.getParent().add(this.roottask.getTaskName());
        }
        this.topsort_init();
        this.topsort(this.roottask);
        this.topsort_reverselist();
    }

    public boolean isCyclic() {
        return this.finalcyclicKeyList.size() > 0;
    }

    public ArrayList getCyclicKeyList() {
        return this.finalcyclicKeyList;
    }

    public ArrayList getSortedObjList() {
        return this.finalsortedObjList;
    }

    public ArrayList getCyclicObjList() {
        return this.finalcyclicObjList;
    }

    private void topsort_init() {
        this.visitedList = new HashMap();
        this.evaluatedList = new HashMap();
        this.cyclicKeyList = new ArrayList();
        this.sortedObjList = new ArrayList();
        this.cyclicObjList = new ArrayList();
        this.visitedList.put("$$$root$$$", new Boolean(false));
        this.evaluatedList.put("$$$root$$$", new Boolean(false));
        for (String key : this.taskList.keySet()) {
            this.visitedList.put(key, new Boolean(false));
            this.evaluatedList.put(key, new Boolean(false));
        }
    }

    private void topsort(Task task) {
        this.visitedList.put(task.getTaskName(), new Boolean(true));
        for (String name : task.getDependent()) {
            Boolean isVisited = (Boolean)this.visitedList.get(name);
            if (!isVisited.booleanValue()) {
                this.topsort((Task)this.taskList.get(name));
                continue;
            }
            Boolean evaluated = (Boolean)this.evaluatedList.get(name);
            if (evaluated.booleanValue()) continue;
            this.cyclicKeyList.add(task.getTaskName());
            this.cyclicObjList.add(task.getTaskObj());
        }
        this.sortedObjList.add(task.getTaskObj());
        this.evaluatedList.put(task.getTaskName(), new Boolean(true));
    }

    private void topsort_reverselist() {
        int i = 0;
        this.finalcyclicKeyList = new ArrayList();
        for (i = this.cyclicKeyList.size() - 1; i >= 0; --i) {
            this.finalcyclicKeyList.add(this.cyclicKeyList.get(i));
        }
        this.cyclicKeyList = null;
        this.finalsortedObjList = new ArrayList();
        for (i = this.sortedObjList.size() - 2; i >= 0; --i) {
            this.finalsortedObjList.add(this.sortedObjList.get(i));
        }
        this.sortedObjList = null;
        this.finalcyclicObjList = new ArrayList();
        for (i = this.cyclicObjList.size() - 1; i >= 0; --i) {
            this.finalcyclicObjList.add(this.cyclicObjList.get(i));
        }
        this.cyclicObjList = null;
    }

    private class Task {
        private String taskname = null;
        private Object taskobj = null;
        private Set dependent = null;
        private Set parent = null;

        private Task(String name, Object obj) {
            this.taskname = name;
            this.taskobj = obj;
            this.dependent = new LinkedHashSet();
            this.parent = new LinkedHashSet();
        }

        public String getTaskName() {
            return this.taskname;
        }

        public Object getTaskObj() {
            return this.taskobj;
        }

        public Set getDependent() {
            return this.dependent;
        }

        public Set getParent() {
            return this.parent;
        }
    }
}

