/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.util.StreamSizeException;
import java.io.IOException;
import java.io.InputStream;

public class SizeLimitedInputStream
extends InputStream {
    private long maxsize = 0L;
    private long bytesread = 0L;
    private InputStream in = null;

    public SizeLimitedInputStream(InputStream in, long maxsize) throws IOException {
        this.in = in;
        if (maxsize <= 0L) {
            throw new StreamSizeException();
        }
        this.maxsize = maxsize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nbytes = this.in.read(b, off, len);
        if (nbytes > 0) {
            this.bytesread += (long)nbytes;
            if (this.bytesread > this.maxsize) {
                throw new StreamSizeException();
            }
        }
        return nbytes;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesread <= this.maxsize) {
            ++this.bytesread;
            return this.in.read();
        }
        throw new StreamSizeException();
    }
}

