/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import java.util.ArrayList;
import java.util.List;

public final class StopWatchTimer {
    private static final int STATUS_UNINITIALIZED = 0;
    private static final int STATUS_STARTED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_STOPPED = 3;
    private long m_lElapsedTime = 0L;
    private long m_lLastCheckPointTime = 0L;
    private long m_lStartTime = 0L;
    private StopWatchTimer m_parent = null;
    private List m_childList = null;
    private int m_status = 0;
    private Object m_mutex = new Object();

    public StopWatchTimer() {
    }

    private StopWatchTimer(StopWatchTimer parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StopWatchTimer createChild() {
        StopWatchTimer childTimer = new StopWatchTimer(this);
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_childList == null) {
                this.m_childList = new ArrayList();
            }
            this.m_childList.add(childTimer);
        }
        return childTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyChild(StopWatchTimer childTimer) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_childList.remove(childTimer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_status != 1) {
                this.m_status = 1;
                this.m_lElapsedTime = 0L;
                this.m_lLastCheckPointTime = this.m_lStartTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_status == 1) {
                boolean pause = true;
                if (this.m_childList != null) {
                    int childListSize = this.m_childList.size();
                    for (int i = 0; i < childListSize; ++i) {
                        if (((StopWatchTimer)this.m_childList.get(i)).getStatus() != 1) continue;
                        pause = false;
                        break;
                    }
                }
                if (pause) {
                    this.m_status = 2;
                    this.m_lElapsedTime += System.currentTimeMillis() - this.m_lLastCheckPointTime;
                }
            }
        }
        if (this.m_parent != null) {
            this.m_parent.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_status == 2) {
                this.m_status = 1;
                this.m_lLastCheckPointTime = System.currentTimeMillis();
            }
        }
        if (this.m_parent != null) {
            this.m_parent.unpause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_mutex;
        synchronized (object) {
            boolean stop = true;
            if (this.m_childList != null) {
                int childListSize = this.m_childList.size();
                for (int i = 0; i < childListSize; ++i) {
                    if (((StopWatchTimer)this.m_childList.get(i)).getStatus() != 1) continue;
                    stop = false;
                    break;
                }
            }
            if (stop) {
                this.m_status = 3;
                this.m_lElapsedTime += System.currentTimeMillis() - this.m_lLastCheckPointTime;
            }
        }
        if (this.m_parent != null) {
            this.m_parent.destroyChild(this);
        }
    }

    public StopWatchTimer getParent() {
        return this.m_parent;
    }

    public long getElapseTime() {
        return this.m_lElapsedTime;
    }

    public long getStartTime() {
        return this.m_lStartTime;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String toXMLString() {
        StringBuffer xmlBuf = new StringBuffer();
        xmlBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xmlBuf.append("<timing>");
        xmlBuf.append("<start>");
        xmlBuf.append(Long.toString(this.m_lStartTime));
        xmlBuf.append("</start>");
        xmlBuf.append("<end>");
        xmlBuf.append(Long.toString(this.m_lLastCheckPointTime));
        xmlBuf.append("</end>");
        xmlBuf.append("<elapse>");
        xmlBuf.append(Long.toString(this.m_lElapsedTime));
        xmlBuf.append("</elapse>");
        xmlBuf.append("</timing>");
        return xmlBuf.toString();
    }
}

