/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.XTSException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.ibm.cognos.tds.TDS;
import com.ibm.cognos.tds.TDSFactory;
import java.util.ArrayList;
import java.util.List;

public class TDSStorageHelper {
    public static TDSStorageHelper instance = new TDSStorageHelper(false);
    public static String MATCHTYPE_STARTSWITH = "starts-with";
    public static final String DEFAULT_COMPONENT_ID = "PS";
    private volatile TDS tdsDefaultImpl = null;
    private boolean isReportErrors;

    public static TDSStorageHelper createInstance(boolean isReportErrors) {
        return new TDSStorageHelper(isReportErrors);
    }

    protected TDSStorageHelper(boolean isReportErrors) {
        this.isReportErrors = isReportErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TDS getTDSImpl(String componentID) {
        if (DEFAULT_COMPONENT_ID.equals(componentID)) {
            if (this.tdsDefaultImpl == null) {
                TDSStorageHelper tDSStorageHelper = this;
                synchronized (tDSStorageHelper) {
                    if (this.tdsDefaultImpl == null) {
                        this.tdsDefaultImpl = TDSFactory.getTDS((String)DEFAULT_COMPONENT_ID);
                    }
                }
            }
            return this.tdsDefaultImpl;
        }
        return TDSFactory.getTDS((String)componentID);
    }

    public void forceException(boolean b) {
    }

    public String putValue(String componentID, String sessionId, String name, String value) throws XTSException {
        TDS tdsImpl = this.getTDSImpl(componentID);
        if (value == null) {
            value = "";
        }
        IXTSLogger traceLogger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger.log(null, 8, "TDS putValue::sessionId=" + sessionId + ", name=" + name + ", value=" + value, null, null);
        }
        try {
            return tdsImpl.putValue(name, sessionId, value);
        }
        catch (Exception e) {
            if (this.isReportErrors) {
                throw new XTSException("tds.error", e);
            }
            return null;
        }
    }

    public String getValue(String componentID, String sessionId, String name) throws XTSException {
        String value;
        block3: {
            TDS tdsImpl = this.getTDSImpl(componentID);
            value = null;
            try {
                value = tdsImpl.getValue(name, sessionId);
            }
            catch (Exception e) {
                if (!this.isReportErrors) break block3;
                throw new XTSException("tds.error", e);
            }
        }
        IXTSLogger traceLogger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger.log(null, 8, "TDS getValue::sessionId=" + sessionId + ", name=" + name + ", value=" + value, null, null);
        }
        return value;
    }

    public void removeValue(String componentID, String sessionId, String name) throws XTSException {
        block2: {
            TDS tdsImpl = this.getTDSImpl(componentID);
            try {
                tdsImpl.removeValue(name, sessionId);
            }
            catch (Exception e) {
                if (!this.isReportErrors) break block2;
                throw new XTSException("tds.error", e);
            }
        }
    }

    public String putMappedValue(String componentID, String sessionId, String mapId, String name, String value) throws XTSException {
        TDS tdsImpl = this.getTDSImpl(componentID);
        if (value == null) {
            value = "";
        }
        IXTSLogger traceLogger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger.log(null, 8, "TDS putValue::sessionId=" + sessionId + ", name=" + name + ", value=" + value, null, null);
        }
        try {
            return tdsImpl.putMappedValue(mapId, sessionId, name, value);
        }
        catch (Exception e) {
            if (this.isReportErrors) {
                throw new XTSException("tds.error", e);
            }
            return null;
        }
    }

    public String getMappedValue(String componentID, String sessionId, String mapId, String name) throws XTSException {
        String value;
        block3: {
            TDS tdsImpl = this.getTDSImpl(componentID);
            value = null;
            try {
                value = tdsImpl.getMappedValue(mapId, sessionId, name);
            }
            catch (Exception e) {
                if (!this.isReportErrors) break block3;
                throw new XTSException("tds.error", e);
            }
        }
        IXTSLogger traceLogger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger.log(null, 8, "TDS getValue::sessionId=" + sessionId + ", name=" + name + ", value=" + value, null, null);
        }
        return value;
    }

    public List<NameValue> getMappedValueList(String componentID, String sessionId, String mapId, String name, String matchType) throws XTSException {
        TDS tdsImpl = this.getTDSImpl(componentID);
        ArrayList<NameValue> result = new ArrayList<NameValue>();
        List<String> names = this.getMappedNamesForSession(componentID, sessionId, mapId, name, matchType);
        for (String k : names) {
            if (!k.startsWith(name)) continue;
            String v = this.getMappedValue(componentID, sessionId, mapId, k);
            result.add(new NameValue(k, v));
        }
        return result;
    }

    public void removeMappedValue(String componentID, String sessionId, String mapId, String name) throws XTSException {
        block2: {
            TDS tdsImpl = this.getTDSImpl(componentID);
            try {
                tdsImpl.removeMappedValue(mapId, sessionId, name);
            }
            catch (Exception e) {
                if (!this.isReportErrors) break block2;
                throw new XTSException("tds.error", e);
            }
        }
    }

    public List<String> getMappedNamesForSession(String componentID, String sessionId, String mapId, String name, String matchType) throws XTSException {
        ArrayList<String> names;
        TDS tdsImpl = this.getTDSImpl(componentID);
        try {
            names = tdsImpl.getMappedValuesForSession(mapId, sessionId);
        }
        catch (Exception e) {
            if (this.isReportErrors) {
                throw new XTSException("tds.error", e);
            }
            names = new ArrayList<String>();
        }
        if (matchType == null || "".equals(matchType)) {
            return names;
        }
        ArrayList<String> matchedNames = new ArrayList<String>();
        for (String k : names) {
            if (MATCHTYPE_STARTSWITH.equals(matchType)) {
                if (!k.startsWith(name)) continue;
                matchedNames.add(k);
                continue;
            }
            throw new XTSException("match type not supported in TDSStorageHelper");
        }
        return matchedNames;
    }

    @Deprecated
    public String putValue(String sessionId, String name, String value) throws XTSException {
        return this.putValue(DEFAULT_COMPONENT_ID, sessionId, name, value);
    }

    @Deprecated
    public String getValue(String sessionId, String name) throws XTSException {
        return this.getValue(DEFAULT_COMPONENT_ID, sessionId, name);
    }

    @Deprecated
    public void removeValue(String sessionId, String name) throws XTSException {
        this.removeValue(DEFAULT_COMPONENT_ID, sessionId, name);
    }

    @Deprecated
    public String putMappedValue(String sessionId, String mapId, String name, String value) throws XTSException {
        return this.putMappedValue(DEFAULT_COMPONENT_ID, sessionId, mapId, name, value);
    }

    @Deprecated
    public String getMappedValue(String sessionId, String mapId, String name) throws XTSException {
        return this.getMappedValue(DEFAULT_COMPONENT_ID, sessionId, mapId, name);
    }

    @Deprecated
    public List<NameValue> getMappedValueList(String sessionId, String mapId, String name, String matchType) throws XTSException {
        return this.getMappedValueList(DEFAULT_COMPONENT_ID, sessionId, mapId, name, matchType);
    }

    @Deprecated
    public void removeMappedValue(String sessionId, String mapId, String name) throws XTSException {
        this.removeMappedValue(DEFAULT_COMPONENT_ID, sessionId, mapId, name);
    }

    @Deprecated
    public List<String> getMappedNamesForSession(String sessionId, String mapId, String name, String matchType) throws XTSException {
        return this.getMappedNamesForSession(DEFAULT_COMPONENT_ID, sessionId, mapId, name, matchType);
    }

    public class NameValue {
        public String name;
        public String value;

        NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

