/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.ext.URLEncoderDecoder;
import java.io.IOException;
import java.io.Writer;

public class URLEncodedCharacterWriter
extends Writer {
    private String m_encoding = null;
    private Writer m_writer = null;

    private URLEncodedCharacterWriter() {
    }

    public URLEncodedCharacterWriter(Writer writer, String encoding) {
        if (writer == null) {
            throw new NullPointerException("Null writer provided to EncodedCharacterWriter constructor.");
        }
        if (encoding == null) {
            throw new NullPointerException("Null encoding provided to EncodedCharacterWriter constructor.");
        }
        this.m_writer = writer;
        this.m_encoding = encoding;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        URLEncoderDecoder.encode(new String(cbuf, off, len), this.m_encoding, true, this.m_writer);
    }

    @Override
    public void flush() throws IOException {
        this.m_writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_writer.close();
    }
}

