/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.util.xmlutil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLInputStreamToReader
extends DefaultHandler
implements LexicalHandler {
    public static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final char OPEN_BRACKET_START = '<';
    private static final char OPEN_BRACKET_END = '>';
    private static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    private static final char CLOSE_BRACKET_END = '>';
    private static final char[] PROCESSING_INSTRUCTION_START = new char[]{'<', '?'};
    private static final char[] PROCESSING_INSTRUCTION_END = new char[]{'?', '>'};
    private static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};
    private static final char EQUALS = '=';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private String m_currentEntity = null;
    private StringBuffer m_resultBuf = null;
    private XMLFilter m_xmlFilter = null;
    private HashMap m_workingPrefixNSMap = new HashMap();

    private XMLInputStreamToReader(XMLFilter xmlFilter) {
        this.m_xmlFilter = xmlFilter;
        this.m_resultBuf = new StringBuffer();
    }

    private XMLInputStreamToReader() {
        this.m_resultBuf = new StringBuffer();
    }

    public static Reader convert(InputStream xmlInputStream) throws SAXException, IOException, XTSException {
        return XMLInputStreamToReader.convert(xmlInputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader convert(InputStream xmlInputStream, XMLFilter xmlFilter) throws SAXException, IOException, XTSException {
        XMLInputStreamToReader isToRdr = new XMLInputStreamToReader();
        AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
        try {
            XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
            if (xmlFilter != null) {
                xmlFilter.setParent(reader);
                reader = xmlFilter;
            }
            reader.setContentHandler(isToRdr);
            reader.setProperty(LEXICALHANDLER_PROPERTY, isToRdr);
            reader.parse(new InputSource(xmlInputStream));
        }
        finally {
            XTSSAXParserPool.getInstance().put(parser);
        }
        return isToRdr.getResult();
    }

    private Reader getResult() {
        if (this.m_resultBuf != null) {
            return new StringReader(this.m_resultBuf.toString());
        }
        return null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_workingPrefixNSMap.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_workingPrefixNSMap.remove(prefix);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentEntity != null) {
            this.m_resultBuf.append(xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
        } else {
            this.m_resultBuf.append(ch, start, length);
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_resultBuf.append(ch, start, length);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        this.m_resultBuf.append('<');
        this.m_resultBuf.append(qName);
        int attlen = atts.getLength();
        for (int i = 0; i < attlen; ++i) {
            this.m_resultBuf.append(' ');
            this.m_resultBuf.append(atts.getQName(i));
            this.m_resultBuf.append('=');
            this.m_resultBuf.append('\"');
            xmlutil.xmlencode(atts.getValue(i), this.m_resultBuf);
            this.m_resultBuf.append('\"');
        }
        if (!this.m_workingPrefixNSMap.isEmpty()) {
            Iterator it = this.m_workingPrefixNSMap.entrySet().iterator();
            String prefix = null;
            Map.Entry pair = null;
            while (it.hasNext()) {
                pair = it.next();
                this.m_resultBuf.append(' ');
                this.m_resultBuf.append(XMLNS);
                prefix = (String)pair.getKey();
                if (prefix.length() > 0) {
                    this.m_resultBuf.append(':');
                    this.m_resultBuf.append((String)pair.getKey());
                }
                this.m_resultBuf.append('=');
                this.m_resultBuf.append('\"');
                this.m_resultBuf.append((String)pair.getValue());
                this.m_resultBuf.append('\"');
            }
            this.m_workingPrefixNSMap.clear();
        }
        this.m_resultBuf.append('>');
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.m_resultBuf.append(CLOSE_BRACKET_START);
        this.m_resultBuf.append(qName);
        this.m_resultBuf.append('>');
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.m_resultBuf.append(PROCESSING_INSTRUCTION_START);
        this.m_resultBuf.append(target);
        this.m_resultBuf.append(' ');
        this.m_resultBuf.append(data);
        this.m_resultBuf.append(PROCESSING_INSTRUCTION_END);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_resultBuf.append(CDATA_START, 0, CDATA_START.length);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_resultBuf.append(CDATA_END, 0, CDATA_END.length);
    }

    @Override
    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
    }
}

