/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.util.RWLockManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public final class XTSObjectCache {
    public static final int DEFAULT_CACHE_SIZE = 25;
    private int m_iCacheSize = 25;
    private HashMap m_oCacheObjectMap = new HashMap();
    private LinkedList m_oOrderMap = new LinkedList();
    private RWLockManager m_oLockObject = new RWLockManager(new Object());

    public void clearCache() throws InterruptedException {
        this.m_oLockObject.writeLock();
        try {
            this.m_oCacheObjectMap.clear();
            this.m_oOrderMap.clear();
        }
        finally {
            this.m_oLockObject.releaseWriteLock();
        }
    }

    public boolean isCachingEnabled() throws InterruptedException {
        boolean enabled = false;
        this.m_oLockObject.readLock();
        try {
            enabled = this.m_iCacheSize > 0;
        }
        finally {
            this.m_oLockObject.releaseReadLock();
        }
        return enabled;
    }

    public void setCacheSize(int size) throws InterruptedException {
        this.m_oLockObject.writeLock();
        try {
            this.m_iCacheSize = size;
        }
        finally {
            this.m_oLockObject.releaseWriteLock();
        }
    }

    public Object getObject(String key) throws InterruptedException {
        Object obj = null;
        this.m_oLockObject.readLock();
        try {
            obj = this.m_oCacheObjectMap.get(key);
        }
        finally {
            this.m_oLockObject.releaseReadLock();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(String key, Object obj) throws InterruptedException {
        this.m_oLockObject.writeLock();
        try {
            if (this.m_oCacheObjectMap.get(key) == null) {
                String sRKey;
                if (this.m_oCacheObjectMap.size() >= this.m_iCacheSize && this.m_oOrderMap.size() > 0 && (sRKey = (String)this.m_oOrderMap.removeFirst()) != null) {
                    this.m_oCacheObjectMap.remove(sRKey);
                }
                if (this.m_oCacheObjectMap.size() + 1 <= this.m_iCacheSize) {
                    this.m_oCacheObjectMap.put(key, obj);
                }
                this.m_oOrderMap.addLast(key);
            }
        }
        finally {
            this.m_oLockObject.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceObject(String key, Object obj) throws InterruptedException {
        this.m_oLockObject.writeLock();
        try {
            String sRKey;
            if (this.m_oCacheObjectMap.get(key) == null && this.m_oCacheObjectMap.size() >= this.m_iCacheSize && this.m_oOrderMap.size() > 0 && (sRKey = (String)this.m_oOrderMap.removeFirst()) != null) {
                this.m_oCacheObjectMap.remove(sRKey);
            }
            if (this.m_oCacheObjectMap.size() + 1 <= this.m_iCacheSize) {
                this.m_oCacheObjectMap.put(key, obj);
            }
            this.m_oOrderMap.addLast(key);
        }
        finally {
            this.m_oLockObject.releaseWriteLock();
        }
    }

    public Iterator getIterator() throws InterruptedException {
        Iterator it = null;
        this.m_oLockObject.readLock();
        try {
            it = this.m_oCacheObjectMap.entrySet().iterator();
        }
        finally {
            this.m_oLockObject.releaseReadLock();
        }
        return it;
    }
}

