/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.util;

import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.request.XTSBusRequestUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public final class XTSOutputHeaderUtil {
    private static boolean existed(Element e, String name, String domain) {
        List eleList = e.elements();
        for (int i = 0; i < eleList.size(); ++i) {
            String itemName = ((Element)eleList.get(i)).element("name").getText();
            String itemDomain = null;
            Element domainElement = ((Element)eleList.get(i)).element("domain");
            if (domainElement != null) {
                itemDomain = domainElement.getText();
            }
            if (itemName == null || !itemName.equals(name)) continue;
            if (itemDomain == null && domain == null) {
                return true;
            }
            if (itemDomain == null || domain == null || !itemDomain.equals(domain)) continue;
            return true;
        }
        return false;
    }

    private static Element mergeSetCookieVarsElement(Element source, Element overrides) {
        if (source == null) {
            return overrides;
        }
        if (overrides == null) {
            return source;
        }
        Element result = overrides;
        try {
            boolean modified = false;
            List eleList = source.elements();
            for (int i = 0; i < eleList.size(); ++i) {
                Element itemElement = (Element)eleList.get(i);
                String itemName = itemElement.element("name").getText();
                String itemDomain = null;
                Element domainElement = itemElement.element("domain");
                if (domainElement != null) {
                    itemDomain = domainElement.getText();
                }
                if (itemName == null || XTSOutputHeaderUtil.existed(result, itemName, itemDomain)) continue;
                result.add(itemElement.createCopy());
                modified = true;
            }
            if (modified) {
                eleList = result.elements();
                result.addAttribute(XTSBusRequestUtil.SOAPENC_ARRAYTYPE, "bus:setCookieVar[" + eleList.size() + "]");
            }
        }
        catch (Exception e) {
            return overrides;
        }
        return result;
    }

    public static void setSoapHeader(Element soapHeader, Document rootDoc) {
        if (soapHeader != null && rootDoc != null) {
            Element soapHdrSetCookieVarsElem = null;
            boolean bUpdateHeader = false;
            Element camCopy = null;
            Element cafCopy = null;
            Element credentialElem = null;
            Element biBusHdrElem = soapHeader.element("biBusHeader");
            if (biBusHdrElem != null) {
                Element camElem;
                Element hdrSessionElem = biBusHdrElem.element("hdrSession");
                if (hdrSessionElem != null && (soapHdrSetCookieVarsElem = hdrSessionElem.element("setCookieVars")) != null && soapHdrSetCookieVarsElem.element("item") != null) {
                    bUpdateHeader = true;
                }
                if (bUpdateHeader && (camElem = biBusHdrElem.element("CAM")) != null) {
                    camCopy = camElem.createCopy();
                    credentialElem = XTSBusRequestUtil.getXTSCredentialElement(camElem);
                    Element cafElem = biBusHdrElem.element("CAF");
                    if (cafElem != null) {
                        cafCopy = cafElem.createCopy();
                    }
                }
            }
            Element rootElem = rootDoc.getRootElement();
            Element output = rootElem.element("output");
            Element protocolHeader = null;
            if (output == null) {
                output = rootElem.addElement("output");
                protocolHeader = output.addElement(XTSConstants.ELEM_NM_PROTOCOLHEADER);
            } else {
                protocolHeader = output.element(XTSConstants.ELEM_NM_PROTOCOLHEADER);
                if (protocolHeader == null) {
                    protocolHeader = output.addElement(XTSConstants.ELEM_NM_PROTOCOLHEADER);
                } else {
                    List setSoapHdrParamList = XTSConstants.getParamSetSoapHeaderList(protocolHeader);
                    for (int j = 0; j < setSoapHdrParamList.size(); ++j) {
                        Element outputSetCookieVarsElem;
                        Element outputHdrSessionElem;
                        Element outputBiBusHdrElem;
                        Element outputSetSoapHdr = (Element)setSoapHdrParamList.get(j);
                        outputSetSoapHdr.detach();
                        Element outputHdrElem = outputSetSoapHdr.element("Header");
                        if (outputHdrElem == null || (outputBiBusHdrElem = outputHdrElem.element("biBusHeader")) == null || (outputHdrSessionElem = outputBiBusHdrElem.element("hdrSession")) == null || (outputSetCookieVarsElem = outputHdrSessionElem.element("setCookieVars")) == null || outputSetCookieVarsElem.element("item") == null) continue;
                        soapHdrSetCookieVarsElem = XTSOutputHeaderUtil.mergeSetCookieVarsElement(outputSetCookieVarsElem, soapHdrSetCookieVarsElem);
                        bUpdateHeader = true;
                    }
                }
            }
            Element paramElement = protocolHeader.addElement(XTSConstants.ELEM_NM_PARAM);
            paramElement.addAttribute("name", "setSoapHeader");
            paramElement.add(soapHeader);
            if (bUpdateHeader) {
                Element oldCredentialElement;
                Element setCookieVarsCopy = soapHdrSetCookieVarsElem.createCopy();
                Element header = rootElem.element("header");
                Element biBusHeader = null;
                if (header == null) {
                    header = rootElem.addElement("header");
                } else {
                    biBusHeader = header.element("biBusHeader");
                }
                Element sessionHeader = null;
                if (biBusHeader == null) {
                    biBusHeader = header.addElement("biBusHeader");
                    sessionHeader = biBusHeader.addElement("hdrSession");
                } else {
                    sessionHeader = biBusHeader.element("hdrSession");
                    if (sessionHeader == null) {
                        sessionHeader = biBusHeader.addElement("hdrSession");
                    } else {
                        Element oldCAMElement;
                        Element oldSetCookieElement = sessionHeader.element("setCookieVars");
                        if (oldSetCookieElement != null && setCookieVarsCopy != null) {
                            oldSetCookieElement.detach();
                        }
                        if ((oldCAMElement = biBusHeader.element("CAM")) != null && camCopy != null) {
                            oldCAMElement.detach();
                            Element oldCAFElement = biBusHeader.element("CAF");
                            if (oldCAFElement != null && cafCopy != null) {
                                oldCAFElement.detach();
                            }
                        }
                    }
                }
                if (setCookieVarsCopy != null) {
                    sessionHeader.add(setCookieVarsCopy);
                }
                if (camCopy != null) {
                    biBusHeader.add(camCopy);
                    if (cafCopy != null) {
                        biBusHeader.add(cafCopy);
                    }
                }
                if ((oldCredentialElement = rootElem.element("credential")) != null && credentialElem != null) {
                    oldCredentialElement.detach();
                }
                if (credentialElem != null) {
                    rootElem.add(credentialElem);
                }
            }
        }
    }
}

